; examples.scm is -*- Scheme -*-
;
; Bryan's Object System
;
; (C) 1994 Bryan O'Sullivan <bosullvn@maths.tcd.ie>

; Simple example and test functions.

(define-class <point> (<class>) (x y))

(specialise! initialise <point>
  (lambda (call-next-method self . args)
    (let ((x (get-arg args 'x))
	  (y (get-arg args 'y)))
      (slot-set! self 'x x)
      (slot-set! self 'y y)
      (display (list 'x x 'y y))
      (newline))))

(define-object pt <point> 'x 1 'y 2)

(define-class <3point> (<point>) (z))

(specialise! initialise <3point>
  (lambda (call-next-method self . args)
    (call-next-method)
    (let ((z (get-arg args 'z)))
      (slot-set! self 'z z)
      (display (list 'z z))
      (newline))))

(define-object pt3 <3point> 'x 4 'y 7 'z 8)

(define-generic print-me)

(specialise! print-me <point>
  (lambda (call-next-method self)
    (display (list 'x (slot-ref self 'x)))
    (newline)
    (display (list 'y (slot-ref self 'y)))
    (newline)))

(specialise! print-me <3point>
  (lambda (call-next-method self)
    (call-next-method)
    (display (list 'z (slot-ref self 'z)))
    (newline)))

(define-class <complex> (<class>) (re im))

(specialise! initialise <complex>
  (lambda (call-next-method self . args)
    (slot-set! self 're (get-arg args 're 0))
    (slot-set! self 'im (get-arg args 'im 0))))
