/*
 * sym-prim.c -- Implementation of Scheme's primitive symbol procedures
 *
 * (C) m.b (Matthias Blume); Jun 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) sym-prim.c (C) M.Blume, Princeton University, 2.5"
 */

# ident "@(#)sym-prim.c	(C) M.Blume, Princeton University, 2.5"

# include <stdlib.h>
# include <string.h>

# include "storage.h"
# include "Cont.h"
# include "Symbol.h"
# include "String.h"
# include "Boolean.h"
# include "type.h"
# include "except.h"
# include "tmpstring.h"

# include "builtins.tab"

/*ARGSUSED*/
unsigned ScmPrimitiveSymbolP (unsigned argcnt)
{
  void *tmp = PEEK ();

  SET_TOP (ScmTypeOf (tmp) == ScmType (Symbol) ? &ScmTrue : &ScmFalse);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveSymbolToString (unsigned argcnt)
{
  void *sym = PEEK ();
  ScmString *string;
  unsigned len;

  if (ScmTypeOf (sym) != ScmType (Symbol))
    error ("bad arg to primitive procedure symbol->string: %w", sym);
  len = ((ScmSymbol *) sym)->length;
  SCM_VNEW (string, String, len, char);
  string->length = len;
  sym = PEEK ();
  memcpy (string->array, ((ScmSymbol *) sym)->array, len);
  SET_TOP (string);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveStringToSymbol (unsigned argcnt)
{
  void *tmp = PEEK ();
  ScmSymbol *sym;
  ScmString *string;
  char *buf;

  if (ScmTypeOf (tmp) != ScmType (String))
    error ("bad arg to primitive procedure string->symbol: %w", tmp);
  string = tmp;
  buf = tmpstring (string->array, string->length);
  sym = ScmMakeSymbol (buf, string->length);
  SET_TOP (sym);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveGetProperties (unsigned argcnt)
{
  void *tmp = PEEK ();

  if (ScmTypeOf (tmp) != ScmType (Symbol))
    error ("bad arg to primitive procedure get-properties: %w", tmp);
  tmp = ((ScmSymbol *) tmp)->properties;
  if (tmp == NULL)
    tmp = &ScmFalse;
  SET_TOP (tmp);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveSetProperties (unsigned argcnt)
{
  void *tmp = POP ();
  void *val = PEEK ();

  if (ScmTypeOf (tmp) != ScmType (Symbol))
    error ("bad arg to primtive procedure set-properties!: %w", tmp);
  ((ScmSymbol *) tmp)->properties = val;
  return 0;
}
