/*
 * keyword.h -- Declarations for variables, which hold the Scheme keywords
 *
 * (C) m.b (Matthias Blume); Apr 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) keyword.h (C) M.Blume, Princeton University, 2.1"
 */

# ifndef KEYWORD_H_
# define KEYWORD_H_

typedef
struct ScmKeyword {
  void *ptr;
  const char *name;
} ScmKeyword;

extern ScmKeyword ScmKeyword_array [5];

# define ScmDefinePtr		(ScmKeyword_array[0].ptr)
# define ScmQuasiquotePtr	(ScmKeyword_array[1].ptr)
# define ScmQuotePtr		(ScmKeyword_array[2].ptr)
# define ScmUnquotePtr		(ScmKeyword_array[3].ptr)
# define ScmUnquoteSplicingPtr	(ScmKeyword_array[4].ptr)

extern void ScmInitializeKeywords (void);

# endif
