/*
 * identifier.c -- Mapping between object identifiers and descriptions
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) identifier.c (C) M.Blume, Princeton University, 2.2"
 */

# ident "@(#)identifier.c	(C) M.Blume, Princeton University, 2.2"

# include "storage.h"
# include "identifier.h"
# include "type.h"

# include "Boolean.h"
# include "Character.h"
# include "Cons.h"
# include "Cell.h"
# include "Procedure.h"
# include "Promise.h"
# include "String.h"
# include "Symbol.h"
# include "Vector.h"
# include "Cont.h"
# include "Primitive.h"
# include "Code.h"
# include "Port.h"
# include "Numeric.h"
# include "Corout.h"

# define IDENTIFIER(x) ScmType (x),
MEM_descriptor MEM_identifier_map [] = {
# include "ident.tab"
};
# undef IDENTIFIER

unsigned const MEM_identifier_map_length = IDENTIFIER_MAP_LENGTH;
