/*
 * Symbol.h -- Declarations for Scheme Symbols
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) Symbol.h (C) M.Blume, Princeton University, 2.3"
 */

# ifndef SYMBOL_H_
# define SYMBOL_H_

# include "storage.h"

typedef
struct ScmSymbol {
  MEM_descriptor _;
  struct ScmSymbol *hashlink;
  void *value;			/* in global environment */
  void *properties;		/* extension to core scheme */
  short strong;			/* for GC */
  unsigned short length;
  char array[1];
} ScmSymbol;

DCL_MEM_TYPE (Symbol);

extern
void *ScmMakeSymbol (const char *name, unsigned length);

extern void ScmInitSymtab (void);

# endif
