/*
 * bool-prim.c -- Implementation of Scheme's primitives for Booleans
 *
 * (C) m.b (Matthias Blume); May 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) bool-prim.c (C) M.Blume, Princeton University, 2.2"
 */

# ident "@(#)bool-prim.c	(C) M.Blume, Princeton University, 2.2"

# include "Boolean.h"
# include "Cont.h"

# include "builtins.tab"

unsigned ScmPrimitiveNot (unsigned argcnt)
{
  SET_TOP (PEEK () == &ScmFalse ? &ScmTrue : &ScmFalse);
  return 0;
}

unsigned ScmPrimitiveBooleanP (unsigned argcnt)
{
  void *tmp = PEEK ();

  SET_TOP (tmp == &ScmFalse || tmp == &ScmTrue ? &ScmTrue : &ScmFalse);
  return 0;
}

unsigned ScmPrimitiveEofObjectP (unsigned argcnt)
{
  SET_TOP (PEEK () == &ScmEof ? &ScmTrue : &ScmFalse);
  return 0;
}
