/*
 * Vector.h -- Declarations for Scheme Vectors
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) Vector.h (C) M.Blume, Princeton University, 2.3"
 */

# ifndef VECTOR_H_
# define VECTOR_H_

# include "storage.h"

typedef
struct ScmVector {
  MEM_descriptor _;
  unsigned long length;
  void *array[1];
} ScmVector;

DCL_MEM_TYPE (Vector);

# define SCM_NEW_VECTOR(v,l) \
  (SCM_VNEW (v, Vector, l, void *), (v)->length = (l))

extern ScmVector *NewScmVector (unsigned long length);

# endif
