(herald splap (env tsys))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;
        
;;; lap code is of the form (lap free-vars . code)
;;; lap templates are (lap-template (pointer scratch nargs) . code)

(define (apply-traced-operation proc . args)
  (lap (*traced-op-template*)
    (load l (d@r P (static *traced-op-template*)) parassign-extra)
    (load l (d@r parassign-extra 2) parassign-extra)
    (jbr entry)))

(define (apply proc . args)
 (lap ()                 
  (move zero parassign-extra)
entry
  (sub ($ 2) NARGS)                        ;; shift proc out
  (move A1 P)                         ;; first arg is proc
  (j= NARGS zero apply-done)
  (jn= NARGS ($ 1) next1)
  (move A2 AN)
  (jbr apply-one-arg)
next1
  (move A2 A1)
  (jn= NARGS ($ 2) next2)
  (move A3 AN)
  (jbr apply-two-args)
next2
  (move A3 A2)
  (jn= NARGS ($ 3) next3)
  (move A4 AN)                
  (jbr apply-three-args)
next3
  (move A4 A3)
  (jn= NARGS ($ 4) next4)
  (move A5 AN)                
  (jbr apply-four-args)
next4
  (move A5 A4)
  (jn= NARGS ($ 5) next5)
  (load l (d@r extra-args %%car) AN)                
  (jbr apply-five-args)
next5
  (load l (d@r extra-args %%car) A5)            ;; first argument temp
  (load l (d@r extra-args %%cdr) extra-args)
  (move extra-args extra)	;save extra args
  (sub ($ (+ *argument-registers* 1)) NARGS vector)             ;; S1 counts sown to 0
  (jbr apply-shift-test)
apply-shift-loop-top
  (sub ($ 1) vector)
  (load l (d@r extra %%cdr) extra)
apply-shift-test
  (jn= vector zero apply-shift-loop-top)
  (load l (d@r extra %%car) an)
  (store l an (d@r extra %%cdr))
count-list-test
  (j= an nil-reg apply-done)
  (load l (d@r an %%cdr) an)
  (add ($ 1) nargs)
  (jbr count-list-test)
apply-one-arg
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A1)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-two-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A2)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-three-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A3)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-four-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A4)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-five-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A5)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
  (move an extra-args)
  (jbr count-list-test)
apply-done                    
  (jn= parassign-extra zero traced)
  (load l (d@r p -2) parassign-extra)
traced
  (jr (d@r parassign-extra 2))
  (noop)))

#|
(define (*catch proc)
  (lap (t-code-catch)
    (move sp a2)			;sp
    (add ($ 2) link-reg a3)		;link
    (load l (d@nil slink/dynamic-state) a4) ;state
    (sub ($ 2) sp a5)			;frame
    (load l (d@r p (static t-code-catch)) p)
    (load l (d@r p 2) p)
    (load l (d@r p -2) extra)
    (jr (d@r extra 2))
    (move ($ 6) nargs)))

(define (invoke-stack-continuation sp vals link)
  (lap (return apply)
    (move A1 sp)
    (sub ($ 2) a3 link-reg)
    (j= A2 nil-reg no-values)
    (load l (d@r a2 %%cdr) a1)
    (jn= a1 nil-reg many-values)
    (load l (d@r A2 %%car) A1)
    (jr (d@r link-reg 0))
    (move ($ -2) NARGS)
no-values
    (jr (d@r link-reg 0))
    (move ($ -1) NARGS)
many-values
    (load l (d@r P (static return)) A1)
    (load l (d@r a1 2) a1)
    (load l (d@r P (static apply)) P)
    (load l (d@r p 2) p)
    (load l (d@r p -2) extra)
    (jr (d@r extra 2))
    (move ($ 3) NARGS)))


(define (call-with-current-continuation proc)
  (lap (t-code-call/cc)
    (save ($ -64) sp sp)
    (move sp a2)
    (load l (d@r p (static t-code-call/cc)) p)
    (load l (d@r p 2) p)
    (load l (d@r p -2) extra)
    (jalr (d@r extra 2))
    (add ($ template/return-offset) link-reg)
    (template 0 -1 t)
    (restore)
    (jr (d@r link-reg 0))
    (noop)))
    

(define (invoke-continuation sp stack val base-state current-state)
  (lap (rewind-state-and-continue)
    (move A1 SP)                    ; set new continuation
    (load l (d@nil slink/stack) scratch) ; limit at stack base
    (add ($ 2) A2)                  ; start at first word of stack in heap
    (jbr copy-stack-test)
copy-stack-loop
    (load l (d@r a2 0) extra)
    (store l extra (d@r a1 0))
    (add ($ 4) a2)
    (add ($ 4) a1)
copy-stack-test
    (j<= A1 scratch copy-stack-loop)
    (move A4 A1)
    (move A5 A2)
    (load l (d@r sp 0) link-reg)
    (add ($ 4) sp)
    (load l (d@r P (static rewind-state-and-continue)) P)
    (load l (d@r p 2) p)
    (load l (d@r p -2) extra)
    (jr (d@r extra 2))
    (move ($ 4) NARGS)))
|#
;;; (FIXNUM-HOWLONG n)
;;;   Returns the number of bits in N's binary representation.
;;;   Horrible name, after MACLISP function HAULONG.
;;;   Similar to a binary search.  Repeatedly divide the bit string in half.
;;;     If the upper half has any bits on, count all the bits in the lower
;;;     half and throw them away.

(define (fixnum-howlong num)                                           ;86/12/20
  (lap ()
    (j>= A1 zero howlong0)
    (move ($ (fx* 30 4)) A1)    ; negative fixnum, length is 30.
    (jbr howlong_exit)
howlong0
    (srl ($ 2) a1 scratch)        ; scratch holds number
    (move zero A1)             ; A1 holds result
    (movec #x8000 extra)
    (j< scratch extra howlong1)
    (add ($ (fx* 16 4)) A1)    ; add 16 to result
    (sra ($ 16) scratch)
howlong1
    (j< scratch ($ #x80) howlong2)
    (add ($ (fx* 8 4)) A1)
    (sra ($ 8) scratch)
howlong2
    (j< scratch ($ #x8) howlong3)
    (add ($ (fx* 4 4)) A1)
    (sra ($ 4) scratch)
howlong3
    (j<  scratch ($ #x2) howlong4)
    (add ($ (fx* 2 4)) A1)
    (sra ($ 2) scratch)
howlong4
    (j< scratch ($ #x1) howlong_exit)
    (add ($ (fx* 1 4)) A1)
howlong_exit
    (jr (d@r link-reg 0))
    (move ($ -2) NARGS)))


(define (*set x y)
  (lap ()
    (store l A2 (d@r A1 2))
    (load ub (d@r a1 0) scratch)
    (j= scratch zero foo-set)
    (save ($ -64) sp sp)
    (load l (d@nil slink/set) vector)
    (move A1 parassign-extra)
    (jalr (d@r vector 0))
    (add ($ template/return-offset) link-reg)
    (template 0 -1 t)
    (restore)
foo-set
    (jr (d@r link-reg 0))
    (move ($ -2) NARGS)))



(define (string-hash string)
  ;; string in A1
  (lap ()
    ;; enter critical gc
    (load l (d@r A1 offset/string-text) A3);; raw string text in A3
    (load l (d@r A1 offset/string-base) scratch)
    (add ($ 2) a3)
    (add scratch a3)
    (load l (d@r a1 -2) scratch)
    (sra ($ 8) scratch)              ;; string-length in scratch
hash-entry
    (movec #xffffff00 a4)		;byte add mask
    (move zero vector)                                 ;; counter in vector
    (move zero a1)                            ;; hash value so far in a1
    (jbr hash-test)
hash-loop
    (srl ($ 31) a1 extra)
    (sll ($ 1) a1 a1)		;rotate left 1
    (or extra a1)
    (load ub (d@r A3 0) a2)		;next char
    (add a1 a2)			;add byte
    (mask ($ #xff) a2)		;clear high bytes (carry)
    (and a4 a1)				;clear low byte
    (or a2 a1)			;complete addb
    (add ($ 1) a3)
hash-test
    (add ($ 1) vector)
    (j<= vector scratch hash-loop)
    (srl ($ 16) a1 scratch)
    (sll ($ 16) a1 vector)		;swap
    (or vector scratch)
    (xor scratch a1)
    (movec #x7ffffffc a2)		;positive fixnumify
    (and a2 a1)
    (move zero a3)
    ;; exit critical gc                      
    (jr (d@r link-reg 0))
    (move ($ -2) NARGS)))


;;;  magic frame is next-state
;;;                 winder
;;;                 previous-state
;;;                 unwinder
;;;                 *magic-frame-template*

(define (push-magic-frame unwinder stuff wind)   
 (lap (*magic-frame-template* bind-internal)
  (sub ($ 20) sp)
  (store l link-reg (d@r sp 16))
  (load l (d@nil slink/dynamic-state) AN)
  (store l nil-reg (d@r sp 12))		; next state
  (store l  A3 (d@r sp 8))		; winder
  (store l AN (d@r sp 4))		; previous state
  (store l A1 (d@r sp 0))		; unwinder
  (load l (d@r P (static *magic-frame-template*)) a3)
  (load l (d@r a3 2) a3)			;get value
  (add ($ 2) a3 link-reg)		;code for magic-frame-template
  (sub ($ 2) SP A1)			; first arg is the magic frame
  (j= AN nil-reg magic-frame-exit)	; is there a previous state?
  (store l A1 (d@r sp 12))		; set next slot to this magic frame
magic-frame-exit
  (load l (d@r P (static bind-internal)) P)   ; second arg is stuff
  (load l (d@r p 2) p)
  (load l (d@r p -2) extra)
  (jr (d@r extra 2))
  (move ($ 3) NARGS)))

                   
(define (make-structure-template size)
  (lap (*structure-template* *stype-template*)
    (save ($ -64) sp sp)
    (load l (d@r P (static *stype-template*)) AN)
    (load l (d@r an 2) an)
    (load l (d@nil slink/make-extend) vector)
    (move ($ 36) scratch)                            ; 9 slots
    (jalr (d@r vector 0))
    (add ($ template/return-offset) link-reg)
    (template 0 -1 t)
    (sra ($ 2) A1 scratch)                         ; pointer slots
    (add ($ 32) AN A1)                       ; template
    (move AN A2)                                ; stype
    (move ($ 32) extra)
    (store l extra (d@r A1 template/offset)) ; offset within closure
    (move ($ header/template) extra)
    (store b extra (d@r A1 template/header))
    (store b zero (d@r A1 template/nargs))
    (store w scratch (d@r A1 template/pointer))
    (load l (d@r P (static *structure-template*)) p)
    (load l (d@r p 2) p)
    (store l p (d@r A1 2)) ; auxilliary
    (restore)
    (jr (d@r link-reg 0))				;return two values
    (move ($ -3) NARGS)))


