(herald fix)

(define (write-data-section-header stream)   
  (write-string stream ".data")
  (vm-write-byte stream 0)
  (vm-write-byte stream #x20)
  (vm-write-byte stream #x20)
  (write-int stream (text-size))      ; phys addr
  (write-int stream (text-size))      ; virtual addr
  (write-int stream (data-size))	
  (write-int stream (+ (text-size) (headers-size)))	;offset in file
  (write-int stream (+ (headers-size) (text-size) (data-size)))	;  reloc
  (write-int stream 0)      ; no gp table
  (write-half  stream #xffff)		;reloc overflow
  (write-half stream 0)			;no gp table
  (write-int stream #x20000040))

(define (cymbal-table-offset)
  (+ (headers-size) (text-size) (data-size)
     (* RELOC-SIZE (+ reloc-length 1))))

(define (write-relocation stream)
  (write-int stream (+ reloc-length 1))	;number of relocs
  (write-int stream 0)			;R_ABS
  (walk (lambda (item)
	  (destructure (((addr . (lw .  hb)) item))
	    (write-data stream (car item))
	    (write-half stream lw)
	    (vm-write-byte stream 0)
	    (vm-write-byte stream hb)))
        (sort-list! (lstate-data-reloc *lstate*)
                    (lambda (x y)      
                       (fx< (car x) (car y))))))