(herald le_mipsis)

(define (set-16 bv i val)
  (set (bref bv i) (fixnum-logand #xff val))
  (set (bref bv (fx+ i 1)) (fixnum-logand #xff (fixnum-ashr val 8))))

(define (set-24 bv i val)
  (set (bref bv i) (fixnum-logand #xff val))
  (set (bref bv (fx+ i 1)) (fixnum-logand #xff (fixnum-ashr val 8)))
  (set (bref bv (fx+ i 2)) (fixnum-logand #xff (fixnum-ashr val 16))))



;|handler offset   | annotation offsetSHI|
;|           code vector offset          |    
;| pointer         | nargs | ?template |          

(define (template1 bv i l h)
  (set-16 bv (fx+ i 2)
       (if h
	   (fx- (address-of h) (fx+ i 10)) ;this template is at i+10
	   0))
  (set-16 bv i
       (get-template-annotation l)))

(define (template2 bv i)
  (set-24 bv i (fx+ i 8))
  (set (bref bv (fx+ i 3)) 0))

(define (template3 bv i l)
  (set-16 bv (fx+ i 2) (get-template-cells l))
  (set (bref-8-u bv (fx+ i 1)) (get-template-nargs l))
  (set (bref-8-u bv i)
       (if (template-nary l) (fx+ header/template 128) header/template)))
	   
(define (stemplate1 bv i l)
  (set-16 bv (fx+ i 2) 0)	;handler offset
  (set-16 bv i
       (if (not l) 0 (get-template-annotation l))))

(define (stemplate3 bv i l encloser)
  (set-16 bv (fx+ i 2)
       (let ((n (lambda-max-temps encloser)))
	 (if (fx= n 1) 0 (fx+ (fx- n *real-registers*) 1))))
  (set (bref-8-u bv (fx+ i 1)) (if (not l) -2 (get-template-nargs l)))
  (set (bref-8-u bv i)
       (if (and l (template-nary l))
	   (fx+ header/template 128) header/template)))
	   
(define (laptemplate3 bv i pointer nargs nary?)
  (set-16 bv (fx+ i 2) pointer)
  (set (bref-8-u bv (fx+ i 1)) nargs)
  (set (bref-8-u bv i)
       (if nary? (fx+ header/template 128) header/template)))

(define (r-type bv i op rs rt rd shamt funct)
  (set-16 bv (fx+ i 2)
       (fx-ior (fixnum-ashl op 10)
	       (fx-ior (fixnum-ashl rs 5)
		        rt)))
  (set-16 bv i
       (fx-ior (fixnum-ashl rd 11)
	       (fx-ior (fixnum-ashl shamt 6)
		       funct))))

(define (i-type bv i op rs rt immediate)
  (set-16 bv (fx+ i 2)
       (fx-ior (fixnum-ashl op 10)
	       (fx-ior (fixnum-ashl rs 5)
		        rt)))
  (set-16 bv i immediate))

(define (write-i-bytes bv i)
  (let ((write-byte
	 (lambda (byte)
	   (writec (terminal-output) (digit->char (fx-ashr byte 4) 16))  
	   (writec (terminal-output) (digit->char (fx-and byte 15) 16)))))
    (write-byte (bref-8-u bv (fx+ i 3)))
    (write-byte (bref-8-u bv (fx+ i 2)))
    (write-byte (bref-8-u bv (fx+ i 1)))
    (write-byte (bref-8-u bv i))))

