(herald n32low                                                         ;86/10/14
        (env (make-empty-early-binding-locale 'nil) constants primops arith locations))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;
                 
;;; mimics VAX

;;; RECEIVE and RETURN aren't strictly primops, but are included here because
;;; they need to be early bound.

(define-constant (return . args)                                       ;86/10/14
  (ignore args)
  (lap ()                           
    (negi d NARGS NARGS)             ; !!
    (movi d (@r sp) tp)
    (jump (@r tp))))
                 
(declare simplifier return simplify-values)                            ;86/10/14

(define-constant (receive-values recipient thunk)                      ;86/10/14
  (ignore recipient thunk)
  (lap ()
    (movi d A1 (tos))                    ; save "recipient"
    (addr (label receiver) (tos))      ; push return address
    (movi d A2 P)                      ; prepare to call thunk
    (movi d ($ 1) NARGS)               ; thunk takes no arguments
    (jump (*d@r nil-reg slink/icall))))

(lap-template (1 0 -1 t stack handle-receiver)                         ;86/10/14
receiver
    (movi d (d@r SP 4) P)              ; prepare to call recipient
    (adjspi b ($ -8))                  ; restore continuation
    (negi d NARGS NARGS)               ; !!
    (jump (*d@r nil-reg slink/icall))
handle-receiver
    (spri d nil-reg AN)
    (ret ($ 0)))

(declare simplifier receive-values simplify-receive-values)            ;86/10/14
                 

(define-constant make-pointer      ; extend and number of descriptors  ;86/10/27
  (primop make-pointer ()                                        
    ((primop.generate self node)
     (generate-make-pointer node))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) top fixnum)])))
;     '#[type (proc #f (proc #f top) extend fixnum)])))

(define-constant task-ref
  (primop task-ref ()
    ((primop.generate self node)
     (generate-task-ref node))))

(define-constant set-task-ref
  (primop set-task-ref ()
    ((primop.side-effects? self) t)
    ((primop.generate self node)
     (generate-set-task-ref node))))

(define-constant slink-ref
  (primop slink-ref ()
    ((primop.generate self node)
     (generate-slink-ref node))))

(define-constant set-slink-ref
  (primop set-slink-ref ()
    ((primop.side-effects? self) t)
    ((primop.generate self node)
     (generate-set-slink-ref node))))

(define-constant system-global
  (object (lambda (i) (slink-ref i))
    ((setter self)
     (lambda (i val) (set-slink-ref i val)))))

(define-constant process-global
  (object (lambda (i) (task-ref i))
    ((setter self)
     (lambda (i val) (set-task-ref i val)))))


(define-constant stack-pointer                                         ;86/10/27
  (primop stack-pointer ()
    ((primop.generate self node)
     (generate-stack-pointer node))))
                                                   
(define-constant current-continuation                                  ;86/10/27
  (primop current-continuation ()
    ((primop.generate self node)
     (generate-current-continuation node))))

(define-constant disable-interrupts                                    ;86/12/10
  (primop disable-interrupts ()
    ((primop.side-effects? self) t)
    ((primop.generate self node)
     (emit n32/ori b
          (machine-num #b10000000) 
          (reg-offset TASK (fx+ task/critical-count 3))))
    ((primop.type self node)
     '#[type (proc #f (proc #f top))])))

(define-constant really-enable-interrupts                              ;86/12/10
  (primop really-enable-interrupts ()
    ((primop.side-effects? self) t)
    ((primop.test-code self node arg)
     (emit n32/bici b
           (machine-num #b10000000) 
           (reg-offset TASK (fx+ task/critical-count 3)))
     (emit n32/cmpi b
           (machine-num 0)
           (reg-offset TASK (fx+ task/critical-count 3))))
    ((primop.presimplify self node)
     (presimplify-no-argument-predicate node))
    ((primop.type self node)
     '#[type (proc #f (proc #f top))])))

(define-constant (enable-interrupts)                                   ;86/12/10
  (if (not (really-enable-interrupts))
      (handle-queued-interrupt (process-global task/critical-count))))

          

;; template junk, see template.doc
                                         
                      
(define-constant template-enclosing-object                             ;86/10/28
  (primop template-enclosing-object ()
    ((primop.generate self node)
     (receive (source target rep) (one-arg-primitive node)
       (let ((reg (get-register 'scratch node '*)))
         (generate-move source target)
         (emit n32/movzid w (reg-offset target -6) reg)    ; offset field in bytes
         (emit n32/subi d reg target)
         (mark-continuation node target))))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) template)])))

(define-constant gc-extend->pair                                       ;86/10/31
  (primop gc-extend->pair ()
    ((primop.generate self node)
     (receive (source target rep) (one-arg-primitive node)
       (generate-move source target)
       (emit n32/addi d (machine-num 1) target) 
       (mark-continuation node target)))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) top)])))

(define-constant gc-pair->extend                                       ;86/10/31
  (primop gc-pair->extend ()
    ((primop.generate self node)
     (receive (source target rep) (one-arg-primitive node)
       (generate-move source target)
       (emit n32/subi d (machine-num 1) target) 
       (mark-continuation node target)))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) top)])))
;     '#[type (proc #f (proc #f pair) extend)])))

                      

(define-constant closure-enclosing-object                              ;86/10/31
  (primop closure-enclosing-object ()
    ((primop.generate self node)
     (generate-closure-enclosing-object node))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) top)])))
;     '#[type (proc #f (proc #f top) extend)])))

                                                                       ;86/10/31
(define-constant (bit-test operand bit)    ; true if bit is on
  (if (fixnum-equal? (fixnum-logand operand (fixnum-ashl 1 bit)) 0)
      '#f
      '#t))

(define-constant (template-internal-bit? tem)                          ;86/10/31
  (let ((tem (if (fixnum-equal? (mref-integer tem -2) n32-jump-absolute-hack)
                 (extend-pointer-elt tem 1)
                 tem)))
    (bit-test (mref-16-u tem -12) 0)))

(define-constant (template-superior-bit? tem) ; no cit's on stack      ;86/10/31
  (bit-test (mref-16-u tem -12) 2))

(define-constant (template-nary? tem)                                  ;86/10/31
  (bit-test (mref-8-u tem -4) 7))

(define-constant (template-pointer-slots tem)                          ;86/10/31
  (mref-8-u tem -5))

(define-constant (template-scratch-slots tem)                          ;86/10/31
  (mref-8-u tem -6))

(define-constant (template-nargs tem)                                  ;86/10/31
  (mref-8-s tem -3))

(define-constant (template-encloser-offset template)                   ;86/10/31
  (fixnum-ashr (mref-16-u template -8) 2))

(define-constant (template-handler-offset template)                    ;86/10/31
  (mref-16-u template -10))

(define-constant (closure-encloser-offset closure)                     ;86/10/31
  (fixnum-ashr (mref-16-u (extend-header closure) -6) 2))


(define-constant (unit-top-level-forms unit)                           ;86/10/31
  (make-pointer unit 3))

(define-constant (alt-bit-set? extend)   ; if bit 7 of header is on    ;86/10/31
  (fixnum-less? (mref-8-s extend -4) 0))

(define-constant set-alt-bit!                                          ;87/05/29
  (primop set-alt-bit! ()
    ((primop.side-effects? self) t)
    ((primop.generate self node)                               
     (let ((reg (->register 'pointer node (leaf-value ((call-arg 2) node)) '*)))
       (emit n32/ori b (machine-num #b10000000) (reg-offset reg -2))))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) top)])))
;     '#[type (proc #f (proc #f top) extend)])))

(define-constant clear-alt-bit!                                        ;86/10/31
  (primop clear-alt-bit! ()
    ((primop.side-effects? self) t)
    ((primop.generate self node)                               
     (let ((reg (->register 'pointer node (leaf-value ((call-arg 2) node)) '*)))
       (emit n32/bici b (machine-num #b10000000) (reg-offset reg -2))))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) top)])))
;     '#[type (proc #f (proc #f top) extend)])))

(define-constant vcell-defined? alt-bit-set?)                          ;86/10/31

(define-constant set-vcell-defined set-alt-bit!)                       ;86/10/31

(define-constant set-vcell-undefined clear-alt-bit!)                   ;86/10/31

(define-constant pure? alt-bit-set?)                                   ;86/10/31

(define-constant (purify! x)                                           ;86/10/31
  (set-alt-bit! x)
  (return))

(define (vframe-pointer-slots vframe)                                  ;86/10/31
  (mref-8-u vframe -2))

(define (vframe-scratch-slots vframe)                                  ;86/10/31
  (mref-8-u vframe -3))


