(herald n32arith                                                       ;86/11/02
        (env (make-empty-early-binding-locale 'nil) primops))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;


(define-constant fixnum-equal?                                         ;86/11/13
  (primop fixnum-equal? ()
    ((primop.generate self node)
     (fixnum-comparator node 'jneq))
    ((primop.presimplify self node)
     (presimplify-to-conditional node))
    ((primop.make-closed self)
     (make-closed-conditional self))
    ((primop.conditional? self) t)
    ((primop.conditional-type self node)
     '#[type (proc #f (proc #f) (proc #f) top fixnum fixnum)])
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean) fixnum fixnum)])))

(define-constant fixnum-less?                                          ;86/11/13
  (primop fixnum-less? ()
    ((primop.generate self node)
     (fixnum-comparator node 'jgeq))
    ((primop.presimplify self node)
     (presimplify-to-conditional node))
    ((primop.make-closed self)
     (make-closed-conditional self))
    ((primop.conditional? self) t)
    ((primop.conditional-type self node)
     '#[type (proc #f (proc #f) (proc #f) top fixnum fixnum)])
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean) fixnum fixnum)])))

(define-constant char=                                                 ;86/11/13
  (primop char= ()
    ((primop.generate self node)
     (character-comparator node 'jneq))
    ((primop.presimplify self node)
     (presimplify-to-conditional node))
    ((primop.conditional? self) t)
    ((primop.make-closed self)
     (make-closed-conditional self))
    ((primop.conditional-type self node)
     '#[type (proc #f (proc #f) (proc #f) top char char)])
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean) char char)])))

(define-constant char<                                                 ;86/11/13
  (primop char< ()
    ((primop.generate self node)
     (character-comparator node 'jgeq))
    ((primop.presimplify self node)
     (presimplify-to-conditional node))
    ((primop.make-closed self)
     (make-closed-conditional self))
    ((primop.conditional? self) t)
    ((primop.conditional-type self node)
     '#[type (proc #f (proc #f) (proc #f) top char char)])
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean) char char)])))

(define-constant char->ascii
  (primop char->ascii ()
    ((primop.generate self node)
     (generate-char->ascii node))
    ((primop.rep-wants self)
     '(rep/char))
    ((primop.arg-specs self)
     '(scratch))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) char)])))

(define-constant ascii->char
  (primop ascii->char ()
    ((primop.generate self node)
     (generate-ascii->char node))
    ((primop.rep-wants self)
     '(rep/integer))
    ((primop.arg-specs self)
     '(scratch))
    ((primop.type self node)
     '#[type (proc #f (proc #f char) fixnum)])))


;;; ARITHMETIC
;;;===========================================================================

(define-constant fixnum-add                                            ;86/11/04
  (primop fixnum-add ()
    ((primop.generate self node)
     (generate-fixnum-binop node 'add t))
    ((primop.simplify self node)
     (simplify-fixnum-add node))
    ((primop.rep-wants self)
     '(* *))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) fixnum fixnum)])))

(define-constant fixnum-logior                                         ;86/11/04
  (primop fixnum-logior ()
    ((primop.generate self node)
     (generate-fixnum-binop node 'or t))
    ((primop.simplify self node)
     (simplify-fixnum-logior node))
    ((primop.rep-wants self)
     '(* *))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) fixnum fixnum)])))

(define-constant fixnum-logxor                                         ;86/11/04
  (primop fixnum-logxor ()
    ((primop.generate self node)
     (generate-fixnum-binop node 'xor t))
    ((primop.simplify self node)
     (simplify-fixnum-logxor node))
    ((primop.rep-wants self)
     '(* *))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) fixnum fixnum)])))

(define-constant fixnum-logand                                         ;86/11/04
  (primop fixnum-logand ()
    ((primop.generate self node)
     (generate-fixnum-binop node 'and t))
    ((primop.simplify self node)
     (simplify-fixnum-logand node))
    ((primop.rep-wants self)
     '(* *))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) fixnum fixnum)])))

(define-constant (fixnum-lognot x)                                     ;86/11/04
   (fixnum-logxor x -1))                                      

(define-constant (fixnum-negate x)                                     ;86/11/04
  (fixnum-subtract 0 x))

(define-constant fixnum-subtract                                       ;86/11/04
  (primop fixnum-subtract ()
    ((primop.generate self node)
     (generate-fixnum-binop node 'sub nil))
    ((primop.simplify self node)
     (simplify-fixnum-subtract node))
    ((primop.rep-wants self)
     '(* *))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) fixnum fixnum)])))

(define-constant fixnum-multiply                                       ;86/11/04
  (primop fixnum-multiply ()
    ((primop.generate self node)
     (generate-fixnum-binop node 'mul t))
    ((primop.simplify self node)
     (simplify-fixnum-multiply node))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) fixnum fixnum)])))

(define-constant fixnum-divide                                         ;86/11/04;86/11/04;86/11/04
  (primop fixnum-divide ()
    ((primop.generate self node)
     (generate-fixnum-binop node 'div nil))
    ((primop.simplify self node)
     (simplify-fixnum-divide node))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) fixnum fixnum)])))

(define-constant (fixnum-ashr x y)                                     ;86/11/04
  (fixnum-ash x (fixnum-subtract 0 y)))

(define-constant (fixnum-ashl x y) (fixnum-ash x y))                   ;86/11/04

(define-constant fixnum-ash                                            ;86/11/04
  (primop fixnum-ash ()
    ((primop.generate self node)
     (generate-fixnum-binop node 'ash nil))
    ((primop.rep-wants self) '(rep/integer rep/integer))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) fixnum fixnum)])))

(define-constant fixnum-remainder                                      ;87/02/24
  (primop fixnum-remainder ()
    ((primop.generate self node)
     (generate-fixnum-binop node 'rem nil))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) fixnum fixnum)])))

(define-constant fixnum-add-with-overflow
  (primop fixnum-add-with-overflow ()
    ((primop.values-returned self) 1)                               
    ((primop.generate self node)
     (generate-op-with-overflow node 'add))
    ((primop.presimplify self node)
     (presimplify-to-funny-conditional node 1))
    ((primop.conditional? self) t)
    ((primop.make-closed self) primop/undefined-effect)
    ((primop.conditional-type self node)
     '#[type (proc #f (proc #f fixnum) (proc #f fixnum) top fixnum fixnum)])
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean fixnum) fixnum fixnum)])))

(define-constant fixnum-subtract-with-overflow
  (primop fixnum-subtract-with-overflow ()
    ((primop.values-returned self) 1)                               
    ((primop.generate self node)
     (generate-op-with-overflow node 'subtract))
    ((primop.presimplify self node)
     (presimplify-to-funny-conditional node 1))
    ((primop.conditional? self) t)
    ((primop.make-closed self) primop/undefined-effect)
    ((primop.conditional-type self node)
     '#[type (proc #f (proc #f fixnum) (proc #f fixnum) top fixnum fixnum)])
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean fixnum) fixnum fixnum)])))
      
(define-constant two-fixnums?
  (primop two-fixnums? ()
    ((primop.generate self node)
     (generate-two-fixnums node))
    ((primop.presimplify self node)
     (presimplify-to-conditional node))
    ((primop.make-closed self) primop/undefined-effect)
    ((primop.conditional? self) t)
    ((primop.conditional-type self node)
     '#[type (proc #f (proc #f) (proc #f) top top top)])
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean) top top)])))



