(herald new_syntax (env tsys))


(define-syntax (fix-up-default pat body)
  (cond ((atom? body) 'nil)
        (else
          (destructure (((name . args) pat))
            (let ((ignore-list (iterate loop ((args args) (l '()))
                                 (cond ((null? args) l)
                                       ((atom? args) (cons args l))
                                       (else
                                        (loop (cdr args) (cons (car args) l)))))))
              `(named-lambda ,name ,args
                  (ignorable ,@ignore-list)
                  ,@body))))))

(define (%massage-default default)
  (cond ((extend? default) default)
        (else nil)))

(define valid-method-form?
  (let ((self-var? (pattern-predicate
                    (| identifier?
                       (identifier? identifier?)))))
    (pattern-predicate ((#f self-var? . formals-list?) . (+ #f)))))

(define-safe-syntax (xselect key . clauses)
                    (#f . (+ ((+ #f) . (* #f))))
  (cond ((assq 'else clauses)
         (syntax-error "~s expression has ~s clause~%  ~s"
                       'xselect 'else `(xselect ,key ,@clauses))))
  `(,(t-syntax 'select) ,key ,@clauses (else (no-op (losing-xselect)))))

(set (syntax-table-entry standard-syntax-table 'fix-up-default)
     (syntax-table-entry (env-syntax-table t-implementation-env) 'fix-up-default))