(herald unm682gen)

;;; we can do unsafe things here once we set the foreign call cont

(define (generate-foreign-call node)
  (destructure (((cont foreign rep-list value-rep . args) (call-args node)))
    (emit m68/move .l SP (reg-offset TASK task/foreign-call-cont))
    (generate-push nil-reg)   ; save slink
    (generate-move nil-reg AN)
    (emit m68/move .l TASK (reg-offset AN slink/current-task))
    (iterate loop ((args (reverse args)) 
                   (reps (map cadr (leaf-value rep-list))))
      (cond ((null? args)
             (walk (lambda (node) (kill (leaf-value node))) args))
            ((eq? (car reps) 'rep/double)
             (let ((reg (->register 'pointer node (leaf-value (car args)) '*)))
               (emit m68/move .l (reg-offset reg 6) (@-r 15))
               (emit m68/move .l (reg-offset reg 2) (@-r 15))
               (loop (cdr args) (cdr reps))))
            (else
             (rep-push node (leaf-value (car args)) (car reps))
             (loop (cdr args) (cdr reps)))))
    (let ((reg (->register 'pointer node (leaf-value foreign) '*))) ; get xenoid
      (emit m68/move .l (reg-offset reg 6) P))  ; P must be A0, get 2nd slot
    (emit m68/jsr (@r 8))   ; a0 = P
    (clear-slots)
    (emit m68/move .l (reg-offset TASK task/foreign-call-cont) SP)
    (emit m68/move .l (reg-offset sp -4) nil-reg)  ; restore slink
    (emit m68/clr .l (reg-offset TASK task/foreign-call-cont))
    (case (leaf-value value-rep)
      ((rep/undefined ignore))                                        
      ((rep/double)                                     ; cons a flonum
       (emit m68/move .l (machine-num 8) S1)            ; 2 words for double
       (emit m68/move .l (machine-num header/double-float) AN)
       (generate-slink-jump slink/make-extend)
       (emit m68/fmove .d 0 (reg-offset AN 2))
       (emit m68/move .l AN A1))                         ; return consed flonum
      (else
       (really-rep-convert node S0 (leaf-value value-rep) A1 'rep/pointer)))
    (generate-return 1)))

(define .s 's)
(define .d 'd)

(define (floating-size size)
  (xcase size
    ((s) 1)
    ((d) 5)))
                                         
(define (m68/fmove size src dst)
  (move-fpr-ea (fg-argref src 0) dst (floating-size size)))

(define-fg (move-fpr-ea (identity fpr) (ea-all? dst) size)
  (printer "fmove.d fp~s,~g"  (? fpr) (if (pair? (? dst)) (car (? dst)) (? dst)))
  (1 1 1 1) (0 0 1) (0 0 0) (fg (if (pair? (? dst)) (car (? dst)) (? dst)))
  (0 1 1) (f u 3 size) (f u 3 fpr) (f u 7 0)
  (fg (if (pair? (? dst)) (eal-fg (cdr (? dst)) '(general 32)) null-fg)))
