(herald (assemble m68orbas t 16)
        (env tsys (assembler as_open))
;        (syntax-table
;         (block (*require 'as_syntax '(assembler as_syntax) (repl-env))
;                (env-syntax-table (repl-env))))
        )


;;; Orbit & 68000 specific extensions to the assembler

(define  (assemble-init c)
  (assemble-init-1 c m68 emit-m68-template))

(define m68emit %%emit)

;;; ---------------- Lap additions

(walk (lambda (name1 name2 index)
        (*define-lap-register m68 name1 index)
        (*define-lap-register m68 name2 index))
      '(S0 S1 S2 S3 S4  S5 SCRATCH  nil-reg  P  A1  A2  A3  AN  TP  TASK  SP)
      '(r0 r1 r2 r3 r4  r5      r6       r7 r8  r9 r10 r11 r12 r13    14 r15)
      '(0   1  2  3  4   5       6        7  8   9  10  11  12  13    14  15)
      )

(walk (lambda (i)
        (set (table-entry (machine-pseudo-operands m68) (car i)) (cdr i)))
      `(
        (static  . ,(lambda (form section)
                      (destructure (((static id) form))
                        (static id))))
        
        (template . ,(lambda (form section)
                       (destructure (((template tag) form))
                         (m68/label section tag))))
        ))

;;; ---------------- VAX-like register names

;;; The "R" versions take the register index rather than the register number
;;; so the A and D registers are addressed uniformly; e.g. (A 0) is (R 8)

(define (error-if-not-an an id)
  (cond ((or (fx< an 8) (fx> an 15))
         (error "(~s ~s) -- ~s is not an address register" id an an))
        (else
         (fx- an 8))))

(define-local-syntax (m68op opname)
  `(vref (machine-ops-vector m68) ,(concatenate-symbol '%m68% opname)))

(define (r n) (vref m68-register-fgs n))
(define (@r n) ((m68op @a) (error-if-not-an n '@r)))
(define (@r+ n) ((m68op @a+) (error-if-not-an n '@r+)))
(define (@-r n)  ((m68op @-a) (error-if-not-an n '@-r)))
(define (d@r n displ) ((m68op d@a) (error-if-not-an n 'd@r)  displ))
(define (d@rx.w n x displ) ((m68op d@ax.w) (error-if-not-an n 'd@rx.w) x displ))
(define (d@rx.l n x displ) ((m68op d@ax.l) (error-if-not-an n 'd@rx.l) x displ))
(define $ (m68op $))

(define-op m68 @r      10 @a)
(define-op m68 @r+     11 @a+)
(define-op m68 @-r     12 @-a)
(define-op m68 d@r     13 d@a)
(define-op m68 d@rx.w  14 d@ax.w)
(define-op m68 d@rx.l  15 d@ax.l)

(define (template tag) (m68/label *current-assembly-section* tag))
(define (label tag) (m68/label *current-assembly-section* tag))

;;; ---------------- VAX-style index

(define (m68/index fg xr is-long?)
    (cond ((fg? fg)
           (if (not (m68/@a-fg? fg))
               (error "can't index ~s" fg))
           (receive (v w ns) (destructure-fg fg 0)
              (receive (ar w ns) (destructure-fg fg ns)
                 (m68/d@ax ar xr is-long? 0))))
          ((and (pair? fg) (fg? (car fg)) (fg? (cdr fg)))
           (receive (v w ns) (destructure-fg (car fg) 0)
              (receive (ar w ns) (destructure-fg (car fg) ns)
                 (receive (displ w ns) (destructure-fg (cdr fg) 0)
                    (m68/d@ax ar xr is-long? displ)))))
          (else
           (error "can't index ~s" fg))))

(define-op m68 (index.w fg xr) 16
  (m68/index fg xr 0))

(define-op m68 (index.l fg xr) 17
  (m68/index fg xr 1))

(define-op m68 index           18  index)

(define index (machine-operation m68 index.l))

;;; -------------------------- Template stuff.

;       3                   2                   1
;     1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;    |                              ...                              |
;    +-------------------------------+-------------------------------+
;    |       annotation offset       |  handler's jump displacement  |
;    +---------------+---------------+-------------------------------+
;    |  # ptr cells  |  # scr cells  |    offset within bit vector   |
;    +-+-+-----------+---------------+-------------------------------+
;    |1|N|unused     |   # of args   |  instructions ---->>          | <--- ptr
;    +-+-+-----------+---------------+                               |
;    |                      instruction stream                       |
;    |                              ...                              |

(define-data-fg (m68/template lambda-node handler-ib)
  (printer ".template")
  (local template-end)
  (fields
    (fixed 16 (get-template-annotation lambda-node))        
    ;;handler offset
    (fixed 16 (fixnum-ashr (from template-end handler-ib) 3))   
    (fixed 16 (get-template-cells lambda-node))
    ;;bitv offset
    (fixed 16 (fx+ (fixnum-ashr (mark-address template-end) 3) 2)) 
    (1)
    (fixed 1 (if (template-nary lambda-node)  1 0))
    (fixed 6 0)
    (fixed 8 (get-template-nargs lambda-node))
    (mark template-end)
    ))

(define (emit-m68-template code-node code-ib handler-ib template-ib)
   (set (ib-align template-ib) '(24 31 0))
   (as-emit template-ib (m68/template code-node handler-ib))
   (set-ib-follower template-ib code-ib)
   )

;;; ---------------- instruction names in orbit environment

(define-local-syntax (setup-m68-names)
  `(block
    ,@(map (lambda (item)
             `(*define orbit-env ',(cdr item)
                       (vref (machine-ops-vector m68)
                             ,(concatenate-symbol '%m68% (car item)))))
           '(
             (add        . m68/add)
;            (addx       . m68/addx)
             (sub        . m68/sub)
;            (subx       . m68/subx)
             (cmp        . m68/cmp)
             (cmpm       . m68/cmpm)
             (and        . m68/and)
             (or         . m68/or)
             (eor        . m68/eor)
;            (asl/e      . m68/asl/e)
;            (asr/e      . m68/asr/e)
             (asl        . m68/asl)
             (asr        . m68/asr)
;            (lsl/e      . m68/lsl/e)
;            (lsr/e      . m68/lsr/e)
             (lsl        . m68/lsl)
             (lsr        . m68/lsr)
;            (rol/e      . m68/rol/e)
;            (ror/e      . m68/ror/e)
             (rol        . m68/rol)
             (ror        . m68/ror)
;            (roxl/e     . m68/roxl/e)
;            (roxr/e     . m68/roxr/e)
             (roxl       . m68/roxl)
             (roxr       . m68/roxr)
             (bchg       . m68/bchg)
             (bclr       . m68/bclr)
             (bset       . m68/bset)
             (btst       . m68/btst)
             (divs       . m68/divs)
             (divu       . m68/divu)
             (muls       . m68/muls)
             (mulu       . m68/mulu)
             (chk        . m68/chk)
             (clr        . m68/clr)
             (neg        . m68/neg)
             (negx       . m68/negx)
             (not        . m68/not)
             (tst        . m68/tst)
             (nop        . m68/nop)
             (rtr        . m68/rtr)
             (rts        . m68/rts)
             (trapv      . m68/trapv)
             ;       (rte        . m68/rte)
             ;       (reset      . m68/reset)
             ;       (stop       . m68/stop)
             (moveq      . m68/moveq)
             (move       . m68/move)
             (movem      . m68/movem)
             (dbcc       . m68/dbcc)
             (exg        . m68/exg)
             (ext        . m68/ext)
             (jmp        . m68/jmp)
             (jsr        . m68/jsr)
             (lea        . m68/lea)
             (link       . m68/link)
             (pea        . m68/pea)
             (scc        . m68/scc)
             (swap       . m68/swap)
             (tas        . m68/tas)
             (trap       . m68/trap)
             (unlk       . m68/unlk)
             (bcc       . m68/jbcc)
             (bra       . m68/jbra)
             (bsr       . m68/jbsr)
             ))))

(setup-m68-names)

