_Chapter(Trees)
_label(chapter:trees)

_DComment( Bletch.  Rewrite this intro.  It's all out of order. )

This chapter describes procedures available for manipulating trees.  The
term _iix(tree) is used in a technical sense to refer to non-circular
list structure considered as tree data-structures, as contrasted with
_Fit(lists), which use chained pairs to represent a one-dimensional
sequence of objects.  Thus one might say either that _wt((A (B C) D)) is
a list of three elements, or that it is a tree with four (non-null)
leaves.

Trees are used to represent programs.  The tree-manipulation
procedures and special forms are designed with this in mind.
_DComment( The tree paradigm may be useful for other things also. )

_Section(Comparison)
_index(equality predicates)

_Comdef(`EQUIV?',` ',
`(EQUIV? _Fit(object1 object2)) _yl() _Fit(boolean)')
_begin_Desc
_tc(EQUIV?) is an equality predicate, not for comparing trees but for
comparing leaves.

_begin_Itemize
_Item()If _tc((EQ? _Fit(object1) _Fit(object2))), then
_tc((EQUIV? _Fit(object1) _Fit(object2))).

_Item()If _Fit(object1) and _Fit(object2) are both numbers of the same type,
then they are _tc(EQUIV?) iff they have the same numeric value
(see _tc(=), page _Pageref(EQUAL?)).

_Item()If _Fit(object1) and _Fit(object2) are both strings,
then they are _tc(EQUIV?) if they are _tc(STRING-EQUAL?)
(page _Pageref(STRING-EQUAL?)).
_end_Itemize
See also the descriptions of _tc(EQ?) (page _Pageref(EQ?)) and _tc(=)
(page _Pageref(EQUAL?)).

    _begin_Inset(Bug:)
    In _T 3.1, _tc(EQUIV?) (and _tc(ALIKEV?)) may return false
    for two numbers which are _tc(=).  It will do the right thing,
    however, for FIXNUMs.
    _end_Inset
_end_Desc 

_DComment( There ought to be an entire section on equality, describing the
relative merits and disadvantages of _tc(EQ?), _tc(EQUAL?), _tc(EQUIV?),
_tc(ALIKEQ?), and _tc(ALIKEV?). )

_Comdef(`ALIKE?',` ',
`(ALIKE? _Fit(predicate tree1 tree2)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(tree1) and _Fit(tree2) have the same shape
and their corresponding leaves are equal according to
_Fit(predicate), which must be an equality predicate.
_begin_Example
(ALIKE? = '(1 (2 . 8) 3) '(1 (2 . 8) 3))  _evalto()  _Fsem(true)
_end_Example
_end_Desc 

_Comdef(`ALIKEQ?',` ',
`(ALIKEQ? _Fit(tree1 tree2)) _yl() _Fit(boolean)')
_begin_Desc
_begin_Example
(ALIKEQ? _Fit(tree1 tree2))  _equiv()  (ALIKE? EQ? _Fit(tree1 tree2))
_end_Example
_end_Desc 

  
_Comdef(`ALIKEV?',` ',
`(ALIKEV? _Fit(tree1 tree2)) _yl() _Fit(boolean)')
_begin_Desc
_begin_Example
(ALIKEV? _Fit(tree1) _Fit(tree2))  _equiv()  (ALIKE? EQUIV? _Fit(tree1) _Fit(tree2))
_end_Example
Roughly speaking, two trees are _tc(ALIKEV?) if they print the
same way.
_end_Desc 

_Section(Tree utilities)

_Comdef(`SUBST',` ',
`(SUBST _Fit(predicate new old tree)) _yl() _Fit(tree)')
_begin_Desc
Returns a result tree which is the same as the argument _Fit(tree),
except that leaves in the argument tree which, according to
_Fit(predicate), are equal to _Fit(old), have been changed to be
_Fit(new).  _Fit(Predicate) must be an equality predicate.
_begin_Example
(SUBST EQUIV? 17 13 '(10 (20 13) 30))  _evalto()  (10 (20 17) 30)
_end_Example
The result returned by _tc(SUBST) may or may not share structure with its
tree argument.
_end_Desc 

_Comdef(`SUBSTQ',` ',
`(SUBSTQ _Fit(new old tree)) _yl() _Fit(tree)')
_begin_Desc
_begin_Example
(SUBSTQ _Fit(new old tree))  _equiv()  (SUBST EQ? _Fit(new old tree))
_end_Example
_end_Desc 

_Comdef(`SUBSTV',` ',
`(SUBSTV _Fit(new old tree)) _yl() _Fit(tree)')
_begin_Desc
_begin_Example
(SUBSTV _Fit(new old tree))  _equiv()  (SUBST EQUIV? _Fit(new old tree))
_end_Example
_end_Desc 

_Comdef(`COPY-TREE',` ',
`(COPY-TREE _Fit(tree)) _yl() _Fit(tree)')
_begin_Desc
Recursively make a copy of the _Fit(tree).
_begin_Example
(COPY-TREE _Fit(tree))  _equiv()  (SUBSTQ NIL NIL _Fit(tree))
_end_Example
_end_Desc 

_Comdef(`TREE-HASH',` ',
`(TREE-HASH _Fit(tree)) _yl() _Fit(integer)')
_begin_Desc
Compute a _ix(hash code) for _Fit(tree).
The hash computed is a non-negative fixnum with the property
that if _Fit(tree1) and _Fit(tree2) are _tc(ALIKEV?),
then their hashes are the same.
_DComment( Same across all _T implementations, or not? )
_end_Desc 

_Section(Destructuring)

_Comdef(`DESTRUCTURE',`Special form',
`(DESTRUCTURE _Fit(specs . body)) _yl() _Fit(value-of-body)')
_label(DESTRUCTURE)
_begin_Desc
_Fit(Specs) has the form _wt(((_Fit(pattern value)) (_Fit(pattern value)) _dots()))
where each _Fit(pattern) is either an identifier (e.g., _tc(X))
or a _Fit(tree) (see page _Pageref(chapter:trees)),
all of whose non-null leaves are identifiers
(e.g., _wt(((X Y . Z) P Q))).

_tc(DESTRUCTURE) is similar to _tc(LET), and in the case that all the
_Fit(patterns) are symbols, _tc(DESTRUCTURE) and _tc(LET) are
equivalent. But _tc(DESTRUCTURE) is especially useful when one wants
to bind variables to the various nodes in a single tree structure.  For
example, suppose _tc(Z) has the value _wt((1 (2 3) ((4 5 . 6) 7))),
and we want to bind _tc(A) to 1, _tc(B) to 2, _tc(C) to 3,
_tc(D) to 6, and _tc(E) to 7. We could write
_begin_ExampleTabbing
(LET _settab()(_settab()(A (CAR Z)) _incrtab()_incrtab()_LNL
      (B (CAADR Z)) _LNL
      (C (CDADR Z)) _LNL
      (D (CDDAR (CADDR Z))) _LNL
      (E (CADADR (CDR Z)))) _decrtab()_LNL
  _dots())
_end_ExampleTabbing
However, we could also write
_begin_Example
(DESTRUCTURE (((A (B . C) ((() () . D) E)) Z)) _LNL
  _dots())
_end_Example
The _tc(())'s notate ignored positions.
_end_Desc 

_Comdef(`DESTRUCTURE*',`Special form',
`(DESTRUCTURE* _Fit(specs . body)) _yl() _Fit(value-of-body)')
_begin_Desc
_tc(DESTRUCTURE*) is the _qu(serial) form of _tc(DESTRUCTURE), just
as _tc(LET*) is the _qu(serial) form of _tc(LET).
_begin_ExampleTabbing
(DESTRUCTURE* _settab()(_settab()(_Fit(_sub(pattern,1) _sub(value,1))) _incrtab()_incrtab()_LNL
               (_Fit(_sub(pattern,2) _sub(value,2))) _LNL
               _dots() _LNL
               (_Fit(_sub(pattern,n) _sub(value,n)))) _decrtab()_LNL
  _Fit(code)) _LNL
  _equiv() _decrtab()_LNL
(_settab()DESTRUCTURE ((_Fit(_sub(pattern,1) _sub(value,1)))) _incrtab()_LNL
  (_settab()DESTRUCTURE ((_Fit(_sub(pattern,1) _sub(value,1)))) _incrtab()_LNL
   _dots() _settab()_incrtab()_LNL
     (DESTRUCTURE _settab()((_Fit(_sub(pattern,n) _sub(value,n)))) _incrtab()_LNL
       _Fit(code) )_dots()))
_end_ExampleTabbing
_end_Desc 

_Section(Quasiquote)
_label(section:quasiquote)
_index(quasiquote)_index(backquote)

_T's _Fit(quasiquote) facility, inherited from the Maclisp family
of Lisps, is useful for building programs whose form
is determined, but where some of the structure is constant
and some is to be filled in.
This is especially convenient in the definitions of macro
expanders.
It is so useful that a special external syntax is provided
for notating such templates.
It takes its name from the name
of the character (quasiquote, _cQo) which introduces this special syntax.

The character (_cQ()_cQo()_cQ()) is called _Fit(quasiquote)
because it behaves like _tc(QUOTE) except that one can specify that
subforms of the quasiquote'd form should be evaluated.  Inside a form
that is preceded by a quasiquote, two additional pieces of
external syntax are active: comma (_tc(`,')), and comma at-sign (_tc(`,'@));
these are the ways to indicate that some subform should
be evaluated (i.e., unquoted).  A subform preceded by a comma
is evaluated and replaced by the result of the evaluation.
A subform preceded by a comma at-sign is evaluated and replaced
by _Fit(splicing in) the result of the evaluation.

Here are some simple examples.  Note that the first example shows code
equivalence, not evaluation.
_begin_ExampleTabular
_cQo()(A B ,X Y)  _colsep()_equiv()_colsep  (LIST 'A 'B X 'Y) _LNL

(DEFINE X '(3)) _LNL
(CDR _cQo()(A B ,X C))    _colsep()_evalto()_colsep  (B (3) C) _LNL
(CDR _cQo()(A B ,@X C))  _colsep()_evalto()_colsep  (B 3 C)
_end_ExampleTabular

_begin_ExampleTabbing
(DEFINE-SYNTAX _settab()(REPEAT N . CODE)     ;Execute CODE N times _incrtab()_LNL
  _cQo()(LET _settab()((COUNT ,N) (THUNK (LAMBDA () ,@CODE))) _incrtab()_LNL
     (DO _settab()((COUNT COUNT (-1+ COUNT))) _incrtab()_LNL
         ((_a(_cLT,=0?) COUNT) '()) _LNL
       (THUNK))))
_end_ExampleTabbing

It is possible to nest quasiquoted forms.  This is useful when writing complex
source-to-source transformations.
_begin_ExampleTabbing
(DEFINE-SYNTAX _settab()(FOO X Y) _incrtab()_LNL
  _cQo()(LET _settab()((STUFF ,X)) _incrtab()_LNL
     _cQo()((STUFF-IS ,STUFF) _LNL
       (Y-IS ,',Y)))) _decrtab()_decrtab()_LNL

(FOO (+ 3 5) BAZ)  _evalto()  ((STUFF-IS 8) (Y-IS BAZ))
_end_ExampleTabbing

_wt(quasiquote) now works on vectors.  Thus,
_begin_Example
_cQo()_cH()(1 2 ,(+ 1 2)) _evalto _cH()(1 2 3)
_end_Example
