_Appendix(Future work)
_label(chapter:future)

This appendix catalogs some ideas about _T's future development.
It is provided as a stimulus for user input, and as an assurance
that these problems are known and are being addressed.

_Section(Language design problems)

A system for managing multiple namespaces - loading files into
appropriate environments, and communicating names from one
module to another in a controlled way - is sorely needed.

Better aggregate structures are needed (arrays, hash tables).

A condition/error signalling system is needed.

Each special form should be marked as being either primitive or a
macro.  This would allow users to write robust program-manipulating
programs using only the released language.

There should be a way to remove bindings from locales.

There ought to be able to have variables named by objects other than
symbols.  Maybe there ought to be a generalized _tc(INTERN) which
creates a unique instance of any object, or something like OWL's
_tc(UCONS) (unique cons) primitive.

Should reintroduce _tc(DEFINE-LOCALE)?

_tc(MEMQ), _tc(ASSQ), _tc(POSQ), etc. are inconsistent with the other
aggregate accessing routines in that the aggregate argument follows the
index argument and not vice versa.

Ideas for list routines: _tc(SUBSET), _tc(FILTER), _tc(FIND),
set operations.

Need a term more specific than _qu(tree) for whatever those things are.

The tree manipulation routines (e.g. _tc(ALIKEV?)) should be
user-extensible.  Big problem with what _tc(TREE-HASH) should do with
unusual leaf nodes.

There should be a general way to do generic dispatches based on more
than one argument.

There should be a non-side-effecting way to define methods for structures.

_tc(SYNONYM) is a misleading name.

_tc(SETTER) is inadequate.  Why not _tc(PUSHER), _tc(SWAPPER),
etc.?  Is there any way to do this that's at the same time convenient,
general, and efficient?

_tc(CASE) and _tc(SELECT) should use _tc(EQUIV?) instead of _tc(EQ?).

Method-clauses aren't incrementally redefinable.  What to do about this.
Objects handling many operations become quite unmanageable.
Maybe this is an implementation and editor problem, not a language problem.

The looping/iteration constructs are maybe a little too simple.  Figure
out some better ones without compromising principles, if possible.
Waters' _tc(LetS) looks sort of good.

_tc(CHECK-ARG) is ad hoc.  Need type inference and other compiler smarts.
Need better type declaration syntax.

There should be case-ignoring character and string comparison predicates.

_tc(STRING-POSQ) is not a good name.

_tc(STRING-REPLACE) should probably be called _tc(STRING-REPLACE!),
or flushed.  Similarly with _tc(VECTOR-FILL), _tc(VECTOR-REPLACE).

The name _tc(DIGIT?) is nconsistent with _tc(DIGIT->CHAR) -
does the term _Fit(digit) mean a character or an integer?

What about _tc(UPPERCASE?) _yl() _tc(UPPER-CASE?)?  Ugh.

Enumerated types.

Infinities?

Should _tc(NOT-ZERO?) and friends be renamed to be _tc(NONZERO?) etc.?

Divulge expression syntax for quasiquote?

Maybe release _tc(BOUND?).

Need a way to make read tables be read-only.

Need _tc(LET-SYNTAX-TABLE) and _tc(LET-READ-TABLE) features?

Maybe flush the random not-parsable-as-number-implies-symbol syntax feature.
It can be a real pain to catch typos in numbers.

I/O system improvements needed:
_begin_Itemize
_Item()Streams are pretty random.  How does a stream differ from a sequence?
There should be ways to coerce from streams to (infinite) sequences,
and vice versa.  Maybe the term _Fit(stream) should follow Sussman's usage
(infinte sequence), not Common Lisp's (pointer into same).

_Item()The _tc(FORMAT) sublanguage is random and unextensible.

_Item()Block-mode and/or _qu(binary) I/O, for database or whatever applications.

_Item()There ought to be a way to make the printer complain if it comes
across an object which isn't re-readable.

_Item()Ought to be a way to establish the line-length of a stream.

_Item()_tc(HPOS) and _tc(VPOS) aren't precisely defined.

_Item()_tc(SPACE) operation needs a better definition.
_end_Itemize

Structure package improvements needed:
_begin_Itemize
_Item()_tc(DEFINE-STRUCTURE-TYPE) features: initializers, variant record types,
arguments to constructor procedure, type-restricted fields, alternate
name construction.

_Item()Maybe structures should have an official external syntax.

_Item()Structures ought to be callable.

_Item()_tc(COPY-STRUCTURE) and _tc(COPY-STRUCTURE!) ought to take as an
additional argument the structure type to which the structure belongs.
Alternatively, a copying procedure could be associated with the
structure type object itself.

_Item()Maybe there ought to be a way to test initializedness of structure components.
_end_Itemize

_Section(Common Lisp influence)

The design and implementation of _T began around the same time that
the Common Lisp design effort started in earnest.  Some of the goals
of the projects have been similar; in many cases, the _T designers
left certain problems for the Common Lisp designers to work out,
intentionally ignoring many sticky issues, such as numeric routines,
sequences, and arrays, in order to work on other areas.

Now that the Common Lisp language has matured, and portable
implementations are approaching reality, two distinct integration
projects are in order: importing ideas and facilities from Common
Lisp into _T (with appropriate customization); and building a
Common Lisp emulation package in _T.

_T itself will never contain Common Lisp as a subset, but it should be
suitable as an implementation language for a Common Lisp.
This will probably take the form of alternate evaluator, reader, printer,
and namespace, together with a Common Lisp-to-_T translator.

The following Common Lisp features, at least, should be incorporated
into _T in some form:
_begin_Itemize
_Item()  Arrays.

_Item()  Sequences.  (These would clean up a lot of the current clutter with the
  string and vector routines, but introduce a new level of implementation
  hair.)

_Item()  Multiple values.  These can be simulated now with continuation-passing,
  but the syntax is clumsy.

_Item()  Numeric routines.  Ratios and complexes.
  Multiple floating point precisions.

_Item()  _tc(SHIFTF) and _tc(ROTATEF).  (These are generalized versions of _T
  _tc(SWAP) and _tc(EXCHANGE).)

_Item()  Hash tables.

_Item()  _tc(FORMAT) enhancements: floating-point formats, etc.

_Item()  File dates.  Time and date manipulation.  Time and date parsing.
_end_Itemize

_DComment(dorab: clean this up)
_Section(Bugs in the implementation)
_label(section:bugs)

This implementation (_Tv(3.1)) doesn't implement everything described
in this manual.

_begin_Itemize
_Item()    Not implemented:
    _tc(ATAN2),
    _tc(ROUND),
    _tc(PORT-POSITION),
    and _tc(TRUNCATE).
_end_Itemize

Many things are implemented incorrectly.

_begin_Itemize
_Item()    Deficiencies in syntax environments (they don't exist per se) and in
    locales (shadowing loses).

_Item()    _tc(GENERATE-SYMBOL):  The implementation generates obscure
    names, but doesn't
    guarantee uniqueness.  That is, the symbols are interned.

_Item()    _tc(ANY?) and _tc(EVERY?) of more than one list don't work.

_Item()    _tc(GET) and _tc(PUT) work only on symbols.

_Item()    _tc(READ-LINE) and _tc(UNREAD-CHAR) interact badly.

_Item()    There is no way to trace an operation.
_end_Itemize

Many things are implemented less efficiently than they ought to be.

_begin_Itemize
_Item()    The garbage collector is slow.  This should be fixed.

_Item()    There ought to be an option to invoke the standard compiler on
    demand, as code is run, instead of all at once, as code is loaded.

_Item()    _tc(BIND) is implemented in a pretty cons-intensive way;
    there's a bigger performance penalty for dynamic binding than one would
    find in other Lisp implementations.

_Item()    _qu(Lexprs) are inefficient because they always cons a list for the
    rest-variable.

_Item()    The i/o system doesn't do any buffering; this really slows down
    reading and printing a lot, most notably the loading of code files.

_Item()    Operation dispatch could be done using hash tables.  _tc(DEFINE-OPERATION)
    needs to do early binding.  This is feasible, but the implementation
    could become quite hairy.

_Item()    Locales are permanent (!), and forward references to shadowed variables
    will lose big, especially with the standard compiler.

_Item()    The interpreter conses a lot more than it ought to.  It ought to do some
    small amount of closure analysis, or else use McDermott's dynamic
    migration hack.

_Item()    The combinator routines are pretty useless since TC doesn't know
    anything about them.  This should be fixed.  For example,
    _tc(((COMPOSE CAR CDR) '(A B C))) is evaluated, even in compiled code,
    by actually consing a procedure, and then invoking it.
_end_Itemize

Many things in the system are implemented less smoothly than they ought to be.

_begin_Itemize
_Item()    Many system routines still don't check their argument types.

_Item()    Redefining _tc(DEFINE-CONSTANT)'ed and _tc(DEFINE-INTEGRABLE)'d
    should report an error condition.

_Item()    Newline characters following input lines come out at the wrong place
    in transcript files.

_Item()    _tc(LOAD) ought to be smarter about file dates, checking for
    recompilation, etc.

_Item()    Interpreted _tc(QUOTE) ought to enforce read-only-ness.

_Item()    There ought to be a way to enforce the downwards-only-ness of escape
    procedures.
_end_Itemize

Missing features.

_begin_Itemize

_Item()    Help system.

_Item()    More system self-knowledge: who calls x, who does x call, type analysis,
    etc.  Masterscope-like stuff.

_Item()    There should be a version of _tc(TRACE) which _Fit(destructively)
    modifies a procedure so that it acts traced.

_end_Itemize
