_Appendix(Foreign-function Interface)

The interface between T3 and the local operating system is the
_wt(define-foreign) special form:

_begin_ExampleTabbing
(DEFINE-FOREIGN _settab()_Fit(T-name) _incrtab()_LNL
                (_Fit(foreign-name parameters)) _LNL
                _Fit(return-type))
_end_ExampleTabbing

_wt(DEFINE-FOREIGN) defines a _Fit(foreign procedure),
i.e. a _Tv() procedure which will call a procedure defined
by the operating system or in another language.

_begin_Desc
_Item(_Fit(T-name)) is the name of the _T procedure being defined.

_Item(_Fit(foreign-name)) is the name of the foreign procedure
to which the _Fit(T-name) corresponds.

_Item(_Fit(parameters)) specifies the representation of the parameters
to the foreign procedure or function.

_Item(_Fit(return-type)) indicates the representation of the value 
returned by the foreign procedure.
_end_Desc

_begin_ExampleTabular
parameter      _colsep()_parsesto()_colsep() (parameter-type foreign-type [parameter-name]) _LNL

parameter-type _colsep()_parsesto()_colsep _cBo() in _cVL out _cVL in/out _cVL var _cVL ignore _cBc() _LNL

foreign-type   _colsep()_parsesto()_colsep _cBo() rep/integer        _cVL _LNL
                      _colsep()_colsep()rep/integer-8-s    _cVL _LNL
                      _colsep()_colsep()rep/integer-8-u    _cVL _LNL
                      _colsep()_colsep()rep/integer-16-s   _cVL _LNL
                      _colsep()_colsep()rep/integer-16-u   _cVL _LNL
                      _colsep()_colsep()rep/value          _cVL _LNL
                      _colsep()_colsep()rep/extend         _cVL _LNL
                      _colsep()_colsep()rep/extend-pointer _cVL _LNL
                      _colsep()_colsep()rep/string         _cVL _LNL
                      _colsep()_colsep()rep/string-pointer  _cBc() _LNL

parameter-name _colsep()_parsesto()_colsep symbol used for identification _LNL

return-type    _colsep()_parsesto()_colsep Aegis: _cBo() foreign-type _cVL ignore _cVL rep/address _cBc() _LNL
                    _colsep()_colsep Unix:  _cBo() foreign-type _cVL ignore _cBc() _LNL
_end_ExampleTabular

For example, on the Apollo a procedure to do block reads from a stream
would be defined as follows:

_begin_ExampleTabbing
(DEFINE-FOREIGN _settab()aegis-read _incrtab() _LNL
    (_a(stream,_cUL,_cDL,get,_cUL,buf) _settab()(in     rep/integer-16-u   stream-id) _incrtab()_LNL
                     (in     rep/string         bufptr) _LNL
                     (in     rep/integer        buflen) _LNL
                     (ignore rep/integer        retptr) _LNL
                     (out    rep/integer        retlen) _LNL
                     (ignore rep/extend         seek-key) _LNL
                     (out    rep/integer        status)) _decrtab()_LNL
          ignore)
_end_ExampleTabbing

The following code will use _wt(AEGIS-READ) to read in a string
from standard input:

_begin_ExampleTabbing
  (let _settab()(_settab()(stream 0) _incrtab() _LNL
        (buf    (make-string 128))) _decrtab() _LNL
    (receive _settab()(len status) (aegis-read stream buf 128 nil nil nil nil) _incrtab() _LNL
      (cond _settab()(_settab()(= 0 status) _incrtab()_incrtab _LNL
             (set (string-length buf) len) _LNL
             len) _decrtab() _LNL
            (error _dots))))
_end_ExampleTabbing

On a Unix machine a similar procedure would be defined as,

_begin_ExampleTabbing
  (define-foreign _settab()unix-read-extend (read _settab()(in rep/integer) _incrtab()_incrtab _LNL
                                         (in rep/string) _LNL
                                         (in rep/integer)) _decrtab() _LNL
                  rep/integer)
_end_ExampleTabbing

To read a string from standard input on Unix the _Tv() code would
look something like:

_begin_ExampleTabbing
  (let _settab()((buf (make-string 128))) _incrtab() _LNL
    (receive _settab()(len status) (unix-read 0 buf 128) _incrtab _LNL
      (cond _settab()(_settab()(_cGT 0 status ) _incrtab()_incrtab _LNL
             (set (string-length buf) len) _LNL
             len) _decrtab _LNL
            (error _dots))))
_end_ExampleTabbing

_Section(Foreign Type Specification)

The _Fit(foreign-type) tells the compiler how to interpret a _Tv()
data type in order to pass it to the foreign call.  The general
categories of Pascal data types are numeric, string, record,
enumerated, set of.

_DComment(dorab: fix for info)
_IfLatex(`\begin{tabular}{llll}')

              _colsep  Pascal Type   _colsep  T3 Type   _colsep  Foreign Type Spec   _LNL()
Numeric       _colsep                _colsep            _colsep                      _LNL()
              _colsep  integer8      _colsep  fixnum    _colsep  rep/integer-8-s     _LNL()
              _colsep  binteger      _colsep  fixnum    _colsep  rep/integer-8-u     _LNL()
              _colsep  integer16     _colsep  fixnum    _colsep  rep/integer-16-s    _LNL()
              _colsep  pinteger      _colsep  fixnum    _colsep  rep/integer-16-u    _LNL()
              _colsep  integer       _colsep  fixnum    _colsep  rep/integer         _LNL()
              _colsep  linteger      _colsep  fixnum    _colsep  rep/integer         _LNL()
              _colsep  real          _colsep            _colsep  unimplemented       _LNL()
              _colsep  double        _colsep  flonum    _colsep  rep/extend          _LNL()
String        _colsep                _colsep            _colsep                      _LNL()
              _colsep  string        _colsep  string    _colsep  rep/string          _LNL()
              _colsep  string        _colsep  text      _colsep  rep/extend          _LNL()
              _colsep  _a(univ,_cUL,pointer) _colsep  string    _colsep  rep/string-pointer  _LNL()
              _colsep  _a(univ,_cUL,pointer) _colsep  text      _colsep  rep/extend-pointer  _LNL()
Record        _colsep                _colsep            _colsep                      _LNL()
              _colsep  record        _colsep  extend    _colsep  rep/extend          _LNL()
Miscellaneous _colsep                _colsep            _colsep                      _LNL()
              _colsep  char          _colsep  char      _colsep  rep/char            _LNL()
              _colsep  boolean       _colsep  boolean   _colsep  rep/integer-8-s

_IfLatex(`\end{tabular}')

Beware that if a _T string is being used as an out parameter
the offset field of the string must be 0 (the string must never
have been _wt(chdr!)'ed).

Record structures are represented by byte-vectors of the
appropriate size.

_Section(Pascal (Apollo) Enumerated Types)

Pascal enumerated types are defined using the _wt(DEFINE-ENUMERATED)
special form:

_Comdef(`DEFINE-ENUMERATED',`Special form',
`(DEFINE-ENUMERATED _Fit(type-name) _cBo()_Fit(element)_cBc()_star) _yl _Undefined')

_begin_Desc
Here _Fit(type-name) is just for identification, and the _Fit(element)s
are the enumerated types.  For example,

_begin_ExampleTabbing
  (define-enumerated _settab()_a(ios,_cUL,_cDL,create,_cUL,mode,_cUL,t) _incrtab()_LNL
                     _a(ios,_cUL,_cDL,no,_cUL,pre,_cUL,exist,_cUL)mode _LNL
                     _a(ios,_cUL,_cDL,preserve,_cUL,mode) _LNL
                     _a(ios,_cUL,_cDL,recreate,_cUL,mode) _LNL
                     _a(ios,_cUL,_cDL,truncate,_cUL,mode) _LNL
                     _a(ios,_cUL,_cDL,make,_cUL,backup,_cUL,mode) _LNL
                     _a(ios,_cUL,_cDL,loc,_cUL,name,_cUL,only,_cUL)mode _LNL
                     )
_end_ExampleTabbing

The foreign procedure is called with the enumerated type name just as in Pascal.
_end_Desc

_Section(Pascal Sets (Apollo))

The Pascal type _em(set-of) is defined using the _wt(DEFINE-SET-OF)
special form:

_Comdef(`DEFINE-SET-OF',`Special form',
`(DEFINE-SET-OF _Fit(type-name) _cBo()_Fit(element)_cBc()_star) _yl _Undefined')

There, again, _Fsem(type-name) is just for identification, and
the _Fsem(element)s are the names of the set members.  For
example,

_begin_ExampleTabbing
  (define-set-of _settab()_a(ios,_cUL,_cDL,put,_cUL,get,_cUL,opts,_cUL)t _incrtab()_LNL
                 _a(ios,_cUL,_cDL,cond,_cUL,opt) _LNL
                 _a(ios,_cUL,_cDL,preview,_cUL,opt) _LNL
                 _a(ios,_cUL,_cDL,partial,_cUL,record,_cUL,opt) _LNL
                 _a(ios,_cUL,_cDL,no,_cUL,rec,_cUL,bndry,_cUL)opt _LNL
                 )
_end_ExampleTabbing

_Section(Returned Values and Out Parameters)

For languages which have output parameters, e.g. Pascal, multiple
values are returned.  The first value is the return-value of
the foreign procedure, unless it is of _Fsem(return-type)
_wt(ignore), followed by the out parameters.  Thus a call
to the _Tv() procedure _wt(AEGIS-READ), defined above, would
return two values: _Fsem(retlen) and _Fsem(status).  For a
Pascal procedure the return spec will always be _wt(ignore).
The argument to a foreign procedure should usually be of type
_wt(ignore) if it is an out parameter to the foreign
procedure that is bigger than a longword.  Also, the value of
any out parameters which are not needed can be specified as
_wt(ignore).

Pascal functions which return addresses _em(must) have
_Fsem(return-type) of type _Fsem(rep/address).  If this value is passed
to another foreign call it should be with _Fsem(rep/integer).

_wt(DEFINE-FOREIGN) does not allocate storage for out
parameters.  This means that you must allocate your own object
and pass it to the foreign procedure even if it is only an out
parameter.  If it is an out parameter which is other than an
integer then its _Fsem(foreign-type) should be _wt(ignore)
and the variable passed in should be used to reference the
parameter.
