_Chapter(Files)

An executing _T system interacts with the world outside by
communicating with various external entities, including:

_begin_Itemize
_Item()    _Fit(people), via keyboards and displays;

_Item()    _iix(file systems), via operating system calls, possibly over
    a communications network;

_Item()    and _Fit(processes), running on the same machine or on different machines.
_end_Itemize

The language provides simple standardized interfaces to the first
two of these.  Particular implementations may provide more complete
interfaces.

Standard access to a terminal is provided by the ports _tc(TERMINAL-INPUT)
and _tc(TERMINAL-OUTPUT) (page _Pageref(TERMINAL-INPUT)).
Access to file systems is provided by the facilities described in this
chapter.

_Section(File systems)

A _iix(file system) is a collection of named permanent objects called
_iix(files), and a mechanism for manipulating this collection.
A _iix(file system object) is a _T object which names
or represents an actual file system.  Where the distinction is
unimportant, a file system object is referred to simply as a file
system.

A given _T implementation may provide access to multiple file
systems; such a facility is not described in this manual.  However,
one may assume that at least one file system, known as the
_iix(local file system), is accessible.

_Comdef(`LOCAL-FS',` ',
`(LOCAL-FS) _yl() _Fit(file-system)')
_begin_Desc
Returns the local file system object.
_end_Desc 

The following type predicates are defined to query the type of a file
system.

_Comdef(`AEGIS-FS?',`Type predicate',
`(AEGIS-FS? _Fit(file-system)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(file-system) represents an Aegis file system.
_end_Desc 

_Comdef(`UNIX-FS?',`Type predicate',
`(UNIX-FS? _Fit(file-system)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(file-system) represents a Unix file system.
_end_Desc 

_Comdef(`VMS-FS?',`Type predicate',
`(VMS-FS? _Fit(file-system)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(file-system) represents a VMS file system.
_end_Desc 

_Section(Filenames)

A _iix(filename) is an object which names a file.
Filenames are immutable record structures with the following
components:

_begin_Itemize
_Item()_Fit(File system:) the file system object via which the named file is
accessible.

_Item()_Fit(Directory:) a collection of files within the file system
to which the named file belongs.

_Item()_Fit(Name:) the name of the file within the directory, or of a family
of files, as further specified by the file type and generation components
of the filename.

_Item()_Fit(Type:) the type of the file (also known as _qu(extension)).

_Item()_Fit(Generation:) a positive integer specifying a particular version
or incarnation of the file.  Larger generation numbers indicate newer
versions.
_end_Itemize

In general, the directory, name, and type components of a file
are usually symbols, the file system component is a file system
object, and the generation component is an integer.
The file system component may be a symbol which names a file system
in an implementation-dependent manner.

Filenames may be incompletely specified; missing components
are represented by having null (false) as their value.  An omitted
file system is usually interpreted to be the same as the local file system,
an omitted directory component means the current working directory.
The name component may not be omitted.

The external representation of a filename has the form
_begin_Example
_cH()[Filename _Fit(file-system dir name type gen)]
_end_Example
where _Fit(gen) and _Fit(type) may be omitted, if null.

_Comdefb(`MAKE-FILENAME',` ',
`(MAKE-FILENAME _Fit(file-system dir name type gen)) _yl() _Fit(filename)',
`(MAKE-FILENAME _Fit(file-system dir name _rm(.) type)) _yl() _Fit(filename)')
_begin_Desc 

Returns a filename.  The arguments become the components of the filename
object.  _Fit(Type) and _Fit(gen) may be omitted, in which case they default to
null (absent).
_end_Desc

_Comdef2(`to-filename',`-_Ftt(>)FILENAME',` ',
`(-_Ftt(>)FILENAME _Fit(filespec)) _yl() _Fit(filename)')
_label(to-filename)
_begin_Desc
Coerces _iix(filespec) to a filename.
_begin_Itemize
_Item()If _Fit(filespec) is a filename, then it is returned.

_Item()If _Fit(filespec) is a list _Fit(l), then _tc(MAKE-FILENAME) is called,
passing null as the file system argument, and the elements of
the list as the rest of the arguments.

_Item()If _Fit(filespec) is a symbol _Fit(x), then it is treated the same
as the list _tc((() _Fit(x))).

_Item()If _Fit(filespec) is a string, then it is converted to a filename
in an implementation-dependent way, such that _tc(FILENAME-_Ftt(>)STRING)
applied to the filename will return a string which is equal
to _Fit(filespec).
_end_Itemize

For example:
_begin_ExampleTabular
_a(-,_cGT,FILENAME) _cQc()(MATH FACT T))               _colsep()_evalto()_colsep  _cH()[Filename () MATH FACT T] _LNL
_a(-,_cGT,FILENAME) _cQc()(MATH FACT))                 _colsep()_evalto()_colsep  _cH()[Filename () MATH FACT] _LNL
_a(-,_cGT,FILENAME) _cQc()FACT)                        _colsep()_evalto()_colsep  _cH()[Filename () () FACT] _LNL
_a(-,_cGT,FILENAME) _exqu(fact.t))                     _colsep()_evalto()_colsep  _cH()[Filename () () FACT T]
_end_ExampleTabular
The last example is plausible, but it will not necessarily hold in
all _T implementations, since the coercion of strings to filenames
is not defined here.  (In _T 2.7, strings are _Fit(not) parsed into
separate filename components.)
_end_Desc 

_Comdef(`FILENAME?',`Type predicate',
`(FILENAME? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a filename.
_end_Desc 

_Comdef(`FILENAME-FS',` ',
`(FILENAME-FS _Fit(filename)) _yl() _Fit(file-system) _rm(or) _Fit(false)')
_begin_Desc
Returns the file system component of _Fit(filename), or false (null)
if it has none.
_end_Desc 

_Comdef(`FILENAME-DIR',` ',
`(FILENAME-DIR _Fit(filename)) _yl() _Fit(symbol) _rm(or) _Fit(false)')
_begin_Desc
Returns the directory component of _Fit(filename).
_end_Desc 

_Comdef(`FILENAME-NAME',` ',
`(FILENAME-NAME _Fit(filename)) _yl() _Fit(symbol)')
_begin_Desc
Returns the name component of _Fit(filename).
_begin_Example
(FILENAME-NAME '_cH()[Filename () MATH FACT T])  _evalto()  FACT
_end_Example
_end_Desc 

_Comdef(`FILENAME-TYPE',` ',
`(FILENAME-TYPE _Fit(filename)) _yl() _Fit(symbol) _rm(or) _Fit(false)')
_begin_Desc
Returns the type component of _Fit(filename).
_end_Desc 

_Comdef(`FILENAME-GENERATION',` ',
`(FILENAME-GENERATION _Fit(filename)) _yl() _Fit(integer) _rm(or) _Fit(false)')
_begin_Desc
Returns the generation component of _Fit(filename).
_end_Desc 

_Comdef2(`filename-to-string',`FILENAME-_Ftt(>)STRING',` ',
`(FILENAME-_Ftt(>)STRING _Fit(filename)) _yl() _Fit(string)')
_begin_Desc
Returns a string representing _Fit(filename) in the native syntax
of _Fit(filename)'s file system (or of the local file system if
_Fit(filename) is null).

In _Tv(2.7), if the directory component of _Fit(filename) is a symbol,
then it is interpreted as a _qu(logical name) in a manner idiosyncratic
to the type of the file system:
_begin_Itemize
_Item()    Aegis: a _T logical name is interpreted as being a link in the
    naming directory.

_Item()    Unix: a _T logical name is an environment variable.

_Item()    VMS: a _T logical name is a VMS logical name.
_end_Itemize
For example:
_begin_Example
(_a(FILENAME-,_cGT,STRING) _cQc()_cH()[Filename AN-AEGIS-FS MATH FACT T]) _LNL
  _evalto()  _exqu(_cTL()math/fact.t) _LNL
(_a(FILENAME-,_cGT,STRING) _cQc()_cH()[Filename A-UNIX-FS MATH FACT T]) _LNL
  _evalto()  _exqu(/usr/math/fact.t) _LNL
(_a(FILENAME-,_cGT,STRING) _cQc()_cH()[Filename A-VMS-FS MATH FACT T]) _LNL
  _evalto()  _exqu(MATH:FACT.T) _LNL
_end_Example
(In the Unix example, we assume that environment variable _tc(MATH) was
defined to be _tc(/usr/math), e.g. by a _qu(_tc(setenv MATH /usr/math))
shell command.)
_end_Desc 

_Section(Files)

A _iix(file) is an external permanent object stored in a file system.
Files are accessed in _T via ports.
Ordinarily, files are sequences of characters, similar to strings.
An input port open on an existing file delivers successive characters
(or lines, or parsed objects) out of the file.  An output port open
on a new file deposits successive characters (or lines, or printed
representations of objects) into the file.

_tc(OPEN) and _tc(MAYBE-OPEN) obtain ports which access files.
Any port created by _tc(OPEN) or _tc(MAYBE-OPEN) should be closed
(using the _tc(CLOSE) operation, page _Pageref(CLOSE))
when no further access to the file is required.  This is guaranteed
if _tc(OPEN) and _tc(MAYBE-OPEN) are always used in conjunction with
_tc(WITH-OPEN-PORTS) (page _Pageref(WITH-OPEN-PORTS)), which ensures
that any port opened actually gets closed, even if there is a throw
out of the body of the _tc(WITH-OPEN-PORTS) form.

_Comdef(`OPEN',` ',
`(OPEN _Fit(filespec mode-list)) _yl() _Fit(port)')
_label(OPEN)
_begin_Desc
Opens an external file for reading or for writing, and returns
a port which accesses it.
_Fit(Filespec) should be a filename or any other object which can
be coerced to one (see _tc(-_Ftt(>)FILENAME), page _Pageref(to-filename)).
_Fit(Mode-list) should be
a list of keywords (symbols) specifying what kind of
access to the file is desired.
The only keywords currently recognized are _tc(IN), _tc(OUT), and
_tc(APPEND), indicating reading, writing, and appending, respectively.
It is an error condition if the file cannot be opened for some reason.
_begin_ExampleTabbing
(WITH-OPEN-PORTS _settab()((PORT (OPEN `file.txt' '(IN)))) _LNL
  _gotab()(READ-LINE PORT))
_end_ExampleTabbing
_end_Desc 

_Comdef(`MAYBE-OPEN',` ',
`(MAYBE-OPEN _Fit(filespec modes)) _yl() _Fit(port) _rm(or) _Fit(false)')
_begin_Desc
Like _tc(OPEN), but returns false if for any reason it
cannot open the file.
_end_Desc 

_Comdef(`PORT-NAME',`Operation',
`(PORT-NAME _Fit(port)) _yl() _Fit(filename)')
_begin_Desc
_tindex(PORT-NAME)
In _Tv(2) named _wt(STREAM-FILENAME).
Returns the filename of the file on which _Fit(port) is open.
This operation is not handled by any system-created ports other than
those created by _tc(OPEN) and _tc(MAYBE-OPEN).
_end_Desc 

_Comdef(`FILE-EXISTS?',` ',
`(FILE-EXISTS? _Fit(filespec)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if the specified file exists.
_end_Desc 

_Comdef(`FILE-MOVE',` ',
`(FILE-MOVE _Fit(source-filespec) _Fit(dest-filespec)) _yl() _Fit(undefined)')
_begin_Desc
Moves the file named by _Fit(source-filespec) to a new location given by
_Fit(dest-filespec).
In some cases, this operation can be performed without actually
copying the file, for example, if the two locations are on the same
_qu(volume) of the same file system.  In this case, _tc(FILE-MOVE)
is simply a rename operation.  In other cases, it may be more expensive.
    _begin_Inset(Bug:)
    Not all versions of _T 3.1 implement _tc(FILE-MOVE).
    _end_Inset
_end_Desc 

_Comdef(`FILE-DELETE',` ',
`(FILE-DELETE _Fit(filespec)) _yl() _Fit(undefined)')
_begin_Desc
Deletes the specified file.
    _begin_Inset(Bug:)
    Not all versions of _T 3.1 implement _tc(FILE-DELETE).
    _end_Inset
_end_Desc 
