_Chapter(Environments)
_label(chapter:environments)

_Section(Environments and contours)
_label(environments)

_iix(Environments) are associations between _iix(identifiers) (variable
names) and _iix(values).  One such association between an identifier
and a value is called a _iix(binding).  In general, environments
are created implicitly, for example, on entering _tc(LAMBDA)-bodies.
_index(variables)

_DComment( -- Explain the term _Fit(variable). )

Environments are organized hierarchically into _iix(contours).  Each
contour augments an _qu(outer) environment, providing bindings for a few
additional identifiers.  These bindings are in effect in the body of the
expression which introduces the contour.  The portion of a program in which
a binding is in effect is known as the variable's _iix(scope).

For example:
_begin_ExampleTabbing
(BLOCK _settab()_incrtab()_LNL
 (LIST 'A 'B) _LNL
 _dots _LNL
 (LAMBDA _settab()(A B C) _incrtab()_LNL
   _dots                  ; [1] _LNL
   (LAMBDA _settab()(D E) _incrtab()_LNL
     _dots                ; [2] _LNL
     ()) _decrtab()_LNL
   _dots                  ; [3] _LNL
   (LAMBDA _settab()(A F G) _incrtab()_LNL
     _dots                ; [4] _LNL
     ) _decrtab()_LNL
   _dots) _decrtab()_LNL
 _dots)
_end_ExampleTabbing
Each _tc(LAMBDA) introduces a new contour.  This code presumably occurs in
an outermost environment in which the variable _tc(LIST) is bound.
(The values of _tc(BLOCK) and _tc(LAMBDA) are not in question here;
they are reserved words, and their bindings as variables are irrelevant.)
At point _tc([1]) in the program, a new environment is in effect
which now has bindings for _tc(A), _tc(B), and _tc(C), as well as for
any variables known in the outer environment.  At _tc([2]),
_tc(D) and _tc(E) also have values.  _tc([3]) is in the
scope of _tc(A), _tc(B), and _tc(C) but not in the scope of
_tc(D) and _tc(E).  Finally, the outer binding
of any given identifier is _Fit(shadowed)_index(shadowing)
by inner bindings of that identifier;
an occurrence of the identifier _tc(A)
appearing at _tc([4]) refers not to the outer _tc(A)
but to the inner one, because the inner one shadows the outer.

There are two kinds of contours, known as _Fit(lambda-contours) and
_Fit(locales).  Lambda-contours are introduced by many special forms,
such as _tc(LAMBDA), _tc(LET), and _tc(LABELS).  Locales are
introduced by _tc(LOCALE) special forms.

_Section(Local variables)

_Comdef(`LET',`Special form',
`(LET _Fit(specs) . _Fit(body)) _yl() _Fit(value-of-body)')
_label(LET)
_begin_Desc

_tc(LET) provides a convenient syntax for introducing local bindings.
Each _Fit(spec) should be a two-element list of the form _tc((_Fit(variable
value))).  The _Fit(value) expressions are all evaluated (in no particular
order), then the
_Fit(body) (an implicit block) is evaluated in an environment where the
_Fit(variables) are bound to those values.  The value of _Fit(body) is
yielded. The result of the expression is undefined if more than one
_Fit(spec) has its first element to be the same _Fit(variable).
_begin_Example
(LET ((X 2)) X)  _evalto()  2 _LNL

(LET ((_Fit(_sub(var,1) _sub(val,1))) (_Fit(_sub(var,2) _sub(val,2))) _dots (_Fit(_sub(var,n) _sub(val,n)))) . _Fit(body)) _LNL
_equiv() ((LAMBDA (_Fit(_sub(var,1) _sub(var,2)) _dots _sub(var,n)) . _Fit(body)) _Fit(_sub(val,1) _sub(val,2) _dots _sub(val,n)))
_end_Example

See also _tc(DESTRUCTURE) (page _Pageref(DESTRUCTURE)).
_end_Desc

_Comdef(`LET*',`Special form',
`(LET* _Fit(specs) . _Fit(body)) _yl() _Fit(value-of-body)')
_begin_Desc
_tc(LET*) is like _tc(LET), except that the binding of variables to
values is done sequentially, so that the second binding
is done in an environment in which the first binding has already occurred,
etc.  In a _tc(LET)-expression, all the bindings are done in one
environment.
For example,
suppose the variable _tc(A) is already bound to _tc(10) when
the expression _wt((LET ((A 20) (B A)) B)) is evaluated.  The
result is _tc(10), not _tc(20), because _tc(B) is bound to
_tc(A)'s value in the outer environment.  In contrast,
_wt((LET* ((A 20) (B A)) B)) evaluates to _tc(20).

_begin_ExampleTabbing
(LET* _settab()((_Fit(_sub(var,1) _sub(val,1))) (_Fit(_sub(var,2) _sub(val,2))) _dots (_Fit(_sub(var,n) _sub(val,n)))) . _Fit(body)) _LNL
  _gotab()_equiv() _LNL
(LET _settab()((_Fit(_sub(var,1) _sub(val,1)))) _incrtab()_LNL
  (LET _settab()((_Fit(_sub(var,2) _sub(val,2)))) _incrtab()_LNL
       _dots _LNL
       (LET ((_Fit(_sub(var,n) _sub(val,n)))) . _Fit(body))_dots)) _decrtab()_decrtab()_LNL
  _equiv() _LNL
((LAMBDA _settab()(_Fit(_sub(var,1))) _incrtab()_LNL
   ((LAMBDA _settab()(_Fit(_sub(var,2))) _incrtab()_LNL
       _dots _LNL
       ((LAMBDA (_Fit(_sub(var,n))) . _Fit(body)) _LNL
        _Fit(_sub(val,n))) _dots) _decrtab()_LNL
    _Fit(_sub(val,2)))) _decrtab()_LNL
 _Fit(_sub(val,1)))
_end_ExampleTabbing
_end_Desc

_Comdef(`LABLES',`Special form',
`(LABELS _Fit(specs) . _Fit(body)) _yl() _Fit(value-of-body)')
_begin_Desc

_tc(LABELS) is useful for defining local procedures that may be
mutually recursive.
Each _Fit(spec) should be of the form
_wt((_Fit(variable value))).
The _Fit(value)-expressions are evaluated (in no particular order), and
the _Fit(body) is evaluated in an environment
where all the _Fit(variables) are bound to those values.
However, _tc(LABELS) differs from _tc(LET) in that
the bindings of the _Fit(variables) are already in effect (scope) before the
_Fit(value)-expressions are evaluated, so that the
_Fit(value)-expressions can refer to any of the _Fit(variables),
including the ones to which they themselves will be bound (thus permitting
local recursive procedures).

Each _Fit(spec) may alternatively have the form
_begin_Example
_wt(((_Fit(variable) . _Fit(argument-vars)) . _Fit(body)))
_end_Example
This is equivalent to
_begin_Example
_wt((_Fit(variable) (LAMBDA _Fit(argument-vars) . _Fit(body))))
_end_Example
This is intended to parallel the syntax for _tc(DEFINE) (see page
_Pageref(DEFINE)).

In the following example, note that _tc(REV-1) is bound to a value that
refers to _tc(REV-1).
_begin_ExampleTabbing
(_settab()DEFINE (REVERSE L) _incrtab()_LNL
  (LABELS ((_settab()(REV-1 L RESULT-SO-FAR) _incrtab()_LNL
            (COND _settab()((NULL? L) RESULT-SO-FAR) _incrtab()_LNL
                  (_settab()ELSE _incrtab()_LNL
                    (REV-1 _settab()(CDR L) _incrtab()_LNL
                           (CONS (CAR L) RESULT-SO-FAR)))))) _decrtab()_decrtab()_decrtab()_LNL
    (REV-1 L '())))
_end_ExampleTabbing

As an extension to the dialect of SCHEME described in
_cite(rrs), _T does not restrict the _Fit(value) expressions
to be _tc(LAMBDA)-expressions.
However, the values of the _Fit(variables)
are not defined until _Fit(body) is evaluated; i.e., the variables should
not be used in the _Fit(value)-expressions.  For example,
_example((LABELS ((A B) (B 1)) . _Fit(body)))
is ill-formed;
at the point when the expressions _tc(B) and _tc(1) are being evaluated,
the variable _tc(B) is bound,
but will have an undefined value.  Consequently, _tc(A) will have an undefined
value.  By contrast, in the well-formed expression

_begin_Example
(LABELS ((A (LAMBDA (X) (+ X B))) (B 1)) . _Fit(body))_rm(,)
_end_Example

which can also be written

_begin_Example
(LABELS (((A X) (+ X B)) (B 1)) . _Fit(body))_rm(,)
_end_Example

the value of _tc(B) is not used before _Fit(body) is evaluated.
The _tc(LAMBDA)-expression evaluates
to a _Fit(closure) that includes _tc(B).  By the time _tc(A) (the closure)
is called, _tc(B) will have a value.

_tc(LABELS) cannot easily be described in terms of _tc(LAMBDA).
However, it can be described in terms of _tc(LAMBDA) and _tc(SET).
(_tc(SET) performs side-effects on bindings; see page _Pageref(SET).)
This is misleading because _tc(LABELS) should not be thought of as a
side-effecting operator.
_DComment(?)
_begin_ExampleTabbing
(LABELS _settab()(_settab()(_Fit(_sub(var,1)) _Fit(_sub(val,1))) _incrtab()_incrtab()_LNL
         (_Fit(_sub(var,2)) _Fit(_sub(val,2))) _LNL
         _dots _LNL
         (_Fit(_sub(var,n)) _Fit(_sub(val,n)))) _decrtab()_LNL
  . _Fit(body)) _LNL
   _equiv() _decrtab()_LNL
(LET _settab()(_settab()(_Fit(_sub(var,1)) (UNDEFINED-VALUE)) _incrtab()_incrtab()_LNL
      (_Fit(_sub(var,2)) (UNDEFINED-VALUE)) _LNL
      _dots _LNL
      (_Fit(_sub(var,n)) (UNDEFINED-VALUE))) _decrtab()_LNL
  (SET _Fit(_sub(var,1)) _Fit(_sub(val,1))) _LNL
  (SET _Fit(_sub(var,2)) _Fit(_sub(val,2))) _LNL
  _dots _LNL
  (SET _Fit(_sub(var,n)) _Fit(_sub(val,n))) _LNL
  . _Fit(body))
_end_ExampleTabbing
This equivalence is overly concrete in that the order of evaluation of
the _Fit(_sub(val,i)) expressions, and the sequence in which the
variables are given their values, is not defined.
_end_Desc

_Section(Locales)
_label(section:locale)

_begin_Inset(_Tv(3):)
	We are working on a module system which will eventually
	subsume the functionality of _wt(locale).
	_Tv(2) had a function called _tc(LOCALE) that has been removed
	in _Tv(3).
_end_Inset

_Fit(Locales) serve two purposes.  First, they provide an incremental or
declarative syntax for creating variable bindings in a contour.  Second,
they provide access to environments as objects which can be dynamically
manipulated.  The term _iix(locale) is used to mean both the kind of
contour introduced by a _tc(LOCALE)-expression, and the object which
represents the environment.

There are no global variables in _T; all variables are lexically
bound in some contour.  Locales play the role of what is known in other
Lisp and Scheme dialects as the global environment.

_Comdefb(`DEFINE',`Special form',
`(DEFINE _Fit(variable) _Fit(value)) _yl() _Fit(undefined)',
`(DEFINE (_Fit(variable) . _Fit(arguments)) . _Fit(body)) _yl() _Undefined')
_label(DEFINE)
_begin_Desc
_tc(DEFINE) creates a binding for _Fit(variable)
in the lexically innermost locale in which the _tc(DEFINE) expression occurs.
The variable is given _Fit(value) as its value.

The second _tc(DEFINE) syntax is for defining procedures.
_begin_Example
(DEFINE (_Fit(variable) . _Fit(arguments)) . _Fit(body))
_end_Example
is equivalent to
_begin_Example
(DEFINE _Fit(variable) (LAMBDA _Fit(arguments) . _Fit(body)))
_end_Example
For example:
_begin_ExampleTabular
(DEFINE (F X) (LIST X 2))    _colsep _equiv()  _colsep (DEFINE F (LAMBDA (X) (LIST X 2))) _LNL
(DEFINE (F . X) (LIST X 2))  _colsep _equiv()  _colsep (DEFINE F (LAMBDA X (LIST X 2)))
_end_ExampleTabular
_end_Desc

_Comdefb(`LSET',`Special form',
`(LSET _Fit(variable value)) _yl() _Fit(undefined)',
`(LSET _Fit(variable value)) _yl() _Fit(value)')
_begin_Desc

The value of the _wt(LSET) special form is undefined, and
it is an error to use an _wt(LSET) form in a value requiring
position.  In _Tv(3.0), _wt(LSET) will continue to return
a value, but an error will be signalled in the future.

_tc(LSET) is identical to _tc(DEFINE) except that the procedure
definition syntax is not permitted, and the variable is declared to be
alterable.  Variables bound by _tc(DEFINE) may not be altered
with _tc(SET); variables bound by _tc(LSET) may be.
See _tc(SET), page _Pageref(SET).
_end_Desc

_Comdef(`MAKE-LOCALE',` ',
`(MAKE-LOCALE _Fit(superior-locale) _Fit(identification)) _yl() _Fit(locale)')
_label(MAKE-LOCALE)
_begin_Desc

Creates a locale inferior to _Fit(superior-locale).  _Fit(Identification)
may be any object, and is used only for debugging purposes.
_begin_Example
(DEFINE *FOO-ENV* (MAKE-LOCALE STANDARD-ENV '*FOO-ENV*))
_end_Example
_end_Desc

_Comdef(`MAKE-EMPTY-LOCALE',` ',
`(MAKE-EMPTY-LOCALE _Fit(identification)) _yl() _Fit(locale)')
_label(MAKE-EMPTY-LOCALE)
_begin_Desc
Creates a locale containing no bindings whatsoever.
_end_Desc

_Comdef(`LOCALE?',`Type predicate',
`(LOCALE? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a locale.
_end_Desc

_Section(Non-local reference)

_Comdef(`*VALUE',`Settable',
`(*VALUE _Fit(locale identifier)) _yl() _Fit(object)')
_begin_Desc

Accesses the value of _Fit(identifier) in _Fit(locale).
If _Fit(identifier) has no value in _Fit(locale), then
the effect of the call to _tc(*VALUE) is undefined.
_begin_ExampleTabular
(*VALUE STANDARD-ENV 'T)             _colsep  _evalto() _colsep  _Fsem(true) _LNL
(LSET MY-LOCALE (MAKE-EMPTY-LOCALE 'MYSTUFF)) _LNL
(*DEFINE MY-LOCALE 'A 10) _LNL
(*VALUE MY-LOCALE 'A)  _colsep _evalto()  _colsep 10
_end_ExampleTabular
_end_Desc

_Comdef(`*DEFINE',` ',
`(*DEFINE _Fit(locale) _Fit(identifier) _Fit(value)) _yl() _Fit(undefined)')
_begin_Desc
Defines the value of _Fit(identifier) in _Fit(locale) to be _Fit(value).
_end_Desc

_Comdef(`*LSET',` ',
`(*LSET _Fit(locale) _Fit(identifier) _Fit(value)) _yl() _Fit(value)')
_begin_Desc
Creates a binding for _Fit(identifier) in _Fit(locale) with initial
value _Fit(value).
_end_Desc

_Comdef(`IMPORT',` ',
`(IMPORT _Fit(locale) . _Fit(variables)) _yl() _Fit(undefined)')
_begin_Desc
Locally defines _Fit(variables) to have the same values as their values
in _Fit(locale).
_begin_ExampleTabbing
(IMPORT _settab()_Fit(locale) _Fit(_sub(var,1) _sub(var,2) _dots _sub(var,n))) _LNL
  _gotab()_equiv() _LNL
(BLOCK _settab()(DEFINE _Fit(_sub(var,1)) (*VALUE _Fit(locale) '_Fit(_sub(var,1)))) _incrtab()_LNL
       (DEFINE _Fit(_sub(var,2)) (*VALUE _Fit(locale) '_Fit(_sub(var,2)))) _LNL
       _dots _LNL
       (DEFINE _Fit(_sub(var,n)) (*VALUE _Fit(locale) '_Fit(_sub(var,n)))))
_end_ExampleTabbing
_end_Desc
