@part[LIBRARY, root "TMAN.MSS"]	    @Comment{-*-System:TMAN-*-}
@appendix[Libraries]
@label[LibrariesAppendix]

This appendix describes various software packages which are not
officially part of the @Tau[] language but which are of general utility.
Some are available within the implementations (@timp[])
directly, while others must be loaded from external files
using @tc[LOAD].

@dc{ Etc.
Talk about the various temporary hacks to get around various implementation
inadequacies.
}

@dc{ What things should be here described?  Refer somewhere to the Yale
looping constructs?  What about DEFINE-APOLLO etc.?
What about the apollo system utilities?
What about @tc[MSG] and the TLISP utilities?
}

@section[The data base]

The @iix[data base] is a global two-dimensional sparse
table indexed by arbitrary objects.  Entries to the data base can be
added, retrieved, and deleted via the system procedures
@tc[PROPERTY] and @tc[REMOVE-PROPERTY].

By being a global resource, the data base violates a basic tenet of the
@Tau[] design philosophy, that the system should have no global resources.
Global resources present modularity problems, because different programs
may make conflicting use of them.  In the case of the data base, program
A might make use of data base entries whose second coordinate is the
symbol @tc[FOO].  If program B also makes use of such data base entries,
but does not know (or want to know) that program A is already making
use of those entries, then each program may write over or be confused by
the other's entries.

The data base corresponds to what is known in other Lisp dialects
as @qu"property lists."

@info[NOTES="Settable"]
@descN[
F1="(PROPERTY @i[object1 object2]) @yl[] @i[object]", FN1="PROPERTY",
F2="(GET @i[object1 object2]) @yl[] @i[object]", FN2="GET"
]
Access the data base entry indexed by @i[object1] and @i[object2].
  @begin[ProgramExample]
(SET (PROPERTY 'FOO 'COLOR) 'RED)    @ev[]  RED
(PROPERTY 'FOO 'COLOR)		     @ev[]  RED
(SET (PROPERTY 'FOO 'COLOR) 'GREEN)  @ev[]  GREEN
(PROPERTY 'FOO 'COLOR)		     @ev[]  GREEN
  @end[ProgramExample]
    @BeginInset[Bug:]
    In @Timp[] 2.7, @i[object1] must be a symbol.
    @EndInset[]
@EndDescN[]

@info[EQUIV="PUTPROP"]
@descN[
F1="(SET-PROPERTY @i[object1 object2 value]) @yl[] @i[value]",
FN1="SET-PROPERTY",
F2="(PUT @i[object1 object2 value]) @yl[] @i[value]", FN2="PUT"
]
Sets the data base entry indexed by @i[object1] and @i[object2].
  @begin[ProgramExample]
(SET-PROPERTY @i[object1 object2 value])
  @ce[]  (SET (PROPERTY @i[object1 object2]) @i[value])
  @end[ProgramExample]
    @BeginInset[Bug:]
    In @Timp[] 2.7, @i[object1] must be a symbol.
    @EndInset[]
@EndDescN[]

@desc[(REMOVE-PROPERTY @i[object1 object2]) @yl[] @i[object] @r[or] @i[false]]
@tc[REMOVE-PROPERTY] removes the data base entry indexed by @i[object1]
and @i[object2].
It returns false if there was no such entry.
(Note that there is no way to distinguish the absence of an entry from
an entry whose value is false.)
@EndDesc[REMOVE-PROPERTY]

@section[Symbol tables]

@dc{ Talk about internedness, etc.  Maybe this section should be flushed?
... pretty random. }

@desc[(MAKE-SYMBOL @i[string]) @yl[] @i[symbol]]
Returns a new symbol whose print name is @i[string].
@EndDesc[MAKE-SYMBOL]

A @iixs[symbol table] maps strings to symbols.

@info[EQUIV="OBARRAY"]
@desc[*THE-SYMBOL-TABLE*]
This variable holds the value of the standard system symbol table.
This is used implicitly by @tc[STRING->SYMBOL] and @tc[READ].
@EndDesc[*THE-SYMBOL-TABLE*]

@desc[(MAKE-SYMBOL-TABLE @i[size]) @yl[] @i[symbol-table]]
Creates a new symbol table, suitable as argument to
@tc[INTERN] and other symbol-table manipulation routines.
@EndDesc[MAKE-SYMBOL-TABLE]

@desc[(INTERN @i[string symbol-table]) @yl[] @i[symbol]]
Looks in @i[symbol-table] for a symbol whose print name
is @tc[STRING-EQUAL?] to @i[string], and returns it if one exists.
If not, it creates a new symbol, whose print name is a copy of @i[string],
and returns it.
@EndDesc[INTERN]

@desc[(REALLY-INTERN @i[string symbol-table]) @yl[] @i[symbol]]
Similar to @tc[INTERN], except that if a
new symbol must be created, @i[string] itself is used as the print name,
not a copy of @i[string].
@EndDesc[REALLY-INTERN]

@desc[(INTERNED @i[string symbol-table]) @yl[] @i[symbol] @r[or] @i[false]]
Looks in @i[symbol-table] for a symbol whose print name
is @tc[STRING-EQUAL?] to @i[string].  Returns it if one exists,
returns false otherwise.
@EndDesc[INTERNED]

@desc[(INTERNED? @i[string symbol-table]) @yl[] @i[boolean]]
  @begin[ProgramExample]
(INTERNED? @i[string symbol-table])
  @ce[]
(TRUE? (INTERNED @i[string symbol-table]))
  @end[ProgramExample]
@EndDescN[INTERNED?]

@info[EQUIV="MAPATOMS"]
@desc[(WALK-SYMBOL-TABLE @i[procedure symbol-table]) @yl[] @i[undefined]]
@i[Procedure] is called on each symbol in @i[symbol-table].
@EndDesc[WALK-SYMBOL-TABLE]


@section[List utilities]

@dc{ Move all that random stuff here from the list chapter. }

@desc[@el[](MEM @i[predicate object list]) @yl[] @i[list]]
Returns the first @i[tail] of @i[list] such that
@tc[(@i[predicate object] (CAR @i[tail]))].
@begin[programExample]
(MEM EQ? 'A '(B A D E))  @ev[]  (A D E)
@end[ProgramExample]
@EndDesc[MEM]

@desc[(MEMQ @i[object list]) @yl[] @i[list]]
@begin[ProgramExample]
(MEMQ @i[object list])  @ce[]  (MEM EQ? @i[object list])
@end[ProgramExample]
@EndDesc[MEMQ]

@dc{ MEMV, MEMV?, ... }

@desc[@el[](ANY @i[predicate . lists]) @yl[] @i[object]]
Calls the @i[predicate] on successive elements of the @i[lists],
stopping as soon as the @i[predicate] returns a value other than false.
This value is returned as @tc[ANY]'s value.
@begin[ProgramExample]
(ANY NUMBER? '(A B 3 FOO))  @ev[]  @r[true]
(ANY NUMBER? '(A B C FOO))  @ev[]  @r[false]
(ANY < '(1 2 3) '(6 6 6))   @ev[]  @r[true]
(ANY MEMQ '(A B C) '((X B) (U B Z) (C D E F)))  @ev[]  (B Z)
@end[ProgramExample]
@dc{that last is a horrible example!...}
@EndDesc[ANY]

@info[EQUIV="SOME"]
@desc[(ANYCDR @i[predicate . lists]) @yl[] @i[object]]
Like @tc[ANY], but the @i[predicate] is called on successive
tails of the @i[lists] instead of successive elements.
@EndDesc[ANYCDR]

@desc[@el[](EVERY @i[predicate . lists]) @yl[] @i[object]]
Calls the @i[predicate] on successive elements of the @i[lists],
stopping as soon as the @i[predicate] returns false.
If for every element @i[predicate] returns true, @tc[EVERY]
returns the value of the last call.
@begin[ProgramExample]
(EVERY NUMBER? '(1 2 3 -15.7))  @ev[]  @r[true]
(EVERY NUMBER? '(1 2 3 FOO))	@ev[]  @r[false]
(EVERY ASSQ '(A B C)	    @dc{ This is why people hate Lisp. }
     '(((A X) (X Y)) ((A J) (B K)) ((C D) (T U))))
  @ev[]  (C D)
@end[ProgramExample]
@EndDesc[EVERY]

@desc[(EVERYCDR @i[predicate . lists]) @yl[] @i[object]]
Like @tc[EVERY], but the @i[predicate] is called on successive
tails of the @i[lists] instead of successive elements.
@EndDesc[EVERYCDR]

@desc[(EVERYCDR? @i[predicate . lists]) @yl[] @i[boolean]]
@begin[ProgramExample]
(EVERYCDR? @i[predicate . lists])  @ce[]  (TRUE? (EVERYCDR @i[predicate . lists]))
@end[ProgramExample]
@EndDesc[EVERYCDR?]

@desc[(ANYCDR? @i[predicate . lists]) @yl[] @i[boolean]]
@begin[ProgramExample]
(ANYCDR? @i[predicate . lists])  @ce[]  (TRUE? (ANYCDR @i[predicate . lists]))
@end[ProgramExample]
@EndDesc[ANYCDR?]

@desc[(POS @i[predicate object list]) @yl[] @i[integer] @r[or] @i[false]]
Returns the position of the first item in @i[list] such that
@tc[(@i[predicate object item])], or false if there is no such
item.
@EndDesc[POS]

@desc[(POSQ @i[object list]) @yl[] @i[integer] @r[or] @i[false]]
@dc{ Randomness. }
@begin[ProgramExample]
(POSQ @i[object list])  @ce[]  (POS EQ? @i[object list])
@end[ProgramExample]
@EndDesc[POSQ]

@desc[(APPEND-REVERSE @i[list ending]) @yl[] @i[list]]
@begin[ProgramExample]
(APPEND-REVERSE @i[list ending])  @ce[]
  (APPEND (REVERSE @i[list]) @i[ending])

(APPEND-REVERSE '(A B C) '(D E))  @ev[]  (C B A D E)
@end[ProgramExample]
@EndDesc[APPEND-REVERSE]

@info[EQUIV="NRECONC"]
@desc[(APPEND-REVERSE! @i[list ending]) @yl[] @i[list]]
  @begin[ProgramExample]
(APPEND-REVERSE! @i[list ending])  @ce[]
(APPEND! (REVERSE! @i[list]) @i[ending])
  @end[ProgramExample]
@EndDesc[APPEND-REVERSE!]

@begin[comment]				
@desc[(DELETE @i[object list]) @yl[] @i[list]]
@ProgramExample[(DELETE @i[object list])  @ce[]  (DEL ALIKEV? @i[object list])]
@EndDesc[DELETE]

@desc[(DELETE! @i[object list]) @yl[] @i[list]]
Destructive version of @tc[DELETE].
@EndDesc[DELETE!]
@end[comment]

@section[Type-specific arithmetic]

A @iixs[fixnum] is an integer whose magnitude lies within an
implementation-dependent range.  This range is guaranteed to include all
integers which are acceptable as array, string, or vector indices.
In @Timp[], this range is the half-open interval
@w<[2@+[-28],2@+[28])>.

@info[NOTES="Type predicate"]
@desc[(FIXNUM? @i[object]) @yl[] @i[boolean]]
Returns true if @i[object] is a fixnum.
@enddesc[FIXNUM?]

@desc[*MAX-FIXNUM* @yl[] @i[integer]]
Returns the largest integer value within the fixnum range.  No integer
answering true to @tc[FIXNUM?] is greater than @tc[*MAX-FIXNUM*].
@enddesc[*MAX-FIXNUM*]

@desc[*MIN-FIXNUM* @yl[] @i[integer]]
Returns the smallest integer value within the fixnum range.  No integer
answering true to @tc[FIXNUM?] is less than @tc[*MIN-FIXNUM*].
  @begin[ProgramExample]
(FIXNUM? @i[x])
@ce[]  (AND (INTEGER? X) (>= @i[x] *MIN-FIXNUM*) (<= @i[x] *MAX-FIXNUM*))
  @end[ProgramExample]
@enddesc[*MIN-FIXNUM*]

@label[FLONUM-ADD]	@Comment{ref: numbers chapter}
The following procedures are defined for performing type-restricted
arithmetic.  These procedures should be considered specializations of
their corresponding generic arithmetic procedures.  They assume
restrictions on the types of their arguments and results.  The prefix
@tc[FX] means @qu"fixnum-specific," and @tc[FL] means
@qu"flonum-specific."  For example,
  @begin[ProgramExample, LongLines Keep]
(FX+ @i[x] @i[y])  @~
@ce[]  (PROCLAIM FIXNUM? (+ (PROCLAIM FIXNUM? @i[x]) (PROCLAIM FIXNUM? @i[y])))
  @end[ProgramExample]
@Timp[] will implement calls to these type-specific procedures in a more
efficient manner than calls to the corresponding generic procedures.

The following list catalogs the available routines.  In most case the
effect of the procedure should be analogous to the example above.  The
one exception is @tc[FX/], which is a specialization of the truncated
(integer) division routine @tc[DIV], not of the division routine @tc[/].
  @begin[ProgramExample]
(FX+ @i[fixnum1 fixnum2]) @yl[] @i[fixnum]@tindex[FX+]
(FL+ @i[fixnum1 fixnum2]) @yl[] @i[flonum]@tindex[FL+]
(FX- @i[fixnum1 fixnum2]) @yl[] @i[fixnum]@tindex[FX-]
(FL- @i[flonum1 flonum2]) @yl[] @i[flonum]@tindex[FL-]
(FX* @i[fixnum1 fixnum2]) @yl[] @i[fixnum]@tindex[FX*]
(FL* @i[fixnum1 fixnum2]) @yl[] @i[flonum]@tindex[FL*]
(FX/ @i[fixnum1 fixnum2]) @yl[] @i[fixnum]@tindex[FX/]
(FL/ @i[flonum1 flonum2]) @yl[] @i[flonum]@tindex[FL/]
(FX= @i[fixnum1 fixnum2]) @yl[] @i[boolean]@tindex[FX=]
(FL= @i[flonum1 flonum2]) @yl[] @i[boolean]@tindex[FL=]
(FX< @i[fixnum1 fixnum2]) @yl[] @i[boolean]@tindex[FX<]
(FL< @i[flonum1 flonum2]) @yl[] @i[boolean]@tindex[FL<]
(FX> @i[fixnum1 fixnum2]) @yl[] @i[boolean]@tindex[FX>]
(FL> @i[flonum1 flonum2]) @yl[] @i[boolean]@tindex[FL>]
(FXN= @i[fixnum1 fixnum2]) @yl[] @i[boolean]@tindex[FXN=]
(FLN= @i[flonum1 flonum2]) @yl[] @i[boolean]@tindex[FLN=]
(FX>= @i[fixnum1 fixnum2]) @yl[] @i[boolean]@tindex[FX>=]
(FL>= @i[flonum1 flonum2]) @yl[] @i[boolean]@tindex[FL>=]
(FX<= @i[fixnum1 fixnum2]) @yl[] @i[boolean]@tindex[FX<=]
(FL<= @i[flonum1 flonum2]) @yl[] @i[boolean]@tindex[FL<=]
(FIXNUM-REMAINDER @i[fixnum1 fixnum2]) @yl[] @i[fixnum]@tindex[FIXNUM-REMAINDER]
(FIXNUM-ODD? @i[fixnum]) @yl[] @i[boolean]@tindex[FIXNUM-ODD?]
(FIXNUM-EVEN? @i[fixnum]) @yl[] @i[boolean]@tindex[FIXNUM-EVEN?]
(FIXNUM-ABS @i[fixnum]) @yl[] @i[fixnum]@tindex[FIXNUM-ABS]
(FIXNUM-MIN @i[fixnum1 fixnum2]) @yl[] @i[fixnum]@tindex[FIXNUM-MIN]
(FIXNUM-MAX @i[fixnum1 fixnum2]) @yl[] @i[fixnum]@tindex[FIXNUM-MAX]
(FIXNUM-LOGAND @i[fixnum1 fixnum2]) @yl[] @i[fixnum]@tindex[FIXNUM-LOGAND]
(FIXNUM-LOGIOR @i[fixnum1 fixnum2]) @yl[] @i[fixnum]@tindex[FIXNUM-LOGIOR]
(FIXNUM-LOGNOT @i[fixnum]) @yl[] @i[fixnum]@tindex[FIXNUM-LOGNOT]
(FIXNUM-ASHR @i[fixnum]) @yl[] @i[fixnum]@tindex[FIXNUM-ASHR]
(FIXNUM-ASHL @i[fixnum]) @yl[] @i[fixnum]@tindex[FIXNUM-ASHL]
(FIXNUM->FLONUM @i[fixnum]) @yl[] @i[flonum]@tindex[FIXNUM->FLONUM]
(FLONUM->FIXNUM @i[flonum]) @yl[] @i[fixnum]@tindex[FLONUM->FIXNUM]

  @end[ProgramExample]
