(herald oload (env tsys))

(let ((oenv (make-locale standard-env 'orbit-env)))
  (*define standard-env 'orbit-env oenv)

  (*define t-implementation-env 'orbit-env oenv)

  (*define oenv 'load-orbit
    (lambda ()
        (load '(build orbit_files) oenv)
        (walk (lambda (f) (load f oenv)) (*value oenv '*orbit-files*))
        (walk (lambda (f) (load f oenv)) (*value oenv '*top-files*))
        (walk (lambda (f) (load f oenv)) (*value oenv '*front-files*))
        (walk (lambda (f) (load f oenv)) (*value oenv '*back-end-files*))
	(walk (lambda (f) (load f oenv)) (*value oenv '*orbit-m68-files*))
        (walk (lambda (f) (load f oenv)) (*value oenv '*tas-files*))
	(walk (lambda (f) (load f oenv)) (*value oenv '*tas-m68-files*))
        (load '(back_end macgen) oenv)
	(load-quietly            '(t3_primops mconstants) oenv)
	((*value oenv 'orbit-m68-init) 't3_primops)
        (*define t-implementation-env 'comfile (*value oenv 'comfile))
	(*define standard-env 'compile (*value oenv 'orbit))
        (walk (lambda (sym)
                (*define standard-env sym (*value oenv sym)))
              '(cl 
                listing
                orbit 
                comfile 
                compile-file 
                comfile2 
                tc-syntax-table
                make-empty-early-binding-locale
                ))))

    oenv)
