(herald maxbuild)
#|

To build a new system from sources:

1. You should be in a directory with sources and tsystem as subdirectories
   Execute the shell script in tsystem/envset
2. Start up tsystem/xt and load this file into orbit-env
3. (compile-support) and (exit)
4. Start up tsystem/xt again and load this file into orbit-env
5. (compile-sources) and (link-t '(tsystem new)) and (exit)
6. cd tsystem; linkt new.o new; cd ..
7. tsystem/new is a T without compiler. Start up new with a large heap.
8. ((*value t-implementation-env 'load-and-suspend-system) '(tsystem new) t)
   (exit)
9. cd tsystem; linkt new.o new    That's it.

|#

;;; Build compiler early binding environment

(*define user-env 'compile-support
(lambda ()	 
(create-support '(t3_primops nconstants) '(t3_primops nconstants))
(load '(t3_primops nconstants t) orbit-env)
(orbit-n32-setup 't3_primops)
(orbit-init 'base)
(set (orbit-syntax-table) primop-syntax-table)
(set *compile-primops?* nil)
(create-support '(t3_primops n32primops)   '(t3_primops n32primops))
(create-support '(t3_primops n32arith)     '(t3_primops n32arith))
(create-support '(t3_primops locations)    '(t3_primops locations))
(create-support '(t3_primops n32low)       '(t3_primops n32low))
(create-support '(t3_primops predicates)       '(t3_primops predicates))
(orbit-init 'base  
            'constants 'primops 'arith 'locations 'low 'predicates)
(create-support '(t3_primops open)    '(t3_primops open))
(create-support '(t3_primops aliases) '(t3_primops aliases))
(create-support '(t3_primops carcdr)  '(t3_primops carcdr))
(create-support '(t3_primops n32genarith)  '(t3_primops n32genarith))))

;;; compile compiler code in early binding environment, runtime system

(*define user-env 'compile-sources
(lambda ()
(set (orbit-syntax-table) primop-syntax-table)
(comfile '(t3_primops base))
(compile-primop-source '(t3_primops n32primops   ni))
(compile-primop-source '(t3_primops n32arith     ni))
(compile-primop-source '(t3_primops locations    ni))
(compile-primop-source '(t3_primops n32low       ni))
(compile-primop-source '(t3_primops n32genarith    ni))
(set *compile-primops?* nil)
(set (table-entry *modules* 'bignum) '(osys n32_bignum))
(load-quietly '(t3_primops nconstants t) orbit-env)
(set (orbit-syntax-table) (env-syntax-table t-implementation-env))
(orbit-n32-init 't3_primops)
(define (comsys system . start)
  (walk (lambda (file)
	  (xcase (car file)
            ((osys)
	     (set (tc-syntax-table) (env-syntax-table t-implementation-env))
	     (comfile file))
	    ((t3_primops)
	     (set (tc-syntax-table) primop-syntax-table)
	     (bind ((write-support-file false))
	       (comfile file)))))
	(let ((files (xcase system
		       ((z) *zvm-system*)
		       ((t) *t-system*))))
	  (if start (mem alikev? (car start) files) files))))
(load '(osys max_files) orbit-env)
(comsys 't)
(comfile '(link defs))
(comfile '(link linker))
(comfile '(link max_link))
(comfile '(link lp_table))
(comfile '(link suspend))
(comfile '(link maxsuspend))
(comfile '(tscheme scheme))
(comfile '(tscheme syntax))
(comfile '(tscheme system))
(comfile '(tscheme runtime))
(comfile '(tscheme compiler))
(set (tc-syntax-table) (env-syntax-table orbit-env))
(walk (lambda (x) (load x orbit-env))
             '((assembler expand)
             (assembler compile_fgs)
             (assembler as_syntax)
             (assembler as_utils)
             ))

(walk comfile
      (append *orbit-files*
	      *top-files*
	      *front-files*
	      *back-end-files*
	      *orbit-n32-files*
               '((assembler as_open)
                (assembler ib)
		(assembler expand)
                (assembler as_utils)
                (assembler compile_fgs)
                (assembler as_syntax)
                (assembler fg)
                (assembler lap)
                (assembler as)
                (assembler count)
                (assembler mark)
                (assembler mini)
                (assembler bits)
                (assembler listing)
		(back_end unn32gen))
	      *tas-n32-files*))))

(define (load-linker . system)
  (let* ((system (if (null? system) 
                     ((*value t-implementation-env 'machine-type) 
                      ((*value t-implementation-env 'local-machine)))
                     (car system)))
         (link-env (make-locale orbit-env 'link-env)))
    (*define standard-env 'link-env link-env)
    (load '(link defs )         link-env)
    (load '(link linker )       link-env)
    (load 
     (case system
       ((aegis) '(link aegis_link ))
       ((sun)   '(link sun_link ))
       ((max)   '(link max_link))
       ((hp)    '(link hp_link ))
       ((vax)   '(link unvax_link ))
       ((mac)    '(link mac_link))
       (else    (error "unknown system - ~a" system)))
     link-env)
    (load
     (case system
       ((vax) '(t3_primops vconstants t))
       ((max) '(t3_primops nconstants))
       (else '(t3_primops mconstants t)))
     link-env)
    (*define standard-env  'link
	     (lambda (files outfile)
	       (set (repl-results) nil)
	       (gc)
	       ((*value link-env 'link) files outfile)))))

(*define user-env 'link-t
(lambda (file)
(load-linker)
(load '(osys max_files) orbit-env)
(link *t-system* file)))


