/*
 *
 * p r i m i t i v e s . c			-- List of STk subrs
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: ??????
 * Last file update:  1-Jun-1994 11:31
 */


#include "stk.h"

struct Primitive {
  char *name;
  char type;
  PRIMITIVE (*fct)();
};


#ifdef USE_STKLOS
extern PRIMITIVE init_hash(void);
extern PRIMITIVE init_stklos(void);
#endif


static struct Primitive Scheme_primitives[] = { 

  /**** Section 4.1 ****/
  {"quote",		tc_syntax,	syntax_quote},
  {"lambda",		tc_syntax,	syntax_lambda},
  {"if",		tc_syntax,	syntax_if},
  {"set!",		tc_syntax,	syntax_setq},
  
  /**** Section 4.2 ****/
  {"cond",		tc_syntax,	syntax_cond},
  {"and",		tc_syntax,	syntax_and},
  {"or",		tc_syntax,	syntax_or},
  {"let",		tc_syntax,	syntax_let},
  {"let*",		tc_syntax,	syntax_letstar},
  {"letrec",		tc_syntax,	syntax_letrec},
  {"begin",		tc_syntax,	syntax_begin},
  {"delay",		tc_syntax,	syntax_delay},
  {"quasiquote",	tc_syntax,	syntax_quasiquote},

  /**** Section 5 ****/
  {"define",		tc_syntax,	syntax_define},

  /**** Section 6.1 ****/
  {"boolean?",		tc_subr_1,	booleanp},
  {"not",		tc_subr_1,	not},

  /**** Section 6.2 ****/
  {"eq?",		tc_subr_2,	eq},
  {"eqv?",		tc_subr_2,	eqv},
  {"equal?",		tc_subr_2,	equal},

  /**** Section 6.3 ****/
  {"pair?",		tc_subr_1,	pairp},
  {"cons",		tc_subr_2,	cons},
  {"car",		tc_subr_1,	car},
  {"cdr",		tc_subr_1,	cdr},
  {"set-car!",		tc_subr_2,	setcar},
  {"set-cdr!",		tc_subr_2,	setcdr},
  {"caar",		tc_subr_1,	caar},
  {"cdar",		tc_subr_1,	cdar},
  {"cadr",		tc_subr_1,	cadr},
  {"cddr",		tc_subr_1,	cddr},
  {"caaar",		tc_subr_1,	caaar},
  {"cdaar",		tc_subr_1,	cdaar},
  {"cadar",		tc_subr_1,	cadar},
  {"cddar",		tc_subr_1,	cddar},
  {"caadr",		tc_subr_1,	caadr},
  {"cdadr",		tc_subr_1,	cdadr},
  {"caddr",		tc_subr_1,	caddr},
  {"cdddr",		tc_subr_1,	cdddr},
  {"caaaar",		tc_subr_1,	caaaar},
  {"cdaaar",		tc_subr_1,	cdaaar},
  {"cadaar",		tc_subr_1,	cadaar},
  {"cddaar",		tc_subr_1,	cddaar},
  {"caadar",		tc_subr_1,	caadar},
  {"cdadar",		tc_subr_1,	cdadar},
  {"caddar",		tc_subr_1,	caddar},
  {"cdddar",		tc_subr_1,	cdddar},
  {"caaadr",		tc_subr_1,	caaadr},
  {"cdaadr",		tc_subr_1,	cdaadr},
  {"cadadr",		tc_subr_1,	cadadr},
  {"cddadr",		tc_subr_1,	cddadr},
  {"caaddr",		tc_subr_1,	caaddr},
  {"cdaddr",		tc_subr_1,	cdaddr},
  {"cadddr",		tc_subr_1,	cadddr},
  {"cddddr",		tc_subr_1,	cddddr},
  {"null?",		tc_subr_1,	nullp},
  {"list?",		tc_subr_1,	listp},
  {"list",		tc_lsubr,	list},
  {"length",		tc_subr_1,	list_length},
  {"append",		tc_lsubr,	append},
  {"reverse",		tc_subr_1,	reverse},
  {"list-tail",		tc_subr_2,	list_tail},
  {"list-ref",		tc_subr_2,	list_ref},
  {"memq",		tc_subr_2,	memq},
  {"memv",		tc_subr_2,	memv},
  {"member",		tc_subr_2,	member},
  {"assq",		tc_subr_2,	assq},
  {"assv",		tc_subr_2,	assv},
  {"assoc",		tc_subr_2,	assoc},

  {"list*",		tc_lsubr,		liststar},		/* + */
  {"copy-tree",		tc_subr_1,		copy_tree},		/* + */

  /**** Section 6.4 ****/
  {"symbol?",		tc_subr_1,		symbolp},
  {"symbol->string",	tc_subr_1,		symbol2string},
  {"string->symbol",	tc_subr_1,		string2symbol},
  {"string-append",	tc_lsubr,		string_append},

  /**** Section 6.5 ****/
  {"number?",		tc_subr_1,		numberp},
  {"complex?",		tc_subr_1,		numberp},
  {"real?",		tc_subr_1,		numberp},
  {"rational?",		tc_subr_1,		numberp},
  {"integer?",		tc_subr_1,		integerp},
  {"exact?",		tc_subr_1,		exactp},
  {"inexact?",		tc_subr_1,		inexactp},
  {"=",			tc_fsubr,		numequal},
  {"<",			tc_fsubr,		lessp},	  
  {">",			tc_fsubr,		greaterp},
  {"<=",		tc_fsubr,		lessep},
  {">=",		tc_fsubr,		greaterep},
  {"zero?",		tc_subr_1,		zerop},
  {"negative?",		tc_subr_1,		negativep},
  {"positive?",		tc_subr_1,		positivep},
  {"odd?",		tc_subr_1,		oddp},
  {"even?",		tc_subr_1,		evenp},
  {"max",		tc_fsubr,		lmax},
  {"min",		tc_fsubr,		lmin},
  {"+",			tc_fsubr,		plus},
  {"-",			tc_fsubr,		difference},
  {"*",			tc_fsubr,		ltimes},
  {"/",			tc_fsubr,		division},
  {"abs",		tc_subr_1,		labsolute},
  {"=",			tc_fsubr,		numequal},
  {"<",			tc_fsubr,		lessp},	  
  {">",			tc_fsubr,		greaterp},
  {"<=",		tc_fsubr,		lessep},
  {">=",		tc_fsubr,		greaterep},
  {"quotient",		tc_subr_2,		lquotient},
  {"remainder",		tc_subr_2,		lremainder},
  {"modulo",		tc_subr_2,		lmodulo},
  {"gcd",		tc_fsubr,		lgcd},
  {"lcm",		tc_fsubr,		llcm},
  {"floor",		tc_subr_1,		lfloor},
  {"ceiling",		tc_subr_1,		lceiling},
  {"truncate",		tc_subr_1,		ltruncate},
  {"round",		tc_subr_1,		lround},
  {"exp",		tc_subr_1,		lexp},
  {"log",		tc_subr_1,		llog},
  {"sin",		tc_subr_1,		lsin},
  {"cos",		tc_subr_1,		lcos},
  {"tan",		tc_subr_1,		ltan},
  {"asin",		tc_subr_1,		lasin},
  {"acos",		tc_subr_1,		lacos},
  {"atan",		tc_subr_1_or_2,		latan},
  {"sqrt",		tc_subr_1,		lsqrt},
  {"expt",		tc_subr_2,		lexpt},
  {"exact->inexact",	tc_subr_1,		exact2inexact},
  {"inexact->exact",	tc_subr_1,		inexact2exact},
  {"string->number",	tc_subr_1_or_2,		string2number},
  {"number->string",	tc_subr_1_or_2,		number2string},

  /**** Section 6.6 ****/
  {"char?",		    tc_subr_1,		charp},

  {"char=?",		    tc_subr_2,		chareq},
  {"char<?",		    tc_subr_2,		charless},
  {"char>?",		    tc_subr_2,		chargt},
  {"char<=?",		    tc_subr_2,		charlesse},
  {"char>=?",		    tc_subr_2,		chargte},

  {"char-ci=?",		    tc_subr_2,		chareqi},
  {"char-ci<?",		    tc_subr_2,		charlessi},
  {"char-ci>?",		    tc_subr_2,		chargti},
  {"char-ci<=?",	    tc_subr_2,		charlessei},
  {"char-ci>=?",	    tc_subr_2,		chargtei},
  
  {"char-alphabetic?",	    tc_subr_1,		char_alphap},
  {"char-numeric?",	    tc_subr_1,		char_numericp},
  {"char-whitespace?",	    tc_subr_1,		char_whitep},
  {"char-upper-case?",	    tc_subr_1,		char_upperp},
  {"char-lower-case?",	    tc_subr_1,		char_lowerp},
  
  {"integer->char",	    tc_subr_1,		integer2char},
  {"char->integer",	    tc_subr_1,		char2integer},
  {"char-upcase",	    tc_subr_1,		char_upper},
  {"char-downcase",	    tc_subr_1,		char_lower},
 
  /**** Section 6.7 ****/
  {"string?",		    tc_subr_1,		stringp},

  {"make-string",	    tc_subr_1_or_2,	make_string},
  {"string",		    tc_lsubr,		lstring},
  {"string-length",	    tc_subr_1,		string_length},
  {"string-ref",	    tc_subr_2,		string_ref},
  {"string-set!",	    tc_subr_3,		string_set},

  {"string=?",		    tc_subr_2,		streq},
  {"string<?",		    tc_subr_2,		strless},
  {"string>?",		    tc_subr_2,		strgt},
  {"string<=?",		    tc_subr_2,		strlesse},
  {"string>=?",		    tc_subr_2,		strgte},

  {"string-ci=?",	    tc_subr_2,		streqi},
  {"string-ci<?",	    tc_subr_2,		strlessi},
  {"string-ci>?",	    tc_subr_2,		strgti},
  {"string-ci<=?",	    tc_subr_2,		strlessei},
  {"string-ci>=?",	    tc_subr_2,		strgtei},

  {"substring",		    tc_subr_3,		substring},
  {"string-append",	    tc_lsubr,		string_append},
  {"string->list",	    tc_subr_1,		string2list},
  {"list->string",	    tc_subr_1,		list2string},
  {"string-copy",	    tc_subr_1,		string_copy},
  {"string-fill!",	    tc_subr_2,		string_fill},

  {"string-find?",	    tc_subr_2,		string_findp},		/* + */
  {"string-lower",	    tc_subr_1,		string_lower},		/* + */
  {"string-upper",	    tc_subr_1,		string_upper},		/* + */


  /**** Section 6.8 ****/
  {"vector?",		    tc_subr_1,		vectorp},
  {"make-vector",	    tc_subr_1_or_2,	make_vector},
  {"vector",		    tc_lsubr,		lvector},
  {"vector-length",	    tc_subr_1,		vector_length},
  {"vector-ref",	    tc_subr_2,		vector_ref},
  {"vector-set!",	    tc_subr_3,		vector_set},
  {"vector->list",	    tc_subr_1,		vector2list},
  {"list->vector",	    tc_subr_1,		list2vector},
  {"vector-fill!",	    tc_subr_2,		vector_fill},

  {"vector-copy",	    tc_subr_1,		vector_copy},		/* + */
  {"vector-resize",	    tc_subr_2,		vector_resize},		/* + */

  /**** Section 6.9 ****/
  {"procedure?",	    tc_subr_1,		procedurep},
  {"apply",		    tc_lsubr,		user_apply},
  {"map",		    tc_lsubr,		lmap},
  {"for-each",		    tc_lsubr,		lfor_each},
  {"force",		    tc_subr_1,		lforce},
  {"call-with-current-continuation",		tc_subr_1, call_cc},

  {"call/cc",		    tc_subr_1,		call_cc},		/* + */
  {"promise?",	  	    tc_subr_1,		promisep},		/* + */
  {"continuation?",	    tc_subr_1,		continuationp},		/* + */
  {"dynamic-wind",	    tc_subr_3,		dynamic_wind},		/* + */
  {"catch",		    tc_fsubr,		lcatch},		/* + */
  {"procedure-body",	    tc_subr_1,		procedure_body},	/* + */

  /**** Section 6.10 ****/
  {"input-port?",	    tc_subr_1,		input_portp},
  {"output-port?",	    tc_subr_1,		output_portp},
  {"current-input-port",    tc_subr_0,		current_input_port},
  {"current-output-port",   tc_subr_0,		current_output_port},
  {"with-input-from-file",  tc_subr_2,		with_input_from_file},
  {"with-output-to-file",   tc_subr_2,		with_output_to_file},
  {"open-input-file",	    tc_subr_1,		open_input_file},
  {"open-output-file",	    tc_subr_1,		open_output_file},
  {"close-input-port",	    tc_subr_1,		close_input_port},
  {"close-output-port",	    tc_subr_1,		close_output_port},
  {"read",		    tc_subr_0_or_1,	lread},
  {"read-char",             tc_subr_0_or_1,    	read_char},
  {"peek-char",             tc_subr_0_or_1,    	peek_char},
  {"eof-object?",	    tc_subr_1,		eof_objectp},
  {"char-ready?",	    tc_subr_0_or_1,	char_readyp},
  {"write",		    tc_subr_1_or_2,	lwrite},
  {"display",		    tc_subr_1_or_2,	display},
  {"newline",		    tc_subr_0_or_1,	newline},
  {"write-char",	    tc_subr_1_or_2,	write_char},
  {"load",		    tc_subr_1,		scheme_load},

  {"open-file",		    tc_subr_2,		open_file},		/* + */	
  {"close-port",	    tc_subr_1,		close_port},		/* + */	
  {"read-line",		    tc_subr_0_or_1,	read_line},		/* + */	
  {"flush",		    tc_subr_0_or_1,	lflush},		/* + */	
  {"try-load",		    tc_subr_1,		try_load},		/* + */	
  {"format",		    tc_lsubr,		format},		/* + */	
  {"error",		    tc_lsubr,		lerror},		/* + */	
  {"input-string-port?",    tc_subr_1,		input_string_portp},	/* + */
  {"output-string-port?",   tc_subr_1,		output_string_portp},	/* + */
  {"current-error-port",    tc_subr_0,		current_error_port},	/* + */
  {"open-input-string",	    tc_subr_1,		open_input_string},	/* + */
  {"open-output-string",    tc_subr_0,		open_output_string},	/* + */
  {"get-output-string",	    tc_subr_1,		get_output_string},	/* + */
  {"with-input-from-string",tc_subr_2,		with_input_from_string},/* + */
  {"read-from-string",	    tc_subr_1,		read_from_string},	/* + */

  /**** Section 6.11 ****/
  {"keyword?",		    tc_subr_1,		keywordp},		/* + */
  {"make-keyword",	    tc_subr_1,		make_keyword},		/* + */
  {"keyword->string",	    tc_subr_1, 		keyword2string},	/* + */
  {"get-keyword",	    tc_subr_2_or_3,	get_keyword},		/* + */

  /**** Section 6.12 ****/
#ifdef USE_TK
  {"widget->string",	    tc_subr_1,		widget2string},		/* + */
  {"string->widget",	    tc_subr_1,		string2widget},		/* + */
  {"tk-command?",	    tc_subr_1,		tk_commandp},		/* + */
  {"widget-name",	    tc_subr_1,		widget_name},		/* + */
  {"widget-environment",    tc_subr_1,		widget_environment},	/* + */
  {"get-widget-data",	    tc_subr_1,		get_widget_data},	/* + */
  {"set-widget-data!",	    tc_subr_2,		set_widget_data},	/* + */
#endif

  /**** Section 6.13 ****/
  {"environment?",	    tc_subr_1,		environmentp},		/* + */
  {"the-environment",	    tc_fsubr,		the_environment},	/* + */
  {"global-environment",    tc_subr_0,		global_environment},	/* + */
  {"environment->list",	    tc_subr_1,		environment2list},	/* + */
  {"procedure-environment", tc_subr_1,		procedure_environment},	/* + */
  {"symbol-bound?",	    tc_subr_1_or_2,	symbol_boundp},		/* + */
  {"eval",		    tc_subr_1_or_2,	user_eval},		/* + */

  /**** Section 6.14 ****/
  {"macro",		    tc_fsubr,		lmacro},		/* + */
  {"macro?",		    tc_subr_1,		macrop},		/* + */
  {"macro-expand",	    tc_fsubr,		macro_expand},		/* + */
  {"macro-body",	    tc_subr_1,		macro_body},		/* + */

  /**** Section 6.15 ****/
  {"address-of",	    tc_subr_1,		address_of},		/* + */
  {"address?",		    tc_subr_1,		addressp},		/* + */

  /**** Section 6.16 ****/
  {"getcwd",		    tc_subr_0,		lgetcwd},		/* + */
  {"chdir",		    tc_subr_1,		lchdir},		/* + */
  {"getpid",		    tc_subr_0,		lgetpid},		/* + */
  {"expand-file-name",	    tc_subr_1,		expand_file_name},	/* + */
  {"system",		    tc_subr_1,		lsystem},		/* + */
  {"!",			    tc_subr_1,		lsystem},		/* + */
  {"getenv",		    tc_subr_1,		lgetenv},		/* + */

  /**** Non standard procedures ****/
  {"eval-string",	    tc_subr_1_or_2,	eval_string},		/* + */
  {"gc",		    tc_subr_0,		lgc},			/* + */
  {"gc-stats",		    tc_subr_0,		gc_stats},		/* + */
  {"version",		    tc_subr_0,		lversion},		/* + */
  {"random",		    tc_subr_1,		lrandom},		/* + */
  {"set-random-seed!",	    tc_subr_1,		set_random_seed},	/* + */
  {"sort",		    tc_subr_2,		lsort},			/* + */
  {"dump",		    tc_subr_1,		ldump},			/* + */
  {"time",		    tc_fsubr,		ltime},			/* + */
  {"uncode",		    tc_subr_1,		luncode},		/* + */
  {"quit",		    tc_subr_0_or_1,	quit_interpreter},	/* + */
  {"exit",		    tc_subr_0_or_1,	quit_interpreter},	/* + */
  {"bye",		    tc_subr_0_or_1,	quit_interpreter},	/* + */

#ifdef USE_TK
  {"trace-var",		    tc_subr_2,		ltrace_var},		/* + */
  {"untrace-var",	    tc_subr_1,		luntrace_var},		/* + */
#endif

  /**** Undocumented primitives */
  {"%get-eval-stack",	    tc_subr_0,		get_eval_stack},
  {"%get-environment-stack", tc_subr_0,		get_env_stack},
#ifdef USE_STKLOS
  {"%init-hash",	    tc_subr_0,		init_hash},
  {"%init-stklos",	    tc_subr_0,		init_stklos},
#endif

  { "", 0, (SCM (*)()) NULL }
};

void init_primitives()
{
  register struct Primitive *p = Scheme_primitives;
  register SCM z;

  for (p = Scheme_primitives; *p->name; p++) {
    /* Create a subr cell and store it in the obarray */
    NEWCELL(z, p->type);
    z->storage_as.subr.name = p->name;
    z->storage_as.subr0.f   = p->fct;
    VCELL(intern(p->name))  =  z;
  }

#ifdef USE_TK
  /* Init Unix special Tcl procedures (on test for now; should disappear) */
  Tcl_CreateCommand(main_interp, "file",   Tcl_FileCmd, NULL, NULL);
  Tcl_CreateCommand(main_interp, "lindex", Tcl_LindexCmd, NULL, NULL);
  Tcl_CreateCommand(main_interp, "%string", Tcl_StringCmd, NULL, NULL);
  Tcl_CreateCommand(main_interp, "glob",   Tcl_GlobCmd, NULL, NULL);
#endif
}
