/*
 *
 * d y n l o a d . h			-- All the stuff dealing with 
 *					   dynamic loading
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: 23-Jan-1994 19:09
 * Last file update:  1-Mar-1994 10:59
 */

#define EXT_ISPROC 	01	/* procedure? should answer #t */
#define EXT_EVALPARAM 	02	/* evaluates parameter list when apply */

typedef struct {
  char *type_name;		/* The external name of this type */
  int  flags;			
  void (*gc_mark_fct)(SCM x);
  void (*gc_sweep_fct)(SCM x);
  SCM  (*apply_fct)(SCM x, SCM args, SCM env);
  void (*display_fct)(SCM x, FILE *f, int mode);
} extended_scheme_type;

int extended_type_stamp;

/****
 *
 * User interface
 *
 ****/
int  add_new_type(extended_scheme_type *p);
void add_new_primitive(char *fct_name, int fct_type, void *fct_ptr);
void set_global_var(char *name, SCM value);
SCM STk_eval_string(char *s, SCM env);

/****
 * 
 * Internals 
 *
 ****/
void load_object_file(char *path);

void extended_mark(SCM x);
void extended_sweep(SCM x);
SCM  extended_apply(SCM x, SCM args, SCM env);
void extended_display(SCM x, FILE *f, int mode);
SCM  extended_procedurep(SCM x);
SCM  extended_eval_parameters(SCM x);
