#include <stk.h>

static PRIMITIVE when(SCM l, SCM env)
{
  SCM res = UNDEFINED;

  Debug("On demande when sur", l);

  if (NULLP(l)) err("when: no argument list given", NIL);
  if (leval(CAR(l), env) != ntruth) {
    if (NULLP(l = CDR(l))) err("when: null body", NIL);
    
    /* Argument list is well formed. Evaluates each expression of the body */
    for (  ; !NULLP(l); l = CDR(l))
      res = leval(CAR(l), env);
  }
  return res;
}

static PRIMITIVE unless(SCM l, SCM env)
{
  SCM res = UNDEFINED;

  if (!NULLP(l)) {
    if (leval(CAR(l), env) == ntruth) {
      for (l = CDR(l); !NULLP(l); l = CDR(l)) {
	res = leval(CAR(l), env);
      }
    }
  }
  return res;
}

  
void init_when(void)
{
  add_new_primitive("when", 	   tc_fsubr, when);
  add_new_primitive("unless",	   tc_fsubr, when);
}
