'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/scale.n,v 1.10 93/04/01 09:52:53 ouster Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS scale tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
scale \- Create and manipulate scale widgets
.SH SYNOPSIS
\fBscale\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBactiveForeground\fR	\fBborderWidth\fR	\fBfont\fR	\fBorient\fR
\fBbackground\fR	\fBcursor\fR	\fBforeground\fR	\fBrelief\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies the prefix of a Tcl command to invoke whenever the value of
the scale is changed interactively.  The actual command consists
of this option followed by
a space and a number.  The number indicates the new value of the
scale.
.LP
.nf
Name:	\fBfrom\fR
Class:	\fBFrom\fR
Command-Line Switch:	\fB\-from\fR
.fi
.IP
Specifies the value corresponding to the left or top end of the
scale.  Must be an integer.
.LP
.nf
Name:	\fBlabel\fR
Class:	\fBLabel\fR
Command-Line Switch:	\fB\-label\fR
.fi
.IP
Specifies a string to displayed  as a label for the scale.  For
vertical scales the label is displayed just to the right of the
top end of the scale.  For horizontal scales the label is displayed
just above the left end of the scale.
.LP
.nf
Name:	\fBlength\fR
Class:	\fBLength\fR
Command-Line Switch:	\fB\-length\fR
.fi
.IP
.VS
Specifies the desired long dimension of the scale in screen units
(i.e. any of the forms acceptable to \fBTk_GetPixels\fR).
.VE
For vertical scales this is the scale's height;  for horizontal scales
it is the scale's width.
.LP
.nf
Name:	\fBshowValue\fR
Class:	\fBShowValue\fR
Command-Line Switch:	\fB\-showvalue\fR
.fi
.IP
Specifies a boolean value indicating whether or not the current
value of the scale is to be displayed.
.LP
.nf
Name:	\fBsliderForeground\fR
Class:	\fBsliderForeground\fR
Command-Line Switch:	\fB\-sliderforeground\fR
.fi
.IP
Specifies the color to use for drawing the slider under normal conditions.
When the mouse is in the slider window then the slider's color is
determined by the \fBactiveForeground\fR option.
.LP
.nf
Name:	\fBsliderLength\fR
Class:	\fBSliderLength\fR
Command-Line Switch:	\fB\-sliderlength\fR
.fi
.IP
.VS
Specfies the size of the slider, measured in screen units along the slider's
long dimension.  The value may be specified in any of the forms acceptable
to \fBTk_GetPixels\fR.
.LP
.nf
.VS
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB\-state\fR
.fi
.IP
Specifies one of two states for the scale:  \fBnormal\fR or \fBdisabled\fR.
If the scale is disabled then the value may not be changed and the scale
won't activate when the mouse enters it.
.VE
.LP
.nf
Name:	\fBtickInterval\fR
Class:	\fBTickInterval\fR
Command-Line Switch:	\fB\-tickinterval\fR
.fi
.IP
Must be an integer value.  Determines the spacing between numerical
tick-marks displayed below or to the left of the slider.  If specified
as 0, then no tick-marks will be displayed.
.LP
.nf
Name:	\fBto\fR
Class:	\fBTo\fR
Command-Line Switch:	\fB\-to\fR
.fi
.IP
Specifies the value corresponding to the right or bottom end of the
scale.  Must be an integer.  This value may be either less than or
greater than the \fBfrom\fR option.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
.VS
Specifies the desired narrow dimension of the scale in screen units
(i.e. any of the forms acceptable to \fBTk_GetPixels\fR).
.VE
For vertical scales this is the scale's width;  for horizontal scales
this is the scale's height.
.BE

.SH DESCRIPTION
.PP
The \fBscale\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a scale widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the scale such as its colors, orientation,
and relief.  The \fBscale\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A scale is a widget that displays a rectangular region and a
small \fIslider\fR.  The rectangular region corresponds to a range
of integer values (determined by the \fBfrom\fR and \fBto\fR options),
and the position of the slider selects a particular integer value.
The slider's position (and hence the scale's value) may be adjusted
by clicking or dragging with the mouse as described in the BINDINGS
section below.  Whenever the scale's value is changed, a Tcl
command is invoked (using the \fBcommand\fR option) to notify
other interested widgets of the change.
.PP
Three annotations may be displayed in a scale widget:  a label
appearing at the top-left of the widget (top-right for vertical
scales), a number displayed just underneath the slider
(just to the left of the slider for vertical scales), and a collection
of numerical tick-marks just underneath the current value (just to the left of
the current value for vertical scales).  Each of these three
annotations may be selectively enabled or disabled using the
configuration options.

.SH "WIDGET COMMAND"
.PP
The \fBscale\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for scale widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBscale\fR
command.
.TP
\fIpathName \fBget\fR
Returns a decimal string giving the current value of the scale.
.TP
\fIpathName \fBset\fR \fIvalue\fR
This command is invoked to change the current value of the scale,
and hence the position at which the slider is displayed.  \fIValue\fR
gives the new value for the scale.

.SH BINDINGS
.PP
When a new scale is created, it is given the following initial
behavior by default:
.TP 20
\fB<Enter>\fR
Change the slider display to use \fBactiveForeground\fR instead of
\fBsliderForeground\fR.
.TP 20
\fB<Leave>\fR
Reset the slider display to use \fBsliderForeground\fR instead of
\fBactiveForeground\fR.
.TP 20
\fB<ButtonPress-1>\fR
Change the slider display so that the slider appears sunken rather
than raised.  Move the slider (and adjust the scale's value)
to correspond to the current mouse position.
.TP 20
\fB<Button1-Motion>\fR
Move the slider (and adjust the scale's value) to correspond to
the current mouse position.
.TP 20
\fB<ButtonRelease-1>\fR
Reset the slider display so that the slider appears raised again.

.SH KEYWORDS
scale, widget
