/* 
 * t k - m a i n . c 			-- Initialization of Tk
 *
 * This code initializes the Tk library. It corresponds to a part of the 
 * file main.c of the wish interpreter. 
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 13-May-1993 10:59
 * Last file update:  3-Jan-1994 04:20
 *
 *
 * Code used here was originally copyrigthed as shown below:
 *      Copyright 1990-1992 Regents of the University of California.
 *
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 */
#ifdef USE_TK
#include <signal.h>
#include "stk.h"


/*
 * Command used to initialize wish:
 */

static char initCmd[] = "(load (string-append tk_library \"/tk-init.stk\"))";

/*
 * Global variables used by the main program:
 */

static Tk_Window w;		/* The main window for the application.  If
				 * NULL then the application no longer
				 * exists. */
Tcl_Interp *main_interp= NULL;	/* Interpreter for this application. */
int tk_initialized = 0;		/* 1 when Tk is fully initialized */

/*
 * Command-line options:
 */

static int synchronize 	= 0;
static int no_tk 	= 0;
static char *fileName 	= NULL;
static char *name 	= NULL;
static char *Xdisplay 	= NULL;
static char *geometry 	= NULL;
static char *startup  	= NULL;


Tk_ArgvInfo argTable[] = {
    {"-file", TK_ARGV_STRING, (char *) NULL, (char *) &fileName,
	"File from which to read commands"},
    {"-geometry", TK_ARGV_STRING, (char *) NULL, (char *) &geometry,
	"Initial geometry for window"},
    {"-display", TK_ARGV_STRING, (char *) NULL, (char *) &Xdisplay,
	"Display to use"},
    {"-name", TK_ARGV_STRING, (char *) NULL, (char *) &name,
	"Name to use for application"},
    {"-sync", TK_ARGV_CONSTANT, (char *) 1, (char *) &synchronize,
	"Use synchronous mode for display server"},
    {"-no-tk", TK_ARGV_CONSTANT, (char *) 1, (char *) &no_tk,
       "Don't start Tk"},
    {"-load", TK_ARGV_STRING, (char *) NULL, (char *) &startup,
       "file to load after all the initialization are done"},
    {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,
	(char *) NULL}
};

/*
 * Forward declarations for procedures defined later in this file:
 */

static void DelayedMap _ANSI_ARGS_((ClientData clientData));
static void StructureProc _ANSI_ARGS_((ClientData clientData,
				       XEvent *eventPtr));
static void Init_argc_argv(int argc, char **argv);


/*
 *----------------------------------------------------------------------
 *
 * Tk_main
 *
 *----------------------------------------------------------------------
 */

int Tk_main(int argc, char **argv)
{
  char *p;
  Tk_3DBorder border;

  no_tk = synchronize = 0;
  fileName = name = Xdisplay = geometry = startup = NULL;

  main_interp = Tcl_CreateInterp();
#ifdef TCL_MEM_DEBUG
    Tcl_InitMemory(interp);
#endif
  
  /*
   * Parse command-line arguments.
   */
  
  if (Tk_ParseArgv(main_interp, (Tk_Window) NULL, &argc, argv, argTable, 0)
      != TCL_OK) {
    fprintf(stderr, "%s\n", main_interp->result);
    exit(1);
  }

  /* Initialize global variables */
  Init_argc_argv(argc-1, argv+1);


  /* Exit if no-tk is specified */
  if (no_tk || !getenv("DISPLAY")) {
    if (fileName != NULL) {
      /* Reset default action on sigint since it is not interactive */
      signal(SIGINT, SIG_DFL);
      Tcl_VarEval(main_interp, "(load \"", fileName, "\")", (char *) NULL);
      exit(0);
    }
    return;
  }

  Tcl_SetVar(main_interp, "*geometry*", geometry? geometry: "", TCL_GLOBAL_ONLY);

  if (name == NULL) {
    if (fileName != NULL) {
      p = fileName;
    } else {
      p = argv[0];
    }
    name = strrchr(p, '/');
    if (name != NULL) {
      name++;
    } else {
      name = p;
    }
  }

  /*
   * Initialize the Tk application and arrange to map the main window
   * after the startup script has been executed, if any.  This way
   * the script can withdraw the window so it isn't ever mapped
   * at all.
   */

  
  w = Tk_CreateMainWindow(main_interp, Xdisplay, name, "STk");
  if (w == NULL) {
    fprintf(stderr, "%s\n", main_interp->result);
    exit(1);
  }

  Tk_CreateEventHandler(w, StructureNotifyMask, StructureProc,
			(ClientData) NULL);
  Tk_DoWhenIdle(DelayedMap, (ClientData) NULL);
  if (synchronize) {
    XSynchronize(Tk_Display(w), True);
  }
  Tk_GeometryRequest(w, 200, 200);
  border = Tk_Get3DBorder(main_interp, w, None, "#cccccc");
  if (border == NULL) {
    Tcl_SetResult(main_interp, (char *) NULL, TCL_STATIC);
    Tk_SetWindowBackground(w, WhitePixelOfScreen(Tk_Screen(w)));
  } 
  else {
    Tk_SetBackgroundFromBorder(w, border);
  }
  XSetForeground(Tk_Display(w), DefaultGCOfScreen(Tk_Screen(w)),
		 BlackPixelOfScreen(Tk_Screen(w)));
  

  init_tracevar(); 	/* Initialize the variable tracing mechanism */
  init_glue();
  tk_initialized = 1;   /* Ok, it's fully initialized		     */

  /*
   * Execute Stk's initialization script, followed by the script specified
   * on the command line, if any.
   */
  
  Tcl_GlobalEval(main_interp, initCmd);

  if (fileName != NULL) {
    /* Evaluate contents of *init-hook* */
    leval(VCELL(intern(INIT_HOOK)), NIL);

    Tcl_VarEval(main_interp, "(load \"", fileName, "\")", (char *) NULL);
    /* Reset default action on sigint since it is not interactive */
    signal(SIGINT, SIG_DFL);
    interactivep = 0;
    Tk_MainLoop();
    exit(0);
  } 
  else {
    /*
     * Commands will come from standard input.  Set up a handler
     * to receive stdin characters and print a prompt if the input
     * device is a terminal.
     */
    extern void StdinProc();
    
    Tk_CreateFileHandler(0, TK_READABLE, StdinProc, (ClientData) 0);
    /* load the startup file if specified */
    if (startup)
      Tcl_VarEval(main_interp, "(load \"", startup, "\")", (char *) NULL);
    Tcl_GlobalEval(main_interp, "(update)");
  }
}

/*
 *----------------------------------------------------------------------
 *
 * StructureProc --
 *
 *	This procedure is invoked whenever a structure-related event
 *	occurs on the main window.  If the window is deleted, the
 *	procedure modifies "w" to record that fact.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Variable "w" may get set to NULL.
 *
 *----------------------------------------------------------------------
 */

static void StructureProc(clientData, eventPtr)
     ClientData clientData;	/* Information about window. */
     XEvent *eventPtr;		/* Information about event. */
{
  if (eventPtr->type == DestroyNotify) {
    w = NULL;
  }
}

/*
 *----------------------------------------------------------------------
 *
 * DelayedMap --
 *
 *	This procedure is invoked by the event dispatcher once the
 *	startup script has been processed.  It waits for all other
 *	pending idle handlers to be processed (so that all the
 *	geometry information will be correct), then maps the
 *	application's main window.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The main window gets mapped.
 *
 *----------------------------------------------------------------------
 */

static void DelayedMap(clientData)
    ClientData clientData;	/* Not used. */
{

    while (Tk_DoOneEvent(TK_IDLE_EVENTS) != 0) {
	/* Empty loop body. */
    }
    if (w == NULL) {
	return;
    }
    Tk_MapWindow(w);
}

/*
 *----------------------------------------------------------------------
 *
 * Init_argc_argv --
 *
 *----------------------------------------------------------------------
 */

static void Init_argc_argv(int argc, char **argv)
{
  SCM l = NIL;

  VCELL(intern(ARGC)) = makeinteger(argc);

  while (argc--) {
    l = cons(makestrg(strlen(*argv), *argv), l);
    argv++;
  }
  
  VCELL(intern(ARGV)) = reverse(l);
  VCELL(intern("*program-name*")) =  makestrg(strlen(Argv0), Argv0);
}

#endif /* USE_TK */
