/*
 * p r i n t . c				-- writing stuff
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: ??-Oct-1993 ??:?? 
 * Last file update: 16-Dec-1993 17:50
 *
 */

#include "stk.h"

static char valid_symbol_chars[]="abcdefghijklmnopqrstuvwxyz0123456789"
				 "+-.*/<=>!?:$%_&~^";

static void printlist(SCM exp, FILE *f, int mode)
{
  SCM tmp;
  lprint(CAR(exp),f, mode);
  for (tmp=CDR(exp); CONSP(tmp); tmp=CDR(tmp)) {
    Putc(' ', f);
    lprint(CAR(tmp), f, mode);
  }
  if (NNULLP(tmp)) {
    Puts(" . ", f);
    lprint(tmp,f, mode);
  }
}

static void printsymbol(char *s, FILE*f, int mode)
{
  if (mode==WRT_MODE) {	/* See if we need to enclose pname between a "|" pair */
    register char *p;
    for (p = s; *p; p++) {
      if (!strchr(valid_symbol_chars, *p)) {
	Putc('|', f);  Puts(s, f); Putc('|', f);
	return;
      }
    }
  }
  Puts(s, f);
}
    
SCM lprint(SCM exp, FILE *f, int mode)
{
  switch TYPE(exp) {
    case tc_nil:
      Puts("()", f);
      break;
    case tc_undefined:
      Puts("#<undefined>", f);
      break;
    case tc_boolean:
      Puts(EQ(exp, truth) ? "#t" : "#f", f);
      break;
    case tc_eof:
      Puts("#<eof>", f);
      break;
    case tc_cons:
      Putc('(', f); printlist(exp, f, mode); Putc(')', f);
      break;
    case tc_integer:
    case tc_bignum:
    case tc_flonum:
      {
	char buffer[100];

	char *s = number2Cstr(exp, 10, buffer);
	Puts(s, f);
	if (TYPE(exp) == tc_bignum) free(s);
      }
      break;
    case tc_symbol:
      printsymbol(PNAME(exp), f, mode);
      break;
    case tc_keyword:
      if (mode != DSP_MODE) Putc(':', f);
      Puts(KEYVAL(exp)+1, f);
      break;
    case tc_subr_0:
    case tc_subr_1:
    case tc_subr_2:
    case tc_subr_3:
    case tc_subr_0_or_1:
    case tc_subr_1_or_2:
    case tc_lsubr:
    case tc_fsubr:
    case tc_syntax:
      Puts("#<subr ", f);
      Puts((*exp).storage_as.subr.name, f);
      Putc('>', f);
      break;
    case tc_closure:
      sprintf(tkbuffer, "#<closure %lx>", (unsigned) exp);
      Puts(tkbuffer, f);
      break;
    case tc_char:
      if (mode!=DSP_MODE){
	Puts("#\\", f);
	Puts(char2string(CHAR(exp)), f);
      }
      else Putc(CHAR(exp), f);
      break;      
    case tc_string:
      {
	register char *p;

	if (mode!=DSP_MODE) {
	  Putc('"', f);
	  for (p = CHARS(exp); *p; p++) {
	    if (*p == '"' || *p == '\\') Putc('\\', f);
	    Putc(*p, f);
	  }
	  Putc('"', f);
	}
	else Puts(CHARS(exp), f);
      }
      break;
    case tc_vector:
      {
        int j, n = exp->storage_as.vector.dim;
        
        Puts("#(", f);
        for(j=0; j < n; j++) {
	  lprint(VECT(exp)[j],f, mode);
	  if ((j + 1) < n) Putc(' ', f);
	}
        Putc(')', f);
      }
      break;         
    case tc_iport:
      sprintf(tkbuffer, "#<input-port %lx %s>", 
                        exp->storage_as.port.f, exp->storage_as.port.name);
      Puts(tkbuffer, f);
      break;
    case tc_oport:
      sprintf(tkbuffer, "#<output-port %lx %s>", 
                        exp->storage_as.port.f, exp->storage_as.port.name);
      Puts(tkbuffer, f);
      break;
    case tc_isport:
      sprintf(tkbuffer, "#<input-string-port %lx>", exp->storage_as.port.f);
      Puts(tkbuffer, f);
      break;
    case tc_osport:
      sprintf(tkbuffer, "#<output-string-port %lx>", exp->storage_as.port.f);
      Puts(tkbuffer, f);
      break;
    case tc_macro:
      sprintf(tkbuffer, "#<macro %lx>", (unsigned) exp);
      Puts(tkbuffer, f);
      break;
    case tc_localvar:
      sprintf(tkbuffer,"#<local %s @%d,%d)>",PNAME(exp->storage_as.localvar.symbol),
	      				     exp->storage_as.localvar.level, 
					     exp->storage_as.localvar.position);
      Puts(tkbuffer, f);
      break;
    case tc_globalvar:
      sprintf(tkbuffer, "#<global %s>", PNAME(VCELL(exp)));
      Puts(tkbuffer, f);
      break;
    case tc_cont:
      sprintf(tkbuffer, "#<continuation %x>", (unsigned) exp);
      Puts(tkbuffer, f);
      break;
    case tc_env:
      sprintf(tkbuffer, "#<environment %x>", (unsigned) exp);
      Puts(tkbuffer, f);
      break;
#ifdef USE_TK
    case tc_tkcommand:
      if (mode != TK_MODE) Puts("#<Tk-command ", f);
      Puts(exp->storage_as.tk.data->Id, f);
      if (mode != TK_MODE) Putc('>', f);
      break;
#endif
    case tc_quote:
      Puts("#quote", f);
      break;
    case tc_lambda:
      Puts("#lambda", f); 
      break;
    case tc_if:
      Puts("#if", f); 
      break;
    case tc_setq:
      Puts("#setq", f); 
      break;
    case tc_cond:
      Puts("#cond", f); 
      break;
    case tc_and:
      Puts("#and", f); 
      break;
    case tc_or:
      Puts("#or", f); 
      break;
    case tc_let:
      Puts("#let", f); 
      break;
    case tc_letstar:
      Puts("#let*", f); 
      break;
    case tc_letrec:
      Puts("#letrec", f); 
      break;
    case tc_begin:
      Puts("#begin", f); 
      break;
    case tc_promise:
      sprintf(tkbuffer, "#<promise %lx (%sforced)>", 
	      		(unsigned) exp, 
	      		exp->storage_as.promise.resultknown ? "" : "not ");
      Puts(tkbuffer, f);
      break;
    case tc_unbound:
      Puts("#<unbound>", f);
      break;
    default:
      sprintf(tkbuffer, "#<unknown %d %lx>", TYPE(exp), exp);
      Puts(tkbuffer, f);
  }
  return UNDEFINED;
}
