/*
 *
 *  g c . c			-- Mark and Sweep Garbage Collector 
 *
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *            Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 17-Feb-1993 12:27
 * Last file update: 13-Dec-1993 20:35
 *
 *
 */

extern SCM freelist;
extern char *stack_start_ptr;
extern double alloccells;

#define NEWCELL(_into,_type)    \
{ 				\
  if (NULLP(freelist))		\
    gc_for_newcell();		\
  _into = freelist;		\
  freelist = CDR(freelist);	\
  alloccells++;			\
  _into->gc_mark = 0;		\
  _into->type    = _type;	\
}


void gc_mark_and_sweep(void);
void gc_for_newcell(void);
void gc_protect(SCM location);

PRIMITIVE lgc(void);

void init_gc(void);


