/*
 *
 * e r r o r . c 			-- The error procedure
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 14-Nov-1993 14:58
 * Last file update: 15-Dec-1993 06:41
 */

#include "stk.h"

extern int nointerrupt;

jmp_buf *top_jmp_buf;
long error_context;

void err(char *message, SCM x)
{
  SCM tmp;
  static int already_here=0; /* to avoid loops when report-error proc is buggy */
  char *head;

  if (*message) {
    switch (error_context) {
      case ERR_READ_FROM_STRING: head = "*** Read from string error:\n"; break;
      case ERR_FATAL: 	
      case ERR_OK:	         head = "*** Error:\n"; break;
      case ERR_IGNORED:	         goto Out;
#ifdef USE_TK
      case ERR_TK_BACKGROUND:    head = "*** Tk background error:\n"; break;
#endif
    }

    tmp = intern("report-error");
    if (symbol_boundp(tmp, globenv)==truth && !already_here && *message) {
      already_here = 1;
      apply(leval(tmp, NIL), cons(makestrg(strlen(head), head),
				  cons(makestrg(strlen(message), message),
				       cons(luncode(x), NIL))));
    }
    else {
      if (already_here) fprintf(stderr, "WARNING: report-error is buggy!!\n");
      fprintf(stderr, "\n%s    %s", head, message);
      if (NNULLP(x)) {fprintf(stderr, ": "); lprint(luncode(x), stderr, WRT_MODE);}
      show_eval_stack(5);
    }
  }
Out:
  reset_eval_stack();
  /* 
   * Do all the telminal thunk of dynamic winds and make a long jump to
   * location retained in top_jmp_buf 
   */
  already_here    = 0;
  lunwind_all();

  switch (error_context) {
    case ERR_FATAL: 
      fprintf(stderr, "FATAL ERROR IN CRITICAL CODE SECTION. ABANDON\n");
      exit(1);
    default:
      longjmp(*top_jmp_buf, 1);
  }
}
