
/*  *************************************************************************
    macwind.c -- The Macintosh window functions code for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "macqd.h"
#include "macwind.h"
#include "version.h"


/*  ************************************************************************/


static Str255 GStr255;
static char ARG6[] = "arg6";
static char ARG7[] = "arg7";
static char ARG8[] = "arg8";
static char ARG9[] = "arg9";


/*  ************************************************************************/


#define GRAF_RECT(g)	    ((g)->portRect)
#define GRAF_BACKPAT(g)	    ((g)->bkPat)
#define GRAF_FILLPAT(g)	    ((g)->fillPat)
#define GRAF_PENLOC(g)	    ((g)->pnLoc)
#define GRAF_PENSIZE(g)	    ((g)->pnSize)
#define GRAF_PENMODE(g)	    ((g)->pnMode)
#define GRAF_PENPAT(g)	    ((g)->pnPat)
#define GRAF_PENVIS(g)	    ((g)->pnVis)
#define GRAF_FONT(g)	    ((g)->txFont)
#define GRAF_FACE(g)	    ((g)->txFace)
#define GRAF_MODE(g)	    ((g)->txMode)
#define GRAF_SIZE(g)	    ((g)->txSize)
#define GRAF_FORECOLOR(g)   ((g)->fgColor)
#define GRAF_BACKCOLOR(g)   ((g)->bkColor)
#define WIND_KIND(w)	(((WindowRecord *) (w))->windowKind)
#define WIND_VISIBLE(w) (((WindowRecord *) (w))->visible)
#define WIND_HILITED(w) (((WindowRecord *) (w))->hilited)
#define WIND_GOAWAY(w)	(((WindowRecord *) (w))->goAwayFlag)
#define WIND_SPARE(w)	(((WindowRecord *) (w))->spareFlag)


/*  ************************************************************************/


#define SUBRS(x)								\
x("wind-new",		    w_new,	SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("wind-set-title",	    w_s_title,	WINDSTRING_FUNC,    SetWTitle)		\
x("wind-get-title",	    w_g_title,	WIND_STRING_FUNC,   GetWTitle)		\
x("wind-set-ref",	    w_s_ref,	SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("wind-get-ref",	    w_g_ref,	SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("wind-get-rect",	    w_g_rect,	WIND_RECT_FUNC,	    GRAF_RECT)		\
x("wind-get-back-pattern",  w_g_bk_pat, WIND_PAT_FUNC,	    GRAF_BACKPAT)	\
x("wind-get-fill-pattern",  w_g_fl_pat, WIND_PAT_FUNC,	    GRAF_FILLPAT)	\
x("wind-get-pen-location",  w_g_pn_loc, WIND_PT_FUNC,	    GRAF_PENLOC)	\
x("wind-get-pen-size",	    w_g_pn_siz, WIND_PT_FUNC,	    GRAF_PENSIZE)	\
x("wind-get-pen-mode",	    w_g_pn_mod, WIND_INT_FUNC,	    GRAF_PENMODE)	\
x("wind-get-pen-pattern",   w_g_pn_pat, WIND_PAT_FUNC,	    GRAF_PENPAT)	\
x("wind-get-pen-visible",   w_g_pn_vis, WIND_INT_FUNC,	    GRAF_PENVIS)	\
x("wind-get-font",	    w_g_font,	WIND_INT_FUNC,	    GRAF_FONT)		\
x("wind-get-face",	    w_g_face,	WIND_INT_FUNC,	    GRAF_FACE)		\
x("wind-get-mode",	    w_g_mode,	WIND_INT_FUNC,	    GRAF_MODE)		\
x("wind-get-size",	    w_g_size,	WIND_INT_FUNC,	    GRAF_SIZE)		\
x("wind-get-fore-color",    w_g_f_col,	WIND_INT_FUNC,	    GRAF_FORECOLOR)	\
x("wind-get-back-color",    w_g_b_col,	WIND_INT_FUNC,	    GRAF_BACKCOLOR)	\
x("wind-get-kind",	    w_g_kind,	WIND_INT_FUNC,	    WIND_KIND)		\
x("wind-get-visible",	    w_g_vis,	WIND_BOOL_FUNC,	    WIND_VISIBLE)	\
x("wind-get-hilited",	    w_g_hil,	WIND_BOOL_FUNC,	    WIND_HILITED)	\
x("wind-get-go-away",	    w_g_goaway, WIND_BOOL_FUNC,	    WIND_GOAWAY)	\
x("wind-get-spare",	    w_g_spare,	WIND_BOOL_FUNC,	    WIND_SPARE)		\
x("wind-close",		    w_close,	WIND_FUNC,	    CloseWindow)	\
x("wind-dispose",	    w_dispose,	WIND_FUNC,	    DisposeWindow)	\
x("wind-select",	    w_select,	WIND_FUNC,	    SelectWindow)	\
x("wind-hide",		    w_hide,	WIND_FUNC,	    HideWindow)		\
x("wind-show",		    w_show,	WIND_FUNC,	    ShowWindow)		\
x("wind-drag",		    w_drag,	SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("wind-begin-update",	    w_b_update, WIND_FUNC,	    BeginUpdate)	\
x("wind-end-update",	    w_e_update, WIND_FUNC,	    EndUpdate)		\
x("wind-track-go-away",	    w_trk_gway, SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("wind-track-box",	    w_trk_box,	SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("set-port",		    s_port,	WIND_FUNC,	    SetPort)		\
x("get-port",		    g_port,	_WIND_FUNC2,	    GetPort)		\
x("find-wind",		    find_wind,	SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("find-wind-part",	    find_w_prt, SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("show-hide",		    show_hide,	WINDBOOL_FUNC,	    ShowHide)		\
x("wind-hilite",	    w_hilite,	WINDBOOL_FUNC,	    HiliteWindow)	\
x("bring-to-front",	    brg2frt,	WIND_FUNC,	    BringToFront)	\
x("send-behind",	    send_bhind, WIND2_FUNC,	    SendBehind)		\
x("front-wind",		    front_wind, _WIND_FUNC,	    FrontWindow)	\
x("draw-grow-icon",	    drw_gr_icn, WIND_FUNC,	    DrawGrowIcon)	\
x("wind-move",		    w_move,	WINDINT2BOOL_FUNC,  MoveWindow)		\
x("wind-size",		    w_size,	WINDINT2BOOL_FUNC,  SizeWindow)		\
x("wind-zoom",		    w_zoom,	WINDINTBOOL_FUNC,   ZoomWindow)		\


/*  ************************************************************************/


DECLARE_FUNCS(SUBRS, init_mac_wind)


/*  ************************************************************************/


SCM mac_w_drag(SCM s_args)
{
  WindowPtr w;
  Point p;
  short h;

  GET_NEXT_MACWIND(w,	s_args, ARG1, s_mac_w_drag);
  GET_NEXT_MACPT(p, s_args, ARG2, s_mac_w_drag);
  DragWindow(w, p, &((**(GetGrayRgn())).rgnBBox));

  return UNSPECIFIED;
}


SCM mac_find_wind(SCM s_args)
{
  WindowPtr pWindow;
  Point p;
  short h;

  GET_NEXT_MACPT(p, s_args, ARG1, s_mac_find_wind);
  h = FindWindow(p, &pWindow);

  if (pWindow)
    return make_macwind(pWindow);
  else
    return BOOL_F;
}


SCM mac_find_w_prt(SCM s_args)
{
  WindowPtr pWindow;
  Point p;
  short h;

  GET_NEXT_MACPT(p, s_args, ARG1, s_mac_find_w_prt);
  h = FindWindow(p, &pWindow);

  return MAKINUM(h);
}


SCM mac_w_new(SCM s_args)
{
  WindowPtr pWindow;
  Rect r;
  char *pc;
  char vis, goAway;
  SCM s;
  short proc;

  GET_NEXT_MACRECT(r,	s_args, ARG1, s_mac_w_new);
  GET_NEXT_STRING(pc,	s_args, ARG2, s_mac_w_new);
  GET_NEXT_BOOL(vis,	s_args, ARG3, s_mac_w_new);
  GET_NEXT_INT(proc,	s_args, ARG4, s_mac_w_new);
  GET_NEXT_BOOL(goAway, s_args, ARG5, s_mac_w_new);

  c2pstr (strncpy((char *) GStr255, pc, 255));
  pWindow = NewWindow (NULL, &r, &GStr255, vis, proc, (WindowPtr) -1L, goAway, 0);

  if (pWindow) {
    s = make_macwind(pWindow);
    SetWRefCon(pWindow, (long) s);
    return s;
  }
  else
    return BOOL_F;
}


SCM mac_w_trk_gway(SCM s_args)
{
  WindowPtr w;
  Point p;

  GET_NEXT_MACWIND(w, s_args, ARG1, s_mac_w_trk_gway);
  GET_NEXT_MACPT(p, s_args, ARG2, s_mac_w_trk_gway);

  return TrackGoAway(w, p) ? BOOL_T : BOOL_F;
}


SCM mac_w_trk_box(SCM s_args)
{
  WindowPtr w;
  Point p;
  short part;

  GET_NEXT_MACWIND(w, s_args, ARG1, s_mac_w_trk_box);
  GET_NEXT_MACPT(p, s_args, ARG2, s_mac_w_trk_box);
  GET_NEXT_INT(part, s_args, ARG3, s_mac_w_trk_box);

  return TrackBox(w, p, part) ? BOOL_T : BOOL_F;
}


SCM mac_w_s_ref(SCM s_args)
{
  WindowPtr w;
  SCM s;

  GET_NEXT_MACWIND(w, s_args, ARG1, s_mac_w_s_ref);
  GET_NEXT_SCM(s, s_args, ARG1, s_mac_w_s_ref);
  SetWRefCon(w, (long) s);

  return UNSPECIFIED;
}


SCM mac_w_g_ref(SCM s_args)
{
  WindowPtr w;

  GET_NEXT_MACWIND(w, s_args, ARG1, s_mac_w_g_ref);

  return (SCM) GetWRefCon(w);
}


/*  ************************************************************************/
