(define! compile-forms '(define! syntax declare-syntax alias))

(define! compile-file
    (#!lambda (file1 file2)
	(begin (load (concat scheme-directory "compfile.s"))
	       (compile-file file1 file2))))

(define-constant load-compiled-file
   (let ([interned nil])
      (#!lambda (file)
	 (#!if interned
	    (load file)
	    (begin (#!set! interned t)
		   (lisp-eval '(mapc 'intern procedure-tags))
		   (load file)
		   (lisp-eval '(mapc 'remob procedure-tags))
		   (#!set! interned nil)
		   'done)))))

(add-to-syntax-table '(edit)
   (#!lambda (l) (set-car! (cdr l) (intern* (cadr l)))
      (begin (lisp-eval '(setq $ldprint nil))
	     (load (concat scheme-directory "edit.s"))
	     (expand-once l))))
(gc)
(print "[scheme-load mkmac.s]   ; patience is needed here ...") (newline)
(pure-load (concat scheme-directory "mkmac.s"))
(gc)
(print "[scheme-load syntax.s]") (newline)
(pure-load (concat scheme-directory "syntax.s"))
(gc)
(print "[scheme-load wrapper.s]") (newline) 
(pure-load (concat scheme-directory "wrapper.s"))
(gc)
(print "[scheme-load synstd.s]")
(newline)
(pure-load (concat scheme-directory "synstd.s"))
(gc)
(print "[scheme-load debug.s]")
(newline)
(pure-load (concat scheme-directory "debug.s"))

(lisp-eval '(mapc 'remob (mapcar 'car (lookupinbase 'unprintables))))
(lisp-eval '(remob 'unassigned-constant))
(lisp-eval '(putd 'copy-no-constant (getd 'copy-no-constant*)))
(lisp-eval '(putd 'copy-no-constant-no-quote
	       (getd 'copy-no-constant-no-quote*)))
(remove-from-namespace 'define-constant)
(gc)


