; Error handler for the virtual [Scheme] machine Version 1

(declare (special *error* *error-data* *error-res*))

(def if
   (macro (l)
	  (cond ((eq (length l) 3) `(cond (,(cadr l) ,(caddr l))))
		((eq (length l) 4) `(cond (,(cadr l) ,(caddr l))
					  (t ,(cadddr l)))))))

(def scherror
    (lambda (x)
        (princ "[")
	(princ x)
	(cond
	    ((equal x "Bad vsm opcode") (princ " ") (ldisplay *error*))
	    ((equal x "Process ran out") t)
	    ((equal x "Bad function") (princ " ") (ldisplay *error-data*))
	    ((equal x "Wrong number of arguments to closure")
	     (terpri)
	     (princ "Formal parameters: ")
	     (ldisplay (cadr (cadr *error-res*)))
	     (terpri) (princ "Actual parameters: ")
	     (ldisplay *error-data*))
	    ((equal x "Wrong number of arguments to engine")
	     (terpri)
	     (princ "Formal parameters: ")
	     (ldisplay '(ticks success-function failure-function))
	     (terpri)
	     (princ "Actual parameters: ")
	     (ldisplay *error-data*))
	    ((equal x "Wrong number of arguments to state")
	     (terpri)
	     (princ "Formal parameters: ")
	     (ldisplay '())
	     (terpri)
	     (princ "Actual parameters: ")
	     (ldisplay *error-data*))
	    ((equal x "Wrong number of arguments to vector")
	     (terpri)
	     (princ "Arguments: ")
	     (ldisplay *error-data*))
	    ((equal x "Wrong number of arguments to continuation")
	     (terpri)
	     (princ "Actual parameters: ")
	     (ldisplay *error-data*))
	    ((equal x "Unassigned identifier:")
	     (princ " ")
	     (ldisplay  *error-data*))
	    ((equal x "Bad primitive class")
	     (princ "  ")
	     (princ *error*))
	    ((equal x "Bad primitive op") 
	     (princ "  ")
	     (princ *error*) t))
	(princ "]")
	(terpri)
	(lisp-debug)
	(reset)))
