; -*- Mode: Scheme; Syntax: Scheme; Package: Scheme; -*-
; File utils.scm / Copyright (c) 1991 Jonathan Rees / See file COPYING

;;;; Miscellaneous general and not-so-general utilities

; last-pair (was in r^3, flushed for r^4)

(define (last-pair x)
  (lisp:last x))

; posq

(define (vector-posq thing v)
  (lisp:or (lisp:position thing (lisp:the lisp:simple-vector v))
	   #f))

(define (string-posq c s)
  (lisp:or (lisp:position c (lisp:the lisp:simple-string s))
	   #f))

; Fluids

(define (make-fluid top-level-value)
  (let ((f (lisp:gensym "FLUID")))
    (lisp:set f top-level-value)
    f))

(define (fluid f)
  (lisp:symbol-value f))

(define (set-fluid! f val)
  (lisp:set f val))

(define (let-fluid f val thunk)
  (lisp:progv (list f) (list val) (thunk)))

; Tables

(define (make-table)
  ;; Default size in VAX LISP is 71, which seems rather large.
  (lisp:values (lisp:make-hash-table :size 20 :rehash-size 2.0)))

(define (table-set! table key val)
  (lisp:setf (lisp:gethash key table) val))

(define (table-ref table key)
  (lisp:gethash key table #f))

; Pretty-printer used by translator
; Two cases:
;  - If package is scheme-package, then unqualified symbols must print
;    without package prefixes, and qualified ones must print with.
;  - Otherwise, the opposite, and the package prefix for unqualified
;    symbols ought to be 

(define cl-readtable (lisp:copy-readtable 'lisp:nil))

(lisp:defun write-pretty (form port package)
  (lisp:let ((lisp:*package* package)
	     (lisp:*print-case* :upcase)
	     (lisp:*readtable* cl-readtable))
    (lisp:declare (lisp:special cl-readtable))
    (lisp:format port "~&")
    (lisp:write form :stream port
		     :pretty lisp:t
		     :length 'lisp:nil
		     :level 'lisp:nil)
    (lisp:values)))

; Package stuff, etc.

; These things are needed by the runtime system, too, BEFORE the
; translator can be loaded.  Maybe the code should just be replicated?

(define intern-renaming-perhaps #'scheme-hacks:intern-renaming-perhaps)

(define (qualified-symbol? sym)
  (not (eq? (scheme-hacks:qualified-symbol-p sym) 'lisp:nil)))

(define (make-package-using id use-list)
  (let* ((name (symbol->string id))
	 (probe (lisp:find-package name))
	 (package
	  (cond ((not (eq? probe 'lisp:nil))
	         (for-each (lambda (use)
			     (if (not (or (eq? use scheme-hacks::lisp-package)
					  (memq use use-list)))
				 (lisp:unuse-package use probe)))
			   (lisp:package-use-list probe))
		 probe)
		(else (lisp:make-package name :use use-list)))))
    (lisp:use-package (if (eq? id 'scheme)
			  use-list	;Kludge
			  (cons scheme-hacks:lisp-package use-list))
		      package)
    package))

(define (make-package-exporting id syms)
  (let* ((name (symbol->string id))
	 (new (lisp:or (lisp:find-package name)
		       (lisp:make-package name :use '()))))
    (lisp:import syms new)
    (lisp:export syms new)
    new))


; lisp:namestring
; lisp:truename
; lisp:merge-pathnames
; lisp:make-pathname
; lisp:package-name

; Etc.

(define make-photon #'scheme-hacks:make-photon)

(define (scheme-implementation-version)
  (string-append (lisp:lisp-implementation-type)
		 " "
		 (lisp:lisp-implementation-version)))
