; -*- Mode: Lisp; Syntax: Common-Lisp; Package: (SCHI :USE (LISP)); -*-
; File loadit.lisp / Copyright (c) 1991 Jonathan Rees / See file COPYING

;;;; Load script

; Will not run in:
;  Symbolics versions older than Rel 7.1
;  VAX LISP versions older than V2.2
;  Explorer versions older than 3.0

(lisp:in-package "SCHI"
		 :use '("LISP")
		 :nicknames '("SCHEME-INTERNAL"))

(export '(loadit))

(defvar *pseudoscheme-directory* *default-pathname-defaults*)

(defun loadit (&optional (dir *pseudoscheme-directory*))
  (setq *pseudoscheme-directory*
	(let ((dir (pathname (or dir
				 *default-pathname-defaults*))))
	  (make-pathname :name nil
			 :type nil
			 :directory (pathname-directory dir)
			 :device    (pathname-device dir)
			 :host	    (pathname-host dir))))
  (load-hacks)
  (load-runtime)
  (load-translated-translator)
  (load-reflect))

; ----- Load low-level hacks

(defvar hacks-package)

(defun load-hacks ()
  (let ((*package* (or (find-package "SCHEME-HACKS")
		       (make-package "SCHEME-HACKS"
				     :use '("LISP")
				     :nicknames '("SCHH")))))
    (setq hacks-package *package*)
    (load (pseudo-pathname "CLEVER")
	  :verbose nil)			;Get clever file loader
    ;; Don't intern the symbol CLEVER-LOAD in the wrong package!
    (funcall (hack-symbol "CLEVER-LOAD")
	     (pseudo-pathname "HACKS")
	     :compile-if-necessary t)
    ;; Create the scheme-internal package
    (funcall (hack-symbol "CLEVER-LOAD")
	     (pseudo-pathname "SCHI"))))

(defun hack-symbol (name)
  (intern name hacks-package))

(defun pseudo-pathname (name)
  (make-pathname :name (preferred-case name)
		 :defaults *pseudoscheme-directory*))

(defun preferred-case (name)
  #+unix (string-downcase name)
  #-unix name
  )

; ----- Load runtime system

(defparameter lisp-package-foo nil)

(defparameter revised^4-scheme-package nil)

(defun load-runtime ()
  (let ((package (or (find-package "SCHEME")
		     (make-package "SCHEME" :use '()))))
    (funcall (hack-symbol "FIX-SCHEME-PACKAGE-IF-NECESSARY") package)
    #+Symbolics
    (pushnew package si:*reasonable-packages*))

  (setq lisp-package-foo
	(symbol-value (intern "LISP-PACKAGE" "SCHEME-HACKS")))

  (setq revised^4-scheme-package
	(or (find-package "REVISED^4-SCHEME")
	    (make-package "REVISED^4-SCHEME" :use (list lisp-package-foo))))

  (mapc #'load-runtime-file
	'("READTABLE"
	  "CORE"			;for STRING->SYMBOL
	  ;; REP loop and related things
	  "RTS"
	  ))

  (load-translated "CLOSED" revised^4-scheme-package)
  'done)

(defvar this-package *package*)

(defun load-runtime-file (filespec)
  (let ((*package* this-package))
    (funcall (hack-symbol "CLEVER-LOAD")
      (pseudo-pathname (if (consp filespec) (car filespec) filespec))
      :compile-if-necessary (not (consp filespec)))))

(defun load-translated (file package)
  ;; PSO stands for Pseudo-Scheme Object file
  (let ((*target-package* package))	;cf. scheme-load
    (declare (special *target-package*))
    (funcall (hack-symbol "CLEVER-LOAD") (pseudo-pathname file)
	     :source-type *translated-file-type*
	     :compile-if-necessary t)))

; ----- Load translator

(defparameter scheme-translator-package nil)

(defun load-translated-translator ()
  (setq scheme-translator-package
	(or (find-package "SCHEME-TRANSLATOR")
	    (make-package "SCHEME-TRANSLATOR"
			  :use (list revised^4-scheme-package
				     lisp-package-foo))))
  (let ((*package* this-package))
    (funcall (hack-symbol "CLEVER-LOAD")
	     (pseudo-pathname "FILES")
	     #+LispM :package #+LispM this-package))
  (mapc #'(lambda (file)
	    (load-translated file scheme-translator-package))
	translator-files)
  'done)

(defun load-reflect ()
  (load-translated "REFLECT" scheme-translator-package)
  (load-runtime-file "EVAL")
  #+Lispm
  (load-runtime-file "CUSTOM"))
