; -*- Mode: Lisp; Syntax: Common-Lisp; Package: REVISED^3-SCHEME; -*-
; File rts.lisp / Copyright (c) 1989 Jonathan Rees / See file COPYING

;;;; Revised^3 Scheme runtime system

(scheme-internal:begin-translated-file)  ;Obviously not true, but let's pretend

(defmacro defune (name bvl &body body)
  (let ((new-name
	 (scheme-hacks:intern-renaming-perhaps (symbol-name name)
					       *package*)))
    `(progn #+LispM 'compile
	    (defun ,new-name ,bvl ,@body)
	    (scheme-internal:set-value-from-function ',new-name)
	    ',name)))

(when (symbolp (symbol-function 'null))	;Symbolics loses
  (setf (symbol-function 'null)
	(symbol-function (symbol-function 'null))))

; Definitions for CAR and CDR for when they are *not* open-coded.
; There really ought to be definitions for CDADDR and friends, but the
; programmer is too lazy to produce them.

(defune car (pair)
  (if (not (consp pair))
      (error "Argument to CAR isn't a pair -- ~S" pair)
      (car pair)))

(defune cdr (pair)
  (if (not (consp pair))
      (error "Argument to CDR isn't a pair -- ~S" pair)
      (cdr pair)))

; Non-open-coded standard Scheme procedures, in alphabetical order (almost)

; MAKE-PROMISE (auxiliary for DELAY macro)

(defstruct (promise (:print-function print-promise)
		    (:predicate promise?)
		    (:constructor make-promise (thunk-or-value)))
  (forced-yet? nil)
  thunk-or-value)

(defun print-promise (obj stream escape?)
  (declare (ignore escape?))
  (if (promise-forced-yet? obj)
      (format stream "#{Forced ~S}" (promise-thunk-or-value obj))
      (format stream "#{Delayed}")))

; FORCE

(defune force (obj)
  (cond ((promise? obj)
         (let ((tv (promise-thunk-or-value obj)))
           (cond ((promise-forced-yet? obj) tv)
                 (t (let ((val (funcall tv)))
                      (setf (promise-thunk-or-value obj) val)
                      (setf (promise-forced-yet? obj) t)
                      val)))))
        (t obj)))

; LOAD -- forward reference to not-yet-existing EVAL module

#+DEC (proclaim '(function scheme-internal:scheme-load))

(defune load (filespec &rest optional-args)
  (apply #'scheme-internal:scheme-load filespec optional-args))

; MAKE-STRING

(defune make-string (size &optional (fill #\?))
  (cond (fill (make-string size :initial-element fill))
        (t (make-string size))))

; MAKE-VECTOR

(defune make-vector (size &optional (fill scheme-internal:unspecified))
  (make-sequence 'vector size :initial-element fill))

; NUMBER->STRING

(defune number->string (num format)
  ;;+++ Improve later
  (if (not (equal format '(scheme::heur)))
      (cerror "act as if the format was (HEUR)"
              "unimplemented format: (NUMBER->STRING '~s '~s)"
              num format))
  (write-to-string num))

; READ

(defune read (&optional (port *standard-input*))
  (let ((*package* scheme-internal:scheme-package)
	(*readtable* scheme-internal:scheme-readtable))
    (read port nil scheme-internal:eof-object)))

; READ-CHAR

(defune read-char (&optional (port *standard-input*))
  (read-char port nil scheme-internal:eof-object))

; STRING->NUMBER

(defune string->number (string exactness radix)
  (with-input-from-string (s string)
    (let ((n (let ((*read-base*
		    (case radix
		      ((scheme::b) 2)
		      ((scheme::o) 8)
		      ((scheme::d) 10)
		      ((scheme::x) 16)
		      (otherwise 
		       (cerror "use base 10"
			       "bad radix argument to STRING->NUMBER: ~S"
			       radix)
		       10))))
	       (read s nil scheme-internal:eof-object))))
      (if (or (not (number? n))
	      (not (eq? (read s nil scheme-internal:eof-object) scheme-internal:eof-object)))
	  (error "cannot convert to a number: ~S" string)
	  (case exactness
	    ((scheme::e) (if (floatp n)
			     (rationalize n)
			     n))
	    ((scheme::i) (if (rationalp n)
			     (float n)
			     n))
	    (otherwise (cerror "assume something reasonable"
			       "bad exactness argument to STRING->NUMBER: ~S"
			       exactness)
		       n))))))

; STRING-APPEND

(defune string-append (&rest strings)
  (apply #'concatenate 'simple-string strings))

; VECTOR?

(defune vector? (obj)
  (and (simple-vector-p obj)
       ;; Structures are vectors in Symbolics, Exploder, and CLISP.
       #+(or tops-20 Lispm)
       (not (typep obj 'lisp::structure))
       ;; Strings are simple vectors in CLISP (this is a bug)
       #+tops-20
       (not (stringp obj))))

; WRITE
; Do a real printer some time.

(defune write (obj &optional (port *standard-output*))
  (let ((*package* scheme-internal:scheme-package)
	(*readtable* scheme-internal:scheme-readtable)
	(*print-array* t))   ;for #(...)
    (cond ((null obj) (princ "()" port))
	  ((eq obj t) (princ "#T" port))
	  (t (prin1 obj port)))
    scheme-internal:unspecified))

(defune display (obj &optional (port *standard-output*))
  (let ((*package* scheme-internal:scheme-package)
	(*readtable* scheme-internal:scheme-readtable)
	(*print-array* t))   ;for #(...)
    (cond ((null obj) (princ "()" port))
	  ((eq obj t) (princ "#T" port))
	  (t (princ obj port)))
    scheme-internal:unspecified))

; CASE-AUX
;  Usually this should be open-coded, but sometimes it may not be.

(defune case-aux (key key-lists else-thunk &rest clause-thunks)
  (do ((ks key-lists (cdr ks))
       (ts clause-thunks (cdr ts)))
      ((null ks) (funcall else-thunk))
    (if (member key (car ks))
	(return (funcall (car ts))))))


; Printer hooks

#+DEC
(progn
(system::define-list-print-function scheme::quote (list stream)
  (declare (list list))
  (if (two-element-list? list)
      (format stream "'~W" (second list))
      (format stream "~1!~@{~W~^ ~:_~}~." list)))

(system::define-list-print-function scheme::quasiquote (list stream)
  (declare (list list))
  (if (two-element-list? list)
      (format stream "`~W" (second list))
      (format stream "~1!~@{~W~^ ~:_~}~." list)))

(system::define-list-print-function scheme::unquote (list stream)
  (declare (list list))
  (if (two-element-list? list)
      ;;+++ Should insert a space for , @FOO
      (format stream ",~W" (second list))
      (format stream "~1!~@{~W~^ ~:_~}~." list)))

(system::define-list-print-function scheme::unquote-splicing (list stream)
  (declare (list list))
  (if (two-element-list? list)
      (format stream ",@~W" (second list))
      (format stream "~1!~@{~W~^ ~:_~}~." list)))

(defun two-element-list? (obj)
  (and (consp obj) (consp (cdr obj)) (null (cddr obj))))
);ngorp

#+Symbolics
(progn 'compile
; This stuff seems to not work!
(zl:defprop scheme::quasiquote grind-quasiquote si:grind-macro)
(defun grind-quasiquote (e loc) loc
  (si:gtyo #.(zl:character (char-code #\`)))
  (si:grind-form (cadr e) (zl:locf (cadr e))))
(zl:defprop scheme::unquote grind-unquote si:grind-macro)
(defun grind-unquote (e loc) loc
  (si:gtyo #.(zl:character (char-code #\,)))
  (si:grind-form (cadr e) (zl:locf (cadr e))))
(zl:defprop scheme::unquote-splicing grind-unquote-splicing si:grind-macro)
(defun grind-unquote-splicing (e loc) loc
  (si:gtyo #.(zl:character (char-code #\,)))
  (si:gtyo #.(zl:character (char-code #\@)))
  (si:grind-form (cadr e) (zl:locf (cadr e))))
);ngorp
