; -*- Mode: Scheme; Syntax: Scheme; Package: Scheme; -*-
; File module.scm / Copyright (c) 1989 Jonathan Rees / See file COPYING

;;;; Signatures, meta-environments, meta-structures

;+++ Unify meta-environments and global syntactic environments?  This
;+++ will only work if global variables contain no state that's
;+++ specific to this particular compilation, as the point of a
;+++ meta-environment is that it persists from one compilation to the
;+++ next, can be written to a file, etc.

;(schi::set-file-context! si:fdefine-file-pathname schi::scheme-translator-context)

; Signatures

(define signature-rtd
  (make-record-type 'signature '(id vars aux-vars)))

(define make-signature
  (record-constructor signature-rtd '(id vars aux-vars)))

(define signature-vars (record-accessor signature-rtd 'vars))
(define signature-aux-vars (record-accessor signature-rtd 'aux-vars))

; SIGNATURE-REF returns one of
;   #F       if the name is not exported
;   PUBLIC   if exported as a value
;   PRIVATE  if exported as an auxiliary value

;+++ This can be slow if SIG exports many variables (like the r^3 signature does).
; If this becomes a problem, change it so that it does a table lookup
; (after some threshold?).

(define (signature-ref sig name)
  (cond ((memq name (signature-vars sig)) 'public)
	(else #f)))

(define (signature-ref-aux sig name)
  (cond ((memq name (signature-vars sig)) 'public)
	((memq name (signature-aux-vars sig)) 'private)
	(else #f)))

; Meta-environments contain information about bindings --
; specifically, information about open-coding.

; A meta-structure is a pair <meta-environment, signature>.

(define meta-struct-rtd
  (make-record-type 'meta-struct '(id sig meta-env)))
(define make-meta-struct
  (record-constructor meta-struct-rtd '(id sig meta-env)))
(define meta-struct-id        (record-accessor meta-struct-rtd 'id))
(define meta-struct-signature (record-accessor meta-struct-rtd 'sig))
(define meta-struct-meta-env  (record-accessor meta-struct-rtd 'meta-env))

(define (meta-struct-ref meta-struct name)
  (if (eq? (signature-ref (meta-struct-signature meta-struct) name)
	   'public)
      (meta-env-ref (meta-struct-meta-env meta-struct) name)
      #f))

; A meta-environment is a pair <table, meta-struct-list>.

(define meta-env-rtd (make-record-type 'meta-env '(id table opens)))
(define meta-env-id    (record-accessor meta-env-rtd 'id))
(define meta-env-table (record-accessor meta-env-rtd 'table))
(define meta-env-opens (record-accessor meta-env-rtd 'opens))

(define make-meta-env
  (let ((create (record-constructor meta-env-rtd '(id table opens))))
    (lambda (id opened-structures)
      (create id (make-table) opened-structures))))

(define (meta-env-ref meta-env name)
  (or (table-ref (meta-env-table meta-env) name)
      (let loop ((structs (meta-env-opens meta-env)))
	(and (not (null? structs))
	     (or (meta-struct-ref (car structs) name)
		 (loop (cdr structs)))))))

(define (meta-env-set! meta-env name int)
  (table-set! (meta-env-table meta-env) name int))
