; File builtin.scm / -*- Mode: Scheme; Syntax: Scheme; Package: Scheme; -*-
; Copyright (c) 1989 Jonathan Rees / See file COPYING

;;;; Compilation of calls to built-in Scheme procedures

; This, together with RTS2.LSP, constitutes an implementation of the
; REVISED^3-SCHEME signature.

; An entry in an integrations table is a pair, one of the following:
;   (FUN foo)            - translate as #'foo or (foo ...)
;   (VAR foo)            - translate as foo or (funcall foo ...)
;   (SUBST bvl body)     - translate calls as appropriate
;   (LAMBDA bvl body)    - ditto
;   (CASE-AUX)	         - a special case kludge
;   (INTEGRATIONS m-env) - bound to an environment that has further integrations

; Revised^3 integrations

(define revised^3-scheme-integrations
  (make-meta-env 'revised^3-scheme-integrations '()))

(meta-env-set! revised^3-scheme-integrations
	       'revised^3-scheme
	       `(integrations ,revised^3-scheme-integrations))

(define revised^3-scheme-meta-struct
  (make-meta-struct 'revised^3-scheme
		    revised^3-scheme-sig
		    revised^3-scheme-integrations))

; Almost no integrations

(define almost-no-integrations
  (make-meta-env 'almost-no-integrations '()))

(meta-env-set! almost-no-integrations
	       'revised^3-scheme
	       `(integrations ,revised^3-scheme-integrations))

; Usual

(define usual-integrations
  (make-meta-env 'usual-integrations (list revised^3-scheme-meta-struct)))

(meta-env-set! usual-integrations
	       'revised^3-scheme
	       `(integrations ,revised^3-scheme-integrations))

(define usual-macrologies
  `((,revised^3-scheme-macrology revised^3-scheme)))

; Revised^3 integrations, really

(for-each (lambda (z)
	    (meta-env-set! revised^3-scheme-integrations
			   (car z)
			   (cadr z)))
    '(
      (*                              (fun lisp:*))
      (+                              (fun lisp:+))
      (-                              (fun lisp:-))
      (/                              (fun lisp:/))
      (<=                             (fun lisp:<=))
      (<                              (fun lisp:<))
      (=                              (fun lisp:=))
      (>=                             (fun lisp:>=))
      (>                              (fun lisp:>))
      (abs                            (fun lisp:abs))
      (acos                           (fun lisp:acos))
      (angle                          (fun lisp:phase))
      (append                         (fun lisp:append))
      (apply                          (fun lisp:apply))
      (asin                           (fun lisp:asin))
      (assoc (subst (obj list)
	       (lisp:assoc obj list :test (lisp:function schi:equal?))))
      (assq (subst (obj list)
	      (lisp:assoc obj list :test (lisp:function lisp:eq))))
      (assv                           (fun lisp:assoc))
      (atan                           (fun lisp:atan))
      (boolean? (lambda (obj)
		  (lisp:or (lisp:eq obj lisp:t)
			   (lisp:eq obj lisp:nil))))
      (caaaar                         (fun lisp:caaaar))
      (caaadr                         (fun lisp:caaadr))
      (caaar                          (fun lisp:caaar))
      (caadar                         (fun lisp:caadar))
      (caaddr                         (fun lisp:caaddr))
      (caadr                          (fun lisp:caadr))
      (caar                           (fun lisp:caar))
      (cadaar                         (fun lisp:cadaar))
      (cadadr                         (fun lisp:cadadr))
      (cadar                          (fun lisp:cadar))
      (caddar                         (fun lisp:caddar))
      (cadddr                         (fun lisp:cadddr))
      (caddr                          (fun lisp:caddr))
      (cadr                           (fun lisp:cadr))
      (call-with-current-continuation
	  (subst (proc)
	    (lisp:block continuation
	      (lisp:funcall proc
		  (lisp:function (lisp:lambda (val)
				   (lisp:return-from continuation val)))))))
      (call-with-input-file
	  (lambda (string proc)
	    (lisp:with-open-file (port (lisp:merge-pathnames string) :direction :input)
	      (lisp:funcall proc port))))
      (call-with-output-file
	  (lambda (string proc)
	    (lisp:with-open-file (port (lisp:merge-pathnames string)
				       :direction :output
				       :if-exists :new-version)
	      (lisp:funcall proc port))))
      (car                            (fun lisp:car))
      (cdaaar                         (fun lisp:cdaaar))
      (cdaadr                         (fun lisp:cdaadr))
      (cdaar                          (fun lisp:cdaar))
      (cdadar                         (fun lisp:cdadar))
      (cdaddr                         (fun lisp:cdaddr))
      (cdadr                          (fun lisp:cdadr))
      (cdar                           (fun lisp:cdar))
      (cddaar                         (fun lisp:cddaar))
      (cddadr                         (fun lisp:cddadr))
      (cddar                          (fun lisp:cddar))
      (cdddar                         (fun lisp:cdddar))
      (cddddr                         (fun lisp:cddddr))
      (cdddr                          (fun lisp:cdddr))
      (cddr                           (fun lisp:cddr))
      (cdr                            (fun lisp:cdr))
      (ceiling                        (fun lisp:ceiling))
      (char->integer                  (fun lisp:char-code))
      (char-alphabetic?               (fun lisp:alpha-char-p))
      (char-ci<=?                     (fun lisp:char-not-greaterp))
      (char-ci<?                      (fun lisp:char-lessp))
      (char-ci=?                      (fun lisp:char-equal))
      (char-ci>=?                     (fun lisp:char-not-lessp))
      (char-ci>?                      (fun lisp:char-greaterp))
      (char-downcase                  (fun lisp:char-downcase))
      (char-lower-case?               (fun lisp:lower-case-p))
      (char-numeric?                  (fun lisp:digit-char-p))
      (char-ready?		      (fun lisp:listen))
      (char-upcase                    (fun lisp:char-upcase))
      (char-upper-case?               (fun lisp:upper-case-p))
      (char-whitespace?
       (lambda (char)
	 (lisp:or (lisp:char= char #\space)
		  (lisp:not (lisp:graphic-char-p char)))))
      (char<=?                        (fun lisp:char<=))
      (char<?                         (fun lisp:char<))
      (char=?                         (fun lisp:char=))
      (char>=?                        (fun lisp:char>=))
      (char>?                         (fun lisp:char>))
      (char?                          (fun lisp:characterp))
      (close-input-port               (fun lisp:close))
      (close-output-port              (fun lisp:close))
      (complex?                       (fun lisp:numberp))
      (cons                           (fun lisp:cons))
      (cos                            (fun lisp:cos))
      (current-input-port
       (subst () lisp:*standard-input*))
      (current-output-port
       (subst () lisp:*standard-output*))
      (denominator                    (fun lisp:denominator))
      (eof-object?
       (subst (obj)
	 (lisp:eq obj schi:eof-object)))
      (eq?                            (fun lisp:eq))
      (equal?			      (fun schi:equal?))
      (eqv?                           (fun lisp:eql))
      (even?                          (fun lisp:evenp))
      (exact?                         (fun lisp:rationalp))
      (exact->inexact                 (fun lisp:float))
      (expt                           (fun lisp:expt))
      (exp                            (fun lisp:exp))
      (floor                          (fun lisp:floor))
      (for-each                       (fun lisp:mapc))
      (gcd                            (fun lisp:gcd))
      (imag-part                      (fun lisp:imagpart))
      (inexact?                       (fun lisp:floatp))
      (inexact->exact                 (fun lisp:rationalize))
      (input-port?
       (lambda (obj)
	 (lisp:and (lisp:streamp obj) (lisp:input-stream-p obj))))
      (integer->char                  (fun lisp:code-char))
      (integer?                       (fun lisp:integerp))
      (last-pair                      (fun lisp:last))
      (lcm                            (fun lisp:lcm))
      (length                         (fun lisp:length))
      (list                           (fun lisp:list))
      (list->string
       (subst (l) (lisp:coerce (lisp:the lisp:list l)
			       (lisp:quote lisp:simple-string))))
      (list->vector
       (subst (l) (lisp:coerce (lisp:the lisp:list l)
			       (lisp:quote lisp:simple-vector))))
      (list-ref
       (subst (list n) (lisp:nth n list)))
      (list-tail
       (subst (list n) (lisp:nthcdr n list)))
      (log                            (fun lisp:log))
      (magnitude                      (fun lisp:abs))
      (make-polar
       (subst (r th) (lisp:* r (lisp:cis th))))
      (make-rectangular               (fun lisp:complex))
      (map                            (fun lisp:mapcar))
      (max                            (fun lisp:max))
      (member
       (subst (obj list)
	 (lisp:member obj list :test (lisp:function schi:equal?))))
      (memq
       (subst (obj list)
	 (lisp:member obj list :test (lisp:function lisp:eq))))
      (memv                           (fun lisp:member))
      (min                            (fun lisp:min))
      (modulo                         (fun lisp:mod))
      (negative?                      (fun lisp:minusp))
      (newline                        (fun lisp:terpri))
      (nil			      (val lisp:nil))
      (not                            (fun lisp:not))
      (null?                          (fun lisp:null))
      (number?                        (fun lisp:numberp))
      (numerator                      (fun lisp:numerator))
      (odd?                           (fun lisp:oddp))
      (open-input-file
       (subst (string)
	 (lisp:open (lisp:merge-pathnames string) :direction :input)))
      (open-output-file
       (subst (string)
	 (lisp:open (lisp:merge-pathnames string) :direction :output)))
      (output-port?
       (lambda (obj)
	 (lisp:and (lisp:streamp obj) (lisp:output-stream-p obj))))
      ;; This isn't quite right; PAIR? wants to return false for
      ;; procedures.  (Some Common Lisps implement some functions as
      ;; pairs.)  But the runtime overhead of this check would be
      ;; prohibitively high.
      (pair?                          (fun lisp:consp))
      (positive?                      (fun lisp:plusp))
      (procedure?		      (fun schi:procedure?))
      (quotient
       (subst (n1 n2)
	 (lisp:values (lisp:truncate n1 n2))))
      (rational?                      (fun lisp:rationalp))
      (rationalize                    (fun lisp:rationalize))
      (real?
       (lambda (obj)
	 (lisp:and (lisp:numberp obj) (lisp:not (lisp:complexp obj)))))
      (real-part                      (fun lisp:realpart))
      (remainder                      (fun lisp:rem))
      (reverse                        (fun lisp:reverse))
      (round                          (fun lisp:round))
      (set-car!
       (subst (pair obj)
	 (lisp:setf (lisp:car pair) obj)
	 schi:unspecified))
      (set-cdr!
       (subst (pair obj)
	 (lisp:setf (lisp:cdr pair) obj)
	 schi:unspecified))
      (sin                            (fun lisp:sin))
      (sqrt                           (fun lisp:sqrt))
      (string->list
       (subst (string)
	 (lisp:coerce (lisp:the lisp:simple-string string)
		      (lisp:quote lisp:list))))
      (string->symbol
       (subst (string)
	 (lisp:values (lisp:intern string schi:scheme-package))))
      (string-ci<=?                   (fun lisp:string-not-greaterp))
      (string-ci<?                    (fun lisp:string-lessp))
      (string-ci=?                    (fun lisp:string-equal))
      (string-ci>=?                   (fun lisp:string-not-lessp))
      (string-ci>?                    (fun lisp:string-greaterp))
      (string-copy                    (fun lisp:copy-seq))
      (string-fill!
       (subst (s val)
	 (lisp:fill (lisp:the lisp:simple-string s) val)))
      (string-length
       (subst (s)
         (lisp:length (lisp:the lisp:simple-string s))))
      (string-ref
       (subst (s k)
	 (lisp:char (lisp:the lisp:simple-string s) k)))
      (string-set!
       (subst (s k obj)
	 (lisp:setf (lisp:char (lisp:the lisp:simple-string s) k) obj)
	 schi:unspecified))
      (string<=?                      (fun lisp:string<=))
      (string<?                       (fun lisp:string<))
      (string=?                       (fun lisp:string=))
      (string>=?                      (fun lisp:string>=))
      (string>?                       (fun lisp:string>))
      (string?                        (fun lisp:simple-string-p))
      (substring                      (fun lisp:subseq))
      ;;+++ SYMBOL->STRING should barf when passed ().
      (symbol->string                 (fun lisp:symbol-name))
      (symbol?
       (lambda (obj)
	 (lisp:and obj (lisp:symbolp obj) (lisp:not (lisp:eq obj lisp:t)))))
      (t                              (val lisp:t))
      (tan                            (fun lisp:tan))
      (transcript-off
       (subst ()
         (lisp:dribble)
	 schi:unspecified))
      (transcript-on
       (subst (filespec)
         (lisp:dribble filespec)
	 schi:unspecified))
      (truncate                       (fun lisp:truncate))
      (vector                         (fun lisp:vector))
      (vector->list
       (subst (vec)
	 (lisp:coerce (lisp:the lisp:simple-vector vec)
		      (lisp:quote lisp:list))))
      (vector-fill!
       (subst (vec val)
	 (lisp:fill (lisp:the lisp:simple-vector vec) val)))
      (vector-length
       (subst (vec)
         (lisp:length (lisp:the lisp:simple-vector vec))))
      (vector-ref                     (fun lisp:svref))
      (vector-set!
       (subst (vec k obj)
	 (lisp:setf (lisp:svref vec k) obj)
	 schi:unspecified))
      (with-input-from-file
       (subst (string thunk)
      	 (lisp:with-open-file (lisp:*standard-input* (lisp:merge-pathnames string)
						     :direction :input)
	   (lisp:funcall thunk))))
      (with-output-to-file
       (subst (string thunk)
	 (lisp:with-open-file (lisp:*standard-output* (lisp:merge-pathnames string)
						      :direction :output
						      :if-exists :new-version)
	    (lisp:funcall thunk))))
      (write-char                     (fun lisp:write-char))
      (zero?                          (fun lisp:zerop))

      ;; Auxiliaries
      (and-aux
       (subst (val thunk)
	 (lisp:and val (lisp:funcall thunk))))
      (case-aux (case-aux))		;Yow!
      (or-aux
       (subst (val thunk)
	 (lisp:or val (lisp:funcall thunk))))
      (unassigned (subst () schi:unassigned))
      (unspecified (val schi:unspecified))
      (=>-aux
       (subst (val proc-thunk else-thunk)
	 (lisp:if val
		   (lisp:funcall (lisp:funcall proc-thunk) val)
		   (lisp:funcall else-thunk))))
      ))
