;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;     MODULE: STEPAUX
;;;
;;;     Purpose:        This Module defines all procedures,
;;;                     which are neccessary to code generated
;;;                     by the `step' macro.
;;;
;;;	Installation:	See "autostep.sc".
;;;
;;;     Notes:          All the procedures of this module should be
;;;			bound in the `user-global-environment'.
;;;                     
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Is `true' when `step' is in `leap-mode'.
;;; See "step.doc" for discussion of the `leap-mode'.
(define step-leap-mode #F)

;;; Holds the depth of prodcedure and special form
;;; executions.
(define step-call-depth 0)

;;; Holds the depth, when `step' stops execution, when
;;; it is in `go-mode'.
;;; If `step' is not in `go-mode' this variable 
;;; is set to `-1'.
(define step-stop-depth -1)

;;; Increments the variable `step-call-depth'.
(define (increment-call-depth)
  (set! step-call-depth
	(add1 step-call-depth)))

;;; Decrements the variable `step-call-depth'.
(define (decrement-call-depth)
  (set! step-call-depth
	(sub1 step-call-depth)))

;;; This procedure is called from the code beeing
;;; stepped in order to stop after displaying
;;; some pieces of information.
;;; Its only argument is the environment of
;;; the procedure or expression beeing stepped.
(define (stop-step env)
  (if (< step-call-depth 0)
      (set! step-call-depth 0))
  (if (and (> step-stop-depth -1)               ; Are we in `go-mode'?
	   (>= step-call-depth step-stop-depth))
      (begin                                    ; Yes; display prompt
	(display "[Step ")
	(display step-call-depth)
	(display "] ")
	(if (char-ready?)                       ; Is there input
	    (begin                              ; Yes...
	      (set! step-stop-depth -1)         ; Leave `go-mode'!
	      (flush-input)
	      (display "Halted")
	      (newline)
	      (stop-step env))
	    (display "Going")))                 ; No; display "Going".
      ((named-lambda (loop)
	 (set! step-stop-depth -1)              ; Leave `go-mode'!
	 (display "[Step ")                     ; Display prompt.
	 (display step-call-depth)
	 (display "] ")
	 (case (integer->char (+ (char->integer (read-char)) 64))
	   (#\Q (display "Quit")
		(set! step-call-depth 0)
		(reset))
	   (#\R (display "Reset")
		(set! step-call-depth 0)
		(loop))
	   (#\M (display "Step"))
	   (#\I (display "Inspect")
		(inspect env)
		(loop))
	   (#\G (display "Go (Press any key to stop)")
		(set! step-stop-depth step-call-depth))
	   (#\L (display "switch mode to: ")
		(display "Leap mode")
		(newline)
		(set! step-leap-mode #T)
		(loop))
	   (#\C (display "switch mode to: ")
		(display "Creap mode")
		(newline)
		(set! step-leap-mode #F)
		(loop))
	   (#\T (display "toggle mode to: ")
		(if step-leap-mode
		    (display "Creap mode")
		    (display "Leap mode"))
		(newline)
		(set! step-leap-mode
		      (not step-leap-mode))
		(loop))
	   (#\S (display "show mode: ")
		(if step-leap-mode
		    (display "Leap mode")
		    (display "Creap mode"))
		(newline)
		(loop))
	   (#\rubout    ; #\? + 64 == #\rubout
	     (display #\?)
	     (newline)
	     (display "   ?    -- display this command summary")
	     (newline)
	     (display " ctrl-Q -- Quit")
	     (newline)
	     (display " ctrl-R -- Reset the level counter to zero")
	     (newline)
	     (display " ctrl-M -- Step")
	     (newline)
	     (display " ctrl-G -- Go through deeper levels without stopping")
	     (newline)
	     (display " ctrl-I -- Inspect the environment")
	     (newline)
	     (display " ctrl-L -- switch to Leap mode")
	     (newline)
	     (display " ctrl-C -- switch to Creap mode")
	     (newline)
	     (display " ctrl-T -- Toggle mode")
	     (newline)
	     (display " ctrl-S -- Show mode")
	     (newline)
	     (display "To enter `ctrl-Q', press both `CTRL' and `Q'.")
	     (newline)
	     (newline)
	     (loop))
	   (else (display "  ?  Invalid response...  Type `?' for help")
		 (newline)
		 (loop))))))
  (newline))


;;; Removes every variable and every procedure 
;;; related to `step' form the system.
;;; It is implementation dependent.
;;; It is neccessary, that "stepaux.*" is loaed into the
;;; `user-global-environmenmt'.
(define (remove-step)
  (unbind 'step-environment user-global-environment)
  (unbind 'step-leap-mode user-global-environment)
  (unbind 'step-call-depth user-global-environment)
  (unbind 'step-stop-depth user-global-environment)
  (unbind 'increment-call-depth user-global-environment)
  (unbind 'decrement-call-depth user-global-environment)
  (unbind 'stop-step user-global-environment)
  (unbind 'remove-step user-global-environment)
  *the-non-printing-object*)
