;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;     MODULE: STEP
;;;
;;;     Purpose:        This Module defines the step-macro.
;;;
;;;     Installation:	Load "step.*" in your "scheme.ini" or
;;;			copy it to your "scheme.ini". A macro can
;;;			not be loaded automaticly.
;;;
;;;	Notes:		The single stepper is invoked by 
;;;                     placing the expression to step
;;;                     inside a 'call' to step: 
;;;                             "(step <expression> [halt] [reset]")
;;;
;;;                     Currently `step' accepts two options, 
;;;                     namely `halt' and `reset'. 
;;;
;;;                     `halt' halts execution immediately after
;;;                     evaluating the step expression. This is usefull
;;;                     if the stepper was in "go-mode", when `reset'
;;;                     was called.
;;;             
;;;                     `reset' resets all variables to a known state.
;;;                     See option `halt' for purpose.
;;;
;;;     Bugs:           See "stepwrap.sc"
;;;                     
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(macro step
  (lambda (expr)
    (let ((arg (cadr expr)))
      (if (or (procedure? arg)
              (environment? arg)
              ;((port? arg)) `port?' seems to be buggy
          )
          (syntax-error "can't step expression" arg))
      (for-each
        (lambda (arg)
          (case arg
            (halt
              ; If "stepaux.fsl" is not loaded, do nothing
              (if (not
                    (and (unbound? step-stop-depth user-global-environment)
                         (unbound? step-stop-depth user-initial-environment)))
                  (set! step-stop-depth -1)))
            (reset
              ; If "stepaux.fsl" is not loaded, do nothing
              (if (not 
                    (and (unbound? step-stop-depth user-global-environment)
                         (unbound? step-stop-depth user-initial-environment)))
                  (set! step-call-depth  0)))
            (else
              (syntax-error "invalid option to step" arg))))
        (cddr expr))
      ; `(access wrap step-environment)' makes it impossible to 
      ; autoload "step.fsl"
      (let ((wrap (eval 'wrap step-environment)))
        (wrap (cadr expr))))))
