;* TYPES.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*			Scoops: Type Definitions			*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: Amitabh Srivastava		Date: 1986		*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

;    ------ (lambda bvl body . (nargs label . closed)) ------

(begin
  (syntax (lambda-bvl x)     (car (cdr x)))
  (syntax (lambda-body x)    (car (cddr x)))
  (syntax (lambda-body-list x)    (cddr x))
  (syntax (lambda-nargs x)   (car (cdddr x)))
  (syntax (lambda-label x)   (car (cdr (cdddr x))))
  (syntax (lambda-debug x)   (car (cddr (cdddr x))))
  (syntax (lambda-closed? x) (car (cdddr (cdddr x))))

  (syntax (set-lambda-body x val)    (set-car! (cddr x)          val))
  (syntax (set-lambda-nargs x val)   (set-car! (cdddr x)         val))
  (syntax (set-lambda-label x val)   (set-car! (cdr (cdddr x))   val))
  (syntax (set-lambda-debug x val)   (set-car! (cddr (cdddr x))  val))
  (syntax (set-lambda-closed? x val) (set-car! (cdddr (cdddr x)) val))

  (macro pcs-extend-lambda
    (lambda (form)
      `(let  ((x ,(cadr form)))
         (set-cdr! (cdddr x)     ; X = ('lambda bvl body nargs)
                   (list '()     ; label
                         '()     ; debug info
                         '()))   ; closed?
         x)))
  )

;                  ------ (letrec pairs body) ------

(begin
  (syntax (letrec-pairs x)    (car (cdr x)))
  (syntax (letrec-body x)     (car (cddr x)))
  (syntax (letrec-body-list x)     (cddr x))

  (syntax (set-letrec-body x val)     (set-car! (cddr x) val))
  )

;                     ------ (set! id exp) ------

(begin
  (syntax (set!-id x)      (car (cdr x)))
  (syntax (set!-exp x)     (car (cddr x)))

  (syntax (set-set!-id x val)     (set-car! (cdr x)  val))
  (syntax (set-set!-exp x val)    (set-car! (cddr x) val))
  )

