; MOUSE.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Microsoft-Compatible Mouse Interface			*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: L. Bartholdi		Date: 19930929			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
(if (unbound? mouse)
(set! (access mouse user-global-environment)
  (let* ((mask->buttons
	   (lambda (word)
	     (apply append
		    (list (if (= 0 (bitwise-and word 1)) '() '(LEFT))
			  (if (= 0 (bitwise-and word 2)) '() '(RIGHT))
			  (if (= 0 (bitwise-and word 4)) '() '(CENTER))))))
	 (pair!
	   (lambda (p)
	     (if (and (pair? p)
		      (char? (car p)))
		 (- (remainder (+ #x8000
				  (* #x100 (fixnum! (cdr p)))
				  (char->integer (car p)))
			       #x10000)
		    #x8000)
		 (error "Mouse error: (char . short) expected" p))))
	 (bitmap!
	   (lambda (l)
	     (if (and (list? l)
		      (eq? (length l) #x10))
		 (apply string-append
			(map (lambda (x) (list->string
					   (list (integer->char (remainder x #x100))
						 (integer->char (quotient x #x100)))))
			     l))
		 (error "Mouse error: #x10-element list expected" l))))
	 (button!
	   (lambda (b)
	     (let ((num (assq b '((LEFT . 0)
				  (RIGHT . 1)
				  (CENTER . 2)))))
	       (if num
		   (cdr num)
		   (error "Mouse error: 'LEFT, 'RIGHT or 'CENTER expected" b)))))
	 (match!
	   (lambda (predicate x)
	     (if (predicate x) x (error "Mouse error: predicate failed" (list predicate x)))))
	 (fixnum!
	   (lambda (x)
	     (if (and (integer? x) (>= x (- #x8000)) (< x #x8000))
		 x
		 (error "Mouse error: short expected" x))))
	 (mouse-error
	   (lambda (s)
	     (error "Scheme-Mouse error" s)))
	 (event-list '((MOVE .		#x0001)
		       (LEFT-DOWN .	#x0002)
		       (LEFT-UP .	#x0004)
		       (LEFT .		#x0006)
		       (RIGHT-DOWN .	#x0008)
		       (RIGHT-UP .	#x0010)
		       (RIGHT .		#x0018)
		       (CENTER-DOWN .	#x0120)
		       (CENTER-UP .	#x0240)
		       (CENTER .	#x0360)
		       (DOWN .		#x002a)
		       (UP .		#x0054)
		       (BUTTONS .	#x007e)))
	 (event!
	   (lambda (e)
	     (let ((v (assq e event-list)))
	       (if v (cdr v) (error "Mouse error: unknown event" e)))))
	 (mask->events
	   (lambda (word)
	     (apply append (map	(lambda (x)
				  (if (<> (bitwise-and word (cdr x)) 0)
				      (list (car x))
				      ()))
				event-list))
	   ))

	 (mouse-handler
	   (lambda l
	     (error "Mouse error: null mouse handler called" l)))
	 (sleeping #T)
	 (mouse-queue '())
	 (version (lambda (word)
		    (+ (quotient word #x100)
		       (/ (bitwise-and word #xf0) 160.0)
		       (/ (bitwise-and word #x0f) 100.0))))
	 (query '())
	 (jobs `((ENABLE . ,(lambda ()
			      (set! sleeping #T)	; so we can wake up
			      (mouse 'TRIGGER '())	; and really wake up
			    ))
		 (DISABLE . ,(lambda ()
			       (set! sleeping #F)))	; cut everything off
				; they'll have to be re-enabled manually
		 (TRIGGER . ,(lambda (new-events)
			       (set! mouse-queue (append! new-events mouse-queue))
			       (when sleeping
				 (set! sleeping #F)
				 (let loop ((last (car (last-pair mouse-queue))))
				   (when (and mouse-queue (not sleeping))
				     (set! mouse-queue (delete! last mouse-queue))
				     (apply mouse-handler (list* (mask->events (car last))
								 (mask->buttons (cadr last))
								 (cddr last)))
				     (loop (car (last-pair mouse-queue)))))
				 (set! sleeping #T))))
		 (CURSOR . ,(lambda (name)
			      (set! query (match! symbol? name))
			      (fast-load (%system-file-name "MOUSE.FSL"))
			      (begin0
				(if (null? query)
				    (%error-invalid-operand 'mouse name)
				    (cdr query))
				(set! query '()))))
		 (SMOOTH . ,(lambda (message . args)
			      (case message
				(CHECK (let ((result (%mouse #x3000)))
					 (if (= (car result) -1)
					     (version (cadr result))
					     #F)))
				(ENABLE (if (= (car (%mouse #x3001)) 1)
					    *the-non-printing-object*
					    'FAILED))
				(DISABLE (if (= (car (%mouse #x3002)) 1)
					    'FAILED
					    *the-non-printing-object*)))))
		 (RESET . ,(lambda ()
			     (%mouse -1 1)		; set use flag
			     (set! sleeping #T)		; so we're ready to wake up
			     (set! mouse-queue '())
			     (let ((result (%mouse 0)))
			       (if (= (car result) -1)
				   (cadr result)
				   #F))))
		 (SHOW . ,(lambda ()
			    (%mouse 1)
			    *the-non-printing-object*))
		 (HIDE . ,(lambda ()
			    (%mouse 2)
			    *the-non-printing-object*))
		 (INQ . ,(lambda ()
			   (let ((result (%mouse 3)))
			     (cons (mask->buttons (cadr result))
				   (cddr result)))))
		 (MOVE . ,(lambda (x y)
			    (%mouse 4 0 (fixnum! x) (fixnum! y))
			    *the-non-printing-object*))
		 (PRESS . ,(lambda (button)
			     (let ((result (%mouse 5 (button! button))))
			       (cons (mask->buttons (car result))
				     (cdr result)))))
		 (RELEASE . ,(lambda (button)
			       (let ((result (%mouse 6 (button! button))))
				 (cons (mask->buttons (car result))
				       (cdr result)))))
		 (LIMITS . ,(lambda (direction low high . rest)
			      (fixnum! low)
			      (fixnum! high)
			      (case direction
				(HORIZONTAL (match! null? rest) (%mouse 7 0 low high))
				(VERTICAL (match! null? rest) (%mouse 8 0 low high))
				(BOTH (match! null? (cddr rest))
				      (%mouse 7 0 low high)
				      (%mouse 8 0 (fixnum! (car rest)) (fixnum! (cadr rest))))
				(else (%error-invalid-operand 'mouse direction)))
			      *the-non-printing-object*))
		 (SHAPE . ,(lambda (l)		; (hot-x hot-y and-buffer xor-buffer)
			     (if (symbol? l)
				 (mouse 'SHAPE (mouse 'CURSOR l))
				 (begin
				   (match! null? (cddddr l))
				   (%mouse 9 (fixnum! (car l)) (fixnum! (cadr l)) 0 0 0
					   (string-append (bitmap! (caddr l))
							  (bitmap! (cadddr l))))))
			     *the-non-printing-object*))
		 (TEXT-TYPE . ,(lambda (type and-mask xor-mask)
				 (case type
				   (SOFTWARE (%mouse 10 0 (pair! and-mask) (pair! xor-mask)))
				   (HARDWARE (%mouse 10 1 (fixnum! and-mask) (fixnum! xor-mask)))
				   (else (%error-invalid-operand 'mouse type)))
				 *the-non-printing-object*))
		 (MICKEYS . ,(lambda ()
			       (cddr (%mouse 11))))
		 (HANDLER . ,(lambda (l)
			       (let ((old-proc mouse-handler)
				     (result (%mouse 20 0 (apply bitwise-or (map event! (car l))) 0 0 0 '())))
				 (set! mouse-handler (match! closure? (cdr l)))
				 (cons (mask->events (caddr result))
				       old-proc))))
		 (PEN-ON . ,(lambda ()
			      (%mouse 13)
			      *the-non-printing-object*))
		 (PEN-OFF . ,(lambda ()
			       (%mouse 14)
			       *the-non-printing-object*))
		 (MICKEY-RATIO . ,(lambda (x y)
				    (%mouse 15 0 (fixnum! x) (fixnum! y))
				    *the-non-printing-object*))
		 (EXCLUDE . ,(lambda (x0 x1 y0 y1)
			       (%mouse 16 0 (fixnum! x0) (fixnum! y0) (fixnum! x1) (fixnum! y1))
			       *the-non-printing-object*))
		 (SPEED-THRESHOLD . ,(lambda (speed)
				       (%mouse 19 0 0 (fixnum! speed))
				       *the-non-printing-object*))
		 (SENSITIVITY . ,(lambda l
				   (if (= (length l) 3)
				       (%mouse 26 (fixnum! (car l)) (fixnum! (cadr l)) (fixnum! (caddr l))))
				   (cdr (%mouse 27))))
		 (INTERRUPT-RATE . ,(lambda (rate)
				      (let ((word (assq rate '((NONE . 0)
							       (30 . 1)
							       (50 . 2)
							       (100 . 3)
							       (200 . 4)))))
					(if word
					    (%mouse 28 (cdr word))
					    (%error-invalid-operand 'mouse rate))
					*the-non-printing-object*)))
		 (POINTER-PAGE . ,(lambda l
				    (if (= (length l) 1)
					(%mouse 29 (fixnum! (car l))))
				    (cadr (%mouse 30))))
		 (LANGUAGE . ,(let ((languages '((ENGLISH . 0)
						 (FRENCH . 1)
						 (DUTCH . 2)
						 (GERMAN . 3)
						 (SWEDISH . 4)
						 (FINNISH . 5)
						 (SPANISH . 6)
						 (PORTUGESE . 7)
						 (ITALIAN . 8))))
				(lambda l
				  (if (= (length l) 1)
				      (let ((language (assq (car l) languages)))
					(if language
					    (%mouse 34 (cdr language))
					    (%error-invalid-operand 'mouse language (car l)))))
				  (car (assq (%mouse 35) (map (lambda (l) (cons (cdr l) (car l)))
							      languages))))))
		 (INFORMATION . ,(lambda ()
				   (let ((result (%mouse 36)))
				     (list (version (cadr result))
					   (vector-ref #(() BUS SERIAL INPORT PS/2 HP)
						       (quotient (caddr result) #x100))
					   (remainder (caddr result) #x100)))))
		)					; job-list
	 )						; jobs
	 (query '())
	)						; locals
    (lambda args
      (let ((task (assq (car args) jobs)))
	(if task
	    (apply (cdr task) (cdr args))
	    (%error-invalid-operand 'mouse (car args)))))))
)

(let ((symbol (access query (procedure-environment mouse)))
      (cursors '(

; the following are from the X Windows shared libraries
; (openwin/share/lib/include/bitmaps)
; reproduced without permission (lb).

(CENTER . (7 0
  (#xfc3f #xfc3f #xf81f #xf81f #xf00f #xf00f #xe007 #xe007 #xc003 #xc003 #xc003 #xc423 #xfc3f #xfc3f #xfc3f #xfc3f)
  (#x0000 #x0180 #x0180 #x03c0 #x03c0 #x07e0 #x07e0 #x0ff0 #x0ff0 #x1998 #x1188 #x0180 #x0180 #x0180 #x0180 #x0000)))
(KEYBOARD . (7 7
  (#xffff #xffff #xf00f #xeff7 #xeff7 #xeff7 #xeff7 #xf00f #xffff #xffff #xf00f #xeaa7 #xd553 #xc003 #xffff #xffff)
  (#x0000 #x0000 #x0ff0 #x1008 #x1008 #x1008 #x1008 #x0ff0 #x0000 #x0000 #x0ff0 #x1558 #x2aac #x3ffc #x0000 #x0000)))
(LEFT . (2 0
  (#xcfff #xc7ff #xc3ff #xc1ff #xc0ff #xc07f #xc03f #xc01f #xc00f #xc00f #xc07f #xc43f #xcc3f #xfe1f #xfe1f #xff3f)
  (#x0000 #x1000 #x1800 #x1c00 #x1e00 #x1f00 #x1f80 #x1fc0 #x1fe0 #x1f00 #x1b00 #x1180 #x0180 #x00c0 #x00c0 #x0000)))
(RIGHT . (13 0
  (#xfff3 #xffe3 #xffc3 #xff83 #xff03 #xfe03 #xfc03 #xf803 #xf003 #xf003 #xfe03 #xfc23 #xfc33 #xf87f #xf87f #xfcff)
  (#x0000 #x0008 #x0018 #x0038 #x0078 #x00f8 #x01f8 #x03f8 #x07f8 #x00f8 #x00d8 #x0188 #x0180 #x0300 #x0300 #x0000)))
(STAR6 . (7 7
  (#xfc7f #xfc7f #xc447 #xc007 #xc007 #xe00f #x0001 #x0001 #x0001 #xe00f #xc007 #xc007 #xc447 #xfc7f #xfc7f #xffff)
  (#x0000 #x0100 #x0100 #x1110 #x0920 #x0540 #x0280 #x7c7c #x0280 #x0540 #x0920 #x1110 #x0100 #x0100 #x0000 #x0000)))
(TARGET . (7 7
  (#xffff #xfe7f #xfe7f #xf81f #xf66f #xee77 #xec37 #x8181 #x8181 #xec37 #xee77 #xf66f #xf81f #xfe7f #xfe7f #xffff)
  (#x0000 #x0180 #x0180 #x07e0 #x0990 #x1188 #x13c8 #x7e7e #x7e7e #x13c8 #x1188 #x0990 #x07e0 #x0180 #x0180 #x0000)))

; the following are from a package called `PP111.ZIP', so-called Precise-Point.
; they are also reproduced without permission.
(ARROW . (0 0
  (#xbfff #x1fff #x0fff #x07ff #x03ff #x01ff #x00ff #x01ff #x03ff #xb1ff #xf1ff #xf8ff #xfdff #xffff #xffff #xffff)
  (#x0000 #x4000 #x6000 #x5000 #x6800 #x5400 #x5200 #x4800 #x4800 #x0400 #x0400 #x0200 #x0000 #x0000 #x0000 #x0000)))
(BLOCK . (4 7
  (#x807f #x003f #x003f #x003f #x003f #x003f #x003f #x003f #x003f #x003f #x003f #x003f #x003f #x003f #x003f #x807f)
  (#x0000 #x7f80 #x7f80 #x7f80 #x7f80 #x7f80 #x7f80 #x7f80 #x7f80 #x7f80 #x7f80 #x7f80 #x7f80 #x7f80 #x7f80 #x0000)))
(CIRCLE . (2 2
  (#xcfff #x87ff #x03ff #x03ff #x87ff #xcfff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x3000 #x4800 #x4800 #x3000 #x0000 #x0000 #x0000 #x0000 #x0000 #x0000 #x0000 #x0000 #x0000 #x0000 #x0000)))
(EXCLAIM . (0 14
  (#xffe1 #xffc0 #xff80 #xff00 #xfe01 #xfc03 #xfc07 #xf80f #xf01f #xf07f #xe0ff #xc1ff #x87ff #x07ff #x0fff #x9fff)
  (#x0000 #x001e #x003e #x007e #x00fc #x01f8 #x01f0 #x03e0 #x0780 #x0700 #x0e00 #x0000 #x3000 #x7000 #x6000 #x0000)))
(HAND . (5 1
  (#xffff #xffff #xfbff #xfbff #xfbff #xfabf #xfaaf #xeaaf #xc0af #xc00f #xc00f #xc00f #xc00f #xe01f #xf03f #xffff)
  (#x0000 #x0400 #x0a00 #x0a00 #x0b40 #x0ab0 #x3aa8 #x4aa8 #x48a8 #x4008 #x4008 #x4008 #x4008 #x2010 #x1020 #x0fc0)))
(HOURGLAS . (7 7
  (#x8003 #x8003 #x8003 #x8003 #x8003 #x8003 #x8003 #x8823 #x8003 #x8003 #x8003 #x8003 #x8003 #x8003 #x8003 #xffff)
  (#x7ffc #x3558 #x2aa8 #x3558 #x2aa8 #x2548 #x2288 #x2108 #x2288 #x2548 #x2aa8 #x3558 #x2aa8 #x3558 #x7ffc #x0000)))
(KITE . (2 2
  (#x87ff #x03ff #x03ff #x03ff #x03ff #x83ff #xf1ff #xf8ff #xfdff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x7800 #x4800 #x4800 #x7800 #x0800 #x0400 #x0200 #x0000 #x0000 #x0000 #x0000 #x0000 #x0000 #x0000 #x0000)))
(MESH . (0 0
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#xffff #xaaab #xd555 #xaaab #xd555 #xaaab #xd555 #xaaab #xd555 #xaaab #xd555 #xaaab #xd555 #xaaab #xd555 #xffff)))
(SMALL . (0 0
  (#xbfff #x1fff #x0fff #x07ff #x03ff #x01ff #x00ff #x01ff #x03ff #x01ff #xb0ff #xf0ff #xf9ff #xffff #xffff #xffff)
  (#x0000 #x4000 #x6000 #x7000 #x7800 #x7c00 #x7e00 #x7c00 #x7800 #x4c00 #x0600 #x0600 #x0000 #x0000 #x0000 #x0000)))
(SQUARE . (0 0
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#xffff #x8001 #x8001 #x8001 #x8001 #x8001 #x8001 #x8001 #x8001 #x8001 #x8001 #x8001 #x8001 #x8001 #x8001 #xffff)))
(STAR4 . (7 7
  (#xfe7f #xfc3f #xfc3f #xfc3f #xf81f #xf00f #x8001 #x0000 #x0000 #x8001 #xf00f #xf81f #xfc3f #xfc3f #xfc3f #xfe7f)
  (#x0000 #x0180 #x0180 #x0180 #x03c0 #x03c0 #x0e70 #x7c3e #x7c3e #x0e70 #x03c0 #x03c0 #x0180 #x0180 #x0180 #x0000)))
(TEXT . (5 7
  (#xc63f #x801f #x000f #xb0df #xf0ff #xf0ff #xf0ff #xf0ff #xf0ff #xf0ff #xb0df #x000f #x801f #xc63f #xffff #xffff)
  (#x0000 #x39c0 #x4620 #x0600 #x0600 #x0600 #x0600 #x0600 #x0600 #x0600 #x0600 #x4620 #x39c0 #x0000 #x0000 #x0000)))
(X . (5 6
  (#x1f8f #x0f0f #x060f #x000f #x801f #xc03f #xe07f #xc03f #x801f #x000f #x060f #x0f0f #x1f8f #xffff #xffff #xffff)
  (#x0000 #x4020 #x6060 #x30c0 #x1980 #x0f00 #x0600 #x0f00 #x1980 #x30c0 #x6060 #x4020 #x0000 #x0000 #x0000 #x0000)))

; the following are reproduced from MCD (mouse cursor designer)
; without permission
(BEAKER . (1 2
  (#xffff #x0001 #x0000 #x8000 #xc000 #xc000 #xc000 #xc000 #xc000 #xc000 #xc000 #xc000 #xc000 #xc000 #xe001 #xf003)
  (#x0000 #x0000 #x7ffe #x3ffe #x1ffe #x1ffe #x1fc2 #x1602 #x1002 #x1002 #x1002 #x1002 #x1002 #x1002 #x0ffc #x0000)))
(BULLSEYE . (7 8
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x07e0 #x0810 #x13c8 #x2424 #x2994 #x4a52 #x524a #x542a #x524a #x4a52 #x2994 #x2424 #x13c8 #x0810 #x07e0)))
(CALIPERS . (7 14
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x0180 #x0240 #x0180 #x0180 #x0240 #x0240 #x0420 #x0810 #x1008 #x2004 #x2004 #x2004 #x1008 #x0c30 #x0000)))
(CLOCK . (7 7
  (#xe01f #xe01f #xe01f #xc00f #x8007 #x0003 #x0003 #x0001 #x0003 #x0003 #x8007 #xc00f #xe01f #xe01f #xe01f #xffff)
  (#x0000 #x0fc0 #x0fc0 #x1020 #x2110 #x4108 #x4108 #x410c #x4208 #x4408 #x2010 #x1020 #x0fc0 #x0fc0 #x0000 #x0000)))
(CRAYON . (1 1
  (#x0fff #x07ff #x03ff #x01ff #x80ff #xc07f #xe03f #xf01f #xf80f #xfc07 #xfe03 #xff01 #xff83 #xffc7 #xffef #xffff)
  (#x0000 #x7000 #x6800 #x5400 #x2200 #x1100 #x0880 #x0440 #x0220 #x0110 #x0088 #x0054 #x0028 #x0010 #x0000 #x0000)))
(CROSSHAIR . (8 7
  (#xff7f #xfe3f #xfe3f #xfe3f #xfe3f #xff7f #xc3e1 #x81c0 #xc3e1 #xff7f #xfe3f #xfe3f #xfe3f #xfe3f #xff7f #xffff)
  (#x0000 #x0080 #x0080 #x0080 #x0080 #x0000 #x0000 #x3c1e #x0000 #x0000 #x0080 #x0080 #x0080 #x0080 #x0000 #x0000)))
(CROSS . (7 8
  (#xffff #xf01f #xf01f #xf01f #xf01f #x0001 #x0001 #x0001 #x0001 #x0001 #x0001 #x0001 #xf01f #xf01f #xf01f #xf01f)
  (#x0000 #x0fe0 #x0820 #x0ba0 #x0ba0 #xfbbe #x8382 #xbffa #xbffa #xbffa #x8382 #xfbbe #x0ba0 #x0ba0 #x0820 #x0fe0)))
(DISK . (7 14
  (#x0003 #x0003 #x0003 #x0003 #x0003 #x0003 #x0003 #x0003 #x0003 #x0003 #x0003 #x0003 #x0003 #x0003 #x0003 #x0003)
  (#x0000 #x7ff8 #x4008 #x4008 #x4008 #x4008 #x4308 #x4788 #x4308 #x4008 #x4308 #x4308 #x4308 #x4008 #x7ff8 #x0000)))
(ERASER . (3 12
  (#xff8f #xff07 #xfe03 #xfc01 #xf800 #xf001 #xe003 #xc007 #x800f #x001f #x003f #x807f #xc0ff #xe1ff #xf3ff #xffff)
  (#x0000 #x0070 #x00a8 #x0114 #x020e #x0414 #x0828 #x1050 #x20a0 #x4140 #x6280 #x3500 #x1e00 #x0c00 #x0000 #x0000)))
(FINGER . (5 0
  (#xffff #xf3ff #xe1ff #xe1ff #xe1ff #xe1ff #xe007 #xe000 #x8000 #x0000 #x0000 #x0000 #x0000 #x0000 #x8001 #xc003)
  (#x0000 #x0c00 #x1200 #x1200 #x1200 #x13b0 #x124e #x1249 #x7249 #x9249 #x9001 #x8001 #x8001 #x8001 #x4002 #x3ffc)))
(GUNSIGHT . (8 7
  (#xffff #xffff #xfc9f #xf80f #xf007 #xe003 #xe003 #xf007 #xe003 #xe003 #xf007 #xf80f #xfc9f #xffff #xffff #xffff)
  (#x0080 #x0080 #x03e0 #x0490 #x0888 #x1084 #x1004 #x7c9f #x1004 #x1084 #x0888 #x0490 #x03e0 #x0080 #x0080 #x0000)))
(HAIRS . (7 7
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x0000 #x0fe0 #x1110 #x2108 #x4104 #x4004 #x7c7c #x4004 #x4104 #x2108 #x1110 #x0fe0 #x0000 #x0000 #x0000)))
(HUMAN . (7 6
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x0380 #x07c0 #x07c0 #x0380 #x0100 #x07c0 #x0540 #x0920 #x3118 #x0100 #x0280 #x0460 #x0418 #x0c00 #x0000)))
(IBAR . (7 11
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x1c70 #x0280 #x0100 #x0100 #x0100 #x0100 #x0100 #x0100 #x0100 #x0100 #x07c0 #x0100 #x0280 #x1c70 #x0000)))
(LASSO . (5 6
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x1f00 #x2080 #x4040 #x4040 #x8020 #x8020 #x80c0 #x4140 #x4140 #x2080 #x1f40 #x0020 #x0010 #x0008 #x0007)))
(LLPOINT . (0 15
  (#xfc03 #xf001 #xe000 #xc000 #x8000 #x8001 #xc001 #xc001 #xe021 #xf061 #xf0f0 #xe1f9 #xc3ff #x87ff #x0fff #x9fff)
  (#x03fc #x0c02 #x1001 #x2401 #x4901 #x5242 #x2482 #x2922 #x1252 #x0c92 #x0909 #x1206 #x2400 #x4800 #x9000 #x6000)))
(LRPOINT . (15 15
  (#xc03f #x800f #x0007 #x0003 #x0001 #x8001 #x8003 #x8003 #x8407 #x860f #x0f0f #x9f87 #xffc3 #xffe1 #xfff0 #xfff9)
  (#x3fc0 #x4030 #x8008 #x8024 #x8092 #x424a #x4124 #x4494 #x4a48 #x4930 #x9090 #x6048 #x0024 #x0012 #x0009 #x0006)))
(ULPOINT . (0 0
  (#x9fff #x0fff #x87ff #xc3ff #xe1f9 #xf0f0 #xf061 #xe021 #xc001 #xc001 #x8001 #x8000 #xc000 #xe000 #xf001 #xfc03)
  (#x6000 #x9000 #x4800 #x2400 #x1206 #x0909 #x0c92 #x1252 #x2922 #x2482 #x5242 #x4901 #x2401 #x1001 #x0c02 #x03fc)))
(URPOINT . (15 0
  (#xfff9 #xfff0 #xffe1 #xffc3 #x9f87 #x0f0f #x860f #x8407 #x8003 #x8003 #x8001 #x0001 #x0003 #x0007 #x800f #xc03f)
  (#x0006 #x0009 #x0012 #x0024 #x6048 #x9090 #x4930 #x4a48 #x4494 #x4124 #x424a #x8092 #x8024 #x8008 #x4030 #x3fc0)))
(MOVE . (7 7
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x0100 #x0380 #x0540 #x0100 #x1110 #x2008 #x7c7c #x2008 #x1110 #x0100 #x0540 #x0380 #x0100 #x0000 #x0000)))
(PAINTCAN . (13 14
  (#xfeff #xfc7f #xf83f #xf01f #xe007 #xc003 #x8001 #x0001 #x8001 #xc001 #xe021 #xf061 #xf8e1 #xfde1 #xfff1 #xfffb)
  (#x0000 #x0100 #x0280 #x0440 #x0820 #x1018 #x3ffc #x7ffc #x3fec #x1fcc #x0f8c #x070c #x020c #x000c #x0004 #x0000)))
(PENCIL . (7 14
  (#xf83f #xf01f #xf01f #xf01f #xf01f #xf01f #xf01f #xf01f #xf01f #xf01f #xf01f #xf01f #xf01f #xf83f #xfc7f #xfeff)
  (#x0000 #x07c0 #x0440 #x0440 #x07c0 #x0440 #x0440 #x0440 #x0440 #x0440 #x0440 #x07c0 #x07c0 #x0380 #x0100 #x0000)))
(PENCIL2 . (14 14
  (#xefff #xc7ff #x83ff #x01ff #x80ff #xc07f #xe03f #xf01f #xf80f #xfc07 #xfe03 #xff01 #xff80 #xffc0 #xffe0 #xfff0)
  (#x0000 #x1000 #x3800 #x7c00 #x3a00 #x1100 #x0880 #x0440 #x0220 #x0110 #x0088 #x0044 #x0022 #x0016 #x000e #x0000)))
(PLIERS . (8 1
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x0180 #x03c0 #x03c0 #x03c0 #x0180 #x0180 #x0240 #x0420 #x0810 #x1008 #x1008 #x1008 #x1008 #x0810 #x0000)))
(SCREWDRIVER . (1 14
  (#xfff7 #xffe3 #xffc1 #xff80 #xff01 #xfe03 #xfc07 #xfe0f #xfc1f #xf8bf #xf1ff #xe3ff #xc7ff #x8fff #x1fff #x3fff)
  (#x0000 #x0008 #x001c #x003e #x007c #x00f8 #x01f0 #x00e0 #x0140 #x0200 #x0400 #x0800 #x1000 #x2000 #x4000 #x0000)))
(SELECT . (7 8
  (#xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff #xffff)
  (#x0000 #x0000 #x7d7c #x4104 #x4104 #x4104 #x4104 #x0000 #x7c7c #x0000 #x4104 #x4104 #x4104 #x4104 #x7d7c #x0000)))
(SWORD . (7 14
  (#xfeff #xfc7f #xf83f #xf82f #xf007 #xe00f #xc01f #xe83f #xf83f #xf83f #xf83f #xf83f #xf83f #xf83f #xfc7f #xfeff)
  (#x0000 #x0100 #x0380 #x0380 #x0390 #x0fe0 #x1380 #x0380 #x0380 #x0380 #x0380 #x0380 #x0380 #x0380 #x0100 #x0000)))
(TEST . (8 7
  (#xffff #xffff #xffff #xfc1f #xf88f #xf087 #xe083 #xef7b #xe083 #xf087 #xf88f #xfc1f #xffff #xffff #xffff #xffff)
  (#x0000 #x0000 #x0000 #x0000 #x03e0 #x07f0 #x0ff8 #x0000 #x0ff8 #x07f0 #x03e0 #x0000 #x0000 #x0000 #x0000 #x0000)))
(THE-BOOT . (14 13
  (#x80ff #x007f #x007f #x007f #x007f #x007f #x007f #x007f #x007f #x007f #x003f #x0003 #x0001 #x0000 #x0001 #x8e03)
  (#x0000 #x7f00 #x4100 #x4100 #x4100 #x4100 #x4100 #x4100 #x4100 #x4100 #x4100 #x40c0 #x403c #x5e02 #x71fc #x0000)))
(SCISSORS . (6 7
  (#xffff #xffff #xfff1 #x1fe0 #x07c0 #x81c0 #xe001 #xf80f #xf80f #xe001 #x81c0 #x07c0 #x1fe0 #xfff1 #xffff #xffff)
  (#x0000 #x0000 #x0000 #x000e #xe011 #x3811 #x0e3e #x01c0 #x01c0 #x0e3e #x3811 #xe011 #x000e #x0000 #x0000 #x0000)))
		)))
  (if (symbol? symbol)
      (set! (access query (procedure-environment mouse))
	(assq symbol cursors))))
