; LOADRUN
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Autoload definitions for Runtime version		*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: Terry Caudill		Date: 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

;
; Set up the standard autoload files. LOADCOMP.S also has autoload
; definitions for compiler version. Both LOADCOMP.S and LOADRUN.S
; should be included in COMPILER.APP.

(autoload-from-file (%system-file-name "WINDOWS.FSL")   ; windows
  '(gc-screen full-screen split-screen text-mode
    window-scroll-up window-scroll-down
    make-window window-clear window-delete
    window-get-position window-set-position!
    window-get-size window-set-size! window-get-cursor
    window-set-cursor! window-popup window-popup-delete
    window-get-attribute window-set-attribute! window-reverse-text!)
  user-global-environment)

(autoload-from-file (%system-file-name "MATH.FSL")       ; real arithmetic
  '(acos asin atan cos exact? exp expt inexact?
    log pi sin sqrt tan)
  user-global-environment)

(autoload-from-file (%system-file-name "PRETTY.FSL")     ; pretty printer
  '(pp %pretty-printer %pp-me)
  user-global-environment)

(autoload-from-file (%system-file-name "MSDOS.FSL")      ; DOS facilities
  '(dos-dir dos-get-env dos-put-env dos-search-file 
    dos-call sw-int dos-delete delete-file dos-file-copy
    dos-rename dos-file-size dos-chdir dos-get-dir
    dos-change-drive)
  user-global-environment)

(autoload-from-file (%system-file-name "SORT.FSL")       ; Sort package
  '(sort! %sort-less?)
  user-global-environment)

(autoload-from-file (%system-file-name "NUM2STR.FSL")    ; Number->String
  '(number->string string->number integer->string sprintf sscanf)
  user-global-environment)

(autoload-from-file (%system-file-name "VARARG.FSL")     ; Variable-args
  '(* + - / <= >= < > = <> append append! bitwise-and bitwise-or bitwise-xor
    char-ready? display list list* make-vector make-string max min
    newline prin1 princ print read-line read-atom read-char unread-char
    vector write write-char %graphics %esc %mouse)
  user-global-environment)

(autoload-from-file (%system-file-name "NEWWIN.FSL")	 ; Interactive windows
  '(new-window)
  user-global-environment)

(autoload-from-file (%system-file-name "ED.FSL")	 ; editor class
  '(make-editor make-enhanced-editor make-color-editor make-scheme-editor)
  user-global-environment)

(autoload-from-file (%system-file-name "GRAPHICS.FSL")   ; BGI graphics
  '(set-distances! set-coordinates! set-point?-! set-world! restore-world!
    close-graph detect-graph graph-defaults get-graph-mode get-mode-range
    init-graph install-user-driver install-user-font restore-crt-mode
    set-graph-mode arc circle draw-poly ellipse get-arc-coords
    get-aspect-ratio get-line-settings line line-rel line-to move-to
    move-rel rectangle set-aspect-ratio set-line-style bar bar-3d
    fill-ellipse fill-poly flood-fill get-fill-pattern get-fill-settings
    pie-slice sector set-fill-pattern set-fill-style clear-device
    set-active-page set-visual-page clear-viewport get-view-settings
    set-viewport get-image image-size put-image get-pixel put-pixel
    get-text-settings out-text out-text-xy set-text-justify set-text-style
    set-user-char-size text-height text-width get-bk-color get-color
    get-default-palette get-max-color get-palette get-palette-size
    set-all-palette set-bk-color set-color set-palette set-rgb-palette
    graph-error-msg graph-result get-driver-name get-max-mode get-max-xy
    get-mode-name get-xy *pcs-bgi-error* set-write-mode bgi-environment)
   user-global-environment)

(autoload-from-file (%system-file-name "MOUSE.FSL")	; Mouse support
  '(mouse)
  user-global-environment)
(autoload-from-file (%system-file-name "DESKTOP.FSL")	; Desktop environment
  '(desktop)
   user-global-environment)
(autoload-from-file (%system-file-name "FASTSAVE.FSL")	; Make a .FSL
  '(fast-save fast-save-file))

(autoload-from-file (%system-file-name "PEEK.FSL")      ; Peek & Poke
  '(peek poke in-port out-port))
