;* EDLISP.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		EDLISP: A cute little editor for PCS			*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: Bertrand le Guern		Date: 1993		*
;* Revision history:							*
;* - Aug 1993: Creation (blg)						*
;* - 26 Nov 1993: A few minor changes to add flexibility (lb)		*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
;* ORIGINAL DOC by Bertand Le Guern					*
;* Un petit utilitaire si vous ne souhaitez pas utiliser EDWIN.		*
;* L'diteur EDLISP a t crit spcialement pour PCS par		*
;* Bertrand LeGuern, prof. de maths  Albi, et hacker C devant		*
;* l'Eternel... Merci, Bertrand !					*
;*									*
;* A la sortie, EDLISP demande ce qu'il faudra compiler (tout ou un	*
;* bloc), et le sauvera dans un fichier BUFFER.TMP, dans un rpertoire	*
;* que l'on prcise sur la ligne de commande de EDLISP (cf. ci-dessous).*
;* On suppose que BUFFER.TMP est  la racine de D: (modifiez suivant	*
;* vos disques durs).							*
;*									*
;* Exemple:			(edit "fac.scm")			*
;* les jokers sont admis :	(edit "ex1-*.scm")			*
;* avec ouverture d'autant de fentres. Mais seule la fentre		*
;* principale sera compilable  la fin via le BUFFER.TMP !		*
;************************************************************************

(define edlisp)
(let* ((file "noname.s")
       (editor (let ((try (dos-search-file "edlisp.exe")))
		 (if try try (%system-file-name "edlisp.exe"))))
       (helper (let ((try (dos-search-file "edhlp.bat")))
		 (if try try (%system-file-name "edhlp.bat"))))
       (temp (or (dos-get-env "TEMP")
		 (dos-get-env "TMP")
		 ""))
       (buffer (string-append temp "/buffer.tmp")))
  (set! edlisp
    (lambda args
      (if (not (null? args))
	  (set! file (car args)))
      (if (file-exists? buffer)
	  (dos-delete buffer))
      (dos-call editor
		(string-append " /m116"
			       " /f7"
			       " /c30"
			       " /b32000"
			       " /d" temp
			       " /H" helper
			       " " file)
		0
		0)
      (if (file-exists? buffer)
	  (load buffer))
      *the-non-printing-object*)))

