;* DESKTOP.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.02 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Event-driven Object-Oriented desktop system		*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: L. Bartholdi & M. Vuilleumier		Date: Oct 1993	*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

(define desktop
  (letrec
    (
      (running #F)
      (time-unit 3)
      (handlers '())
      (delta 8)

      (register
	(lambda (him)
	  (set! handlers (cons him handlers))
	))

      (handler
	(let* ((state 'NONE)
	       (wait (lambda ()
		       (mouse 'ENABLE)
		       ((named-lambda (loop then)
			  (if (< (clock) then)
			      (loop then)))
			(+ (clock) time-unit))))
	       (count-left 0)
	       (count-center 0)
	       (count-right 0)
	       (update (lambda (events)
			 (if (memq 'LEFT-DOWN events)
			     (set! count-left (1+ count-left)))
			 (if (memq 'CENTER-DOWN events)
			     (set! count-center (1+ count-center)))
			 (if (memq 'RIGHT-DOWN events)
			     (set! count-right (1+ count-right)))
		       ))
	       (dragger (lambda (events buttons x y . rest)
			  (cond ((null? buttons)	; all released
				 (set! state 'NONE)
				 (mouse 'HANDLER `((BUTTONS) . ,handler))
				 (mouse 'DISABLE)
				 (for-each (lambda (him) (him 'DRAG-END x y))
					   handlers)
				 (mouse 'ENABLE))
				((memq 'MOVE events)
				 (for-each (lambda (him) (him 'DRAG-MOVE x y))
					   handlers))
			  )))
	      )
	  (lambda (events buttons x y . rest)
	    (case state
	      (NONE (set! state 'WAITING)
		    (set! count-left 0)
		    (set! count-center 0)
		    (set! count-right 0)
		    (update events)
		    (wait)
		    (let ((inq (mouse 'INQ)))
		      (if (and (null? (car inq))
			       (< (abs (- x (cadr inq))) delta)
			       (< (abs (- y (caddr inq))) delta))
			  (begin
			    (set! state 'NONE)
			    (mouse 'DISABLE)
			    (for-each (lambda (him)
					(him 'CLICK count-left count-center count-right x y))
				      handlers)
			    (mouse 'ENABLE))
			  (begin
			    (set! state 'DRAG)
			    (mouse 'HANDLER `((UP MOVE) . ,dragger))
			    (mouse 'DISABLE)
			    (for-each (lambda (him)
					(him 'DRAG-START (car inq) x y))
				      handlers)
			    (mouse 'ENABLE))
		      )))
	      (WAITING (update events)
		       (wait))
	    ))))

      (install
	(lambda ()
	  (mouse 'RESET)
	  (mouse 'SHOW)
	  (set! running (mouse 'HANDLER `((BUTTONS) . ,handler)))))

      (uninstall
	(lambda ()
	  (mouse 'HANDLER running)
	  (set! running #F)))

      (me
	(lambda (message . args)
	  (apply (case message
		   (REGISTER	register)
		   (UNINSTALL   uninstall)
		   (TIME-UNIT   (lambda l (begin0 time-unit (if l (set! time-unit (car l))))))
		   (DELTA       (lambda l (begin0 delta (if l (set! delta (car l))))))
		   (else (%error-invalid-operand 'DESKTOP message)))
		 args)))
    )

    (lambda args
      (if (not running)
	  (install))
      (if args (apply me args)))
  ))
