;* 
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Peek, poke, in & out implementation			*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: M. Vuilleumier &	L.Bartholdi	Date: Nov 1992		*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

; Let have...	0 <= address	<= #h10FFEF	(address > #hfffff cause A20)
;		0 <= X X1 .. Xn	<= #hFF[FF]	values read from memory
;		0 <= X Y1 .. Yn	<= #hFF[FF]	values to store in memory
;
; (peek 'BYTE address)		---->	X		read a memory byte
; (peek 'WORD address)		---->	X		read a memory word
; (peek 'BYTE address n)	---->	'(X1 X2 ... Xn)	read a block of bytes
; (peek 'WORD address n)	---->	'(X1 X2 ... Xn)	read a block of words
;
; (poke 'BYTE address Y)	---->	X		store a memory byte
; (poke 'WORD address Y)	---->	X		store a memory word
; (poke 'BYTE address 
;	'(Y1 Y2 .. Yn)) 	---->	'(X1 X2 ... Xn)	store a block of bytes
; (poke 'WORD address 
;	'(Y1 Y2 .. Yn)) 	---->	'(X1 X2 ... Xn)	store a block of words
;
;
; Now have...	0 <= Portnum	<= #hFFFF (usually Portnum <= #h3FF)
;		0 <= DataByte	<= #hFF		to read from/write to port
;		0 <= DataWord	<= #hFFFF	to read from/write to port
;
; (in-port 'BYTE Portnum)	---->	DataByte	read a byte from port
; (in-port 'WORD Portnum)	---->	DataWord	read a word from port
;
; (out-port 'BYTE Portnum DataByte) ----> undefined	write a byte to port
; (out-port 'WORD Portnum WordByte) ----> undifined	write a word to port

(if (unbound? peekbyte)
  (load (%system-file-name "peek.bin")))

(define peek)
(define poke)
(define in-port)
(define out-port)

(let
  ((range
     (lambda (n max)
       (if (number? n) (and (>= n 0)
			    (<= n max)))))
   (error!
     (lambda (proc . args)
       (%error-invalid-operand proc (cons proc args)))))

  (set! peek
    (lambda (size adr . n)
      (cond ((eq? (car n) 0) 		'())
	    ((not (range adr #h10ffef))	(error! 'peek size adr '...))
	    ((null? n)
	     (cond
	       ((eq? size 'BYTE)	(peekbyte adr))
	       ((eq? size 'WORD)	(+ (* (peekbyte (1+ adr)) #h100)
					   (peekbyte adr)))
	       (else			(error! 'peek size '...))))
	    ((not (range (car n) #h10ffef)) (error! 'peek size adr n))
	    (else
             (cons (peek size adr) 
		   (peek size (+ adr (if (eq? size 'BYTE) 1 2)) 
			      (-1+ (car n))))))))

  (set! poke
    (lambda (size adr data)
      (cond ((null? data)		'())
	    ((not (range adr #h10ffef))	(error! 'poke size adr '...))
	    ((and (eq? size 'BYTE)
		  (range data #hff))	(pokebyte adr data))
	    ((and (eq? size 'WORD)
		  (range data #hffff))	(+ (* (pokebyte (1+ adr) (quotient data #h100)) #h100)
					   (pokebyte adr (remainder data #h100))))
	    ((atom? data)		(error! 'poke size adr data))
	    (else
	      (cons (poke size adr (car data)) 
		    (poke size (+ adr (if (eq? size 'BYTE) 1 2)) (cdr data)))))))

  (set! in-port
    (lambda (size pnum)
      (cond ((not (range pnum #hffff))	(error! 'in-port size pnum))
	    ((eq? size 'BYTE)		(inbyte pnum))
	    ((eq? size 'WORD)		(inword pnum))
	    (else			(error! 'in-port size '...)))))

  (set! out-port
    (lambda (size pnum data)
      (cond ((not (range pnum #hffff))	(error! 'out-port size pnum '...))
	    ((eq? size 'BYTE)		(if (range data #hff)
					    (outbyte pnum data)
					    (error! 'out-port size pnum data)))
	    ((eq? size 'WORD)		(if (range data #hffff)
					    (outword pnum data)
					    (error! 'out-port size pnum data))
	    (else			(error! 'out-port size '...))))))

)




     

