/* OUTPUT.C
 ************************************************************************
 *									*
 *		PC Scheme/Geneva 4.00 Borland C code			*
 *									*
 * (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
 * (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
 *									*
 *----------------------------------------------------------------------*
 *									*
 *  		    PC-Scheme port output routines			*
 *									*
 *----------------------------------------------------------------------*
 *									*
 * Created by: Marc Vuilleumier		Date: Jan 1993			*
 *             (clear_window & gc's written by John Jensen Feb 1985)	*
 * Revision history:							*
 * - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
 *									*
 *					``In nomine omnipotentii dei''	*
 ************************************************************************/

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<alloc.h>
#include	<dos.h>
#include	"scheme.h"

/************************************************************************/
/* Clear Window								*/
/************************************************************************/
int	clear_window(REGPTR reg)
{
	PORT	far	*p;

	if( get_port(reg, INPUT_PORT) )
	{
		set_src_error("WINDOW-CLEAR", 1, reg);
		return	-1;
	}
	p = &reg2c(&tmp_reg)->port;

	if( ptype[CORRPAGE(tmp_reg.page)] != PORTTYPE ||
		(p->flags & PORT_TYPE) != TYPE_WINDOW )
	{
		set_src_error("WINDOW-CLEAR", 1, reg);
		return	-1;
	}

	zclear( p->ulline, p->ulcol, p->nlines, p->ncols, p->text );

	if( p->border != 0xffff )
	{
		char	*string;

		load( &tmp_reg, &(p->ptr) );
		string = string_asciz(&tmp_reg);
		zborder( p->ulline, p->ulcol, p->nlines, p->ncols, p->border, string);
		rlsstr(string);
	}
	p->curline = p->curcol = 0;
	return	0;
}

/************************************************************************/
/* Write "GC On" Message to the who-line				*/
/************************************************************************/
void 	gc_on(int squishing)
{
	REG	lcl_reg;
	char	*text;

	intern(&lcl_reg, "PCS-GC-MESSAGE", 14);
	if( sym_lookup(&lcl_reg, &gnv_reg) && (text = string_asciz(&lcl_reg)) != 0)
	{
		who_write("\n");
		who_write(text);
		rlsstr(text);
	} else {
		if( squishing )
			who_write("\n * Garbage Squishing *");
		else
			who_write("\n * Garbage Collecting *");
	}
}

/************************************************************************/
/* Un-Write "GC On" Message to the who-line				*/
/************************************************************************/
void 	gc_off(void)
{
	REG		lcl_reg;
	char		*text, s[255];
	int		dynamic = 0;

	internimm( &lcl_reg, "PCS-GC-RESET");
	if ( !sym_lookup(&lcl_reg, &gnv_reg) )
		lcl_reg = nil_reg;

	if ( (text = string_asciz(&lcl_reg)) == NULL )
		text = VERSIONSTR " [Free: scheme=%lu\b\b\bKb, kernel=%lu\b\b\bKb]";
	else
		dynamic = 1;

	sprintf( s, text, (long) freesp(), (long) coreleft() );
	who_write("\n");
	who_write( s );

	if( dynamic )
		rlsstr(text);
}


/************************************************************************/
/* Write a message to the who-line					*/
/************************************************************************/
void	who_write( char *text )
{
	REG		oldport = port_reg;

	ssetadr( ADJPAGE(WHO_PAGE), WHO_DISP );
	printstr( text, strlen(text) );

	if ( ptype[CORRPAGE(oldport.page)] == PORTTYPE )
		ssetadr( oldport.page, oldport.disp );
}

