/************************************************************************
 *									*
 *		PC Scheme/Geneva 4.00 Borland C code			*
 *									*
 * (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
 * (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
 *									*
 *----------------------------------------------------------------------*
 *									*
 *			The Main Scheme Routine				*
 *									*
 *----------------------------------------------------------------------*
 *									*
 * Created by: John Jensen		Date: 1985			*
 * Revision history:							*
 * - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
 *									*
 *					``In nomine omnipotentii dei''	*
 ************************************************************************/

#include 	"mysignal.h"
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<conio.h>
#include	<dos.h>
#include	<dir.h>
#include 	"scheme.h"

static char    *spec_symbs[] = {
	"SCHEME-TOP-LEVEL", 		"READ",			"EOF",
	"INPUT-PORT", 			"OUTPUT-PORT", 		"CONSOLE",
        "*THE-NON-PRINTING-OBJECT*",    "USER-GLOBAL-ENVIRONMENT",
        "USER-INITIAL-ENVIRONMENT",     pcsrsenv,
        "*ERROR-HANDLER*",              "PCS-STATUS-WINDOW",
        "PCS-KILL-ENGINE", NULL };

#ifdef VMDEBUG
	#define	BETADEBUG	"/betadebug"
	#define action(what)	if (vm_debug) printf(what)
#else
	#define	action(what)	/* what */
#endif

extern unsigned paragraphnum;		/* number of paragraphs of memory available */
extern unsigned _stklen = 0x4000;

#define	internimm(reg,name)	intern( reg, name, sizeof name - 1 );

void	setwindow( unsigned, unsigned, int, unsigned );
void	setitup( int, char *[], unsigned & );

#pragma	argsused

int main(int argc, char *argv[])
{
	extern int	_argc;
	RETVALUE	stat;
	unsigned	errcode, textattrib;

	action("Entering MAIN\n");

	setitup( _argc, argv, textattrib );
	/* use the argc value computed in startup, not the primitive C parse */

	action("\nNow starting Virtual Machine. Type ? to get help from within VM debugger\n");
	do {
		while( (stat = interp(&s_pc, &errcode, 0xffff)) == PROCEED );
#ifdef	VMDEBUG
		if( stat == SDEBUG || stat == CLOBBERED )
			stat = sdebug( &errcode );
#endif
	} while( stat != HALT );

#ifdef VMDEBUG
	#undef	action
	#define action(what)	/* no more comment */
#endif
	setwindow( WHO_PAGE, WHO_DISP, WINDOW_ATTRIBUTES, textattrib );
	return	errcode;
}

/************************************************************************/
/* Set-up a window port		                    			*/
/************************************************************************/
void	setwindow( unsigned page, unsigned disp, int where, unsigned what )
{
	REG	window( disp, ADJPAGE(page) );
	REG	f1( where, ADJPAGE(SPECFIX) );
	REG	f2( what,  ADJPAGE(SPECFIX) );
	
	action("Manipulating a window\n");

	set_window_attribute( &window, &f1, &f2 );
	if( where == WINDOW_ATTRIBUTES )
		clear_window( &window );
}

/************************************************************************/
/* Set-up all PCS stuffs	                    			*/
/************************************************************************/
unsigned	ndp[] = { 0, 87, 287, 387 };

void	setitup( int argc, char *argv[], unsigned &textattrib )
{
	int		i, j;
	int		page_count;
	REGPTR		ptr;
	REG		sym_reg, f1, f2, in_ptr;
	
#ifdef	VMDEBUG		/* search for /BETADEBUG parameter */
	for( i = 0; i < argc; i++ )
		vm_debug |= ( stricmp( argv[i], BETADEBUG ) == 0 );
#endif

	action("Allocating memory\n");
	page_count = initmem();

	action("Initializing console: height... ");
	setwindow( IN_PAGE, IN_DISP, WINDOW_NROWS, get_max_rows() );
	setwindow( IN_PAGE, IN_DISP, WINDOW_NCOLS, get_max_cols() );
	action("colors... ");
asm {
	mov	ah, 0fh			/* get mode settings */
	int	10h
	mov	ah, 08h			/* read character & attribute */
	int	10h
}
	textattrib = _AH;
	setwindow( IN_PAGE, IN_DISP, WINDOW_ATTRIBUTES, textattrib );

#ifdef VMDEBUG				/* now use zprintf instead of printf */
	#undef	action
	#define action(what)	if (vm_debug) zprintf(what);
#endif
					/* Print Welcome to Scheme */

	ssetadr( ADJPAGE(OUT_PAGE), OUT_DISP );
	outtext( VERSIONSTR, sizeof VERSIONSTR );
	outtext( TEXASRIGHTS, sizeof TEXASRIGHTS );
	outtext( GENEVARIGHTS, sizeof GENEVARIGHTS );
	outtext( RESTRICTIONS, sizeof RESTRICTIONS );

	if (page_count <= 10)
		print_and_exit("[VM FATAL ERROR] Unable to allocate memory for PC Scheme\n");
	else {
		pagelink[nextpage - 1] = END_LIST;
		if (vm_debug)
			zprintf("0x%x total main paragraphs, %dK allocated in 0x%x pages\n", 
				paragraphnum, (unsigned short) (freesp() >> 10), page_count );
	}

	setwindow( WHO_PAGE, WHO_DISP, WINDOW_ULROW, get_max_rows() );
	setwindow( WHO_PAGE, WHO_DISP, WINDOW_NCOLS, get_max_cols() );
	setwindow( WHO_PAGE, WHO_DISP, WINDOW_ATTRIBUTES, 0x70 ); /* reverse attribute */
	gc_off();

	action("Binding PCS-INITIAL-ARGUMENTS\n");
	internimm( &sym_reg, "PCS-INITIAL-ARGUMENTS");
	regs[1] = nil_reg;
	for( i = argc-1; i >= 1; i-- )
	{
		alloc_string( regs+2, argv[i] );
		cons( regs+1, regs+2, regs+1 );
	}
	if( argc > 1 )
		free( argv[1] );	/* the argument block belongs to the first */
	sym_bind( &sym_reg, regs+1, &gnv_reg );

	action("Parsing .APP files, setting system path\n");
	{
		static char	*app_file = "bootstrp.app";
		char		drive[MAXDRIVE];
		char		dir[MAXDIR];
		char		file[MAXFILE];
		char		ext[MAXEXT];

		if( argc > 1 && argv[1][0] == '&')
			app_file = argv[1]+1;

		if( !( fnsplit(app_file, drive, dir, file, ext) & (DRIVE | DIRECTORY) ) ) {
			fnsplit( argv[0], drive, dir, NULL, NULL );
			app_file = (char *) malloc( strlen(drive) + strlen(dir) +
					   	strlen(file) + strlen(ext) + 1 );
			fnmerge( app_file, drive, dir, file, ext );
		}
		alloc_string( regs+1, app_file );
		fnsplit( app_file, drive, dir, NULL, NULL );
		fnmerge( app_file, drive, dir, NULL, NULL );
		internimm( &sym_reg, "PCS-SYSDIR");
		alloc_string(&tm2_reg, app_file);
		sym_bind(&sym_reg, &tm2_reg, &gnv_reg);
					/* put the compiler name into VM register 1 */
		rlsstr(app_file);
	}

	if (vm_debug)			/* put VM debug flag into VM register 2 */
		regs[2].page = ADJPAGE(SPECFIX), regs[2].disp = 0;
	else
		regs[2] = nil_reg;

	action("Defining QUOTE... ");
	internimm( &tmp_reg, "QUOTE");
	quote_reg = tmp_reg;

	action("and other special symbols\n");
	for (i = 0, j = 6; spec_symbs[i]; i++, j += sizeof(POINTER))
	{
		intern(&tmp_reg, spec_symbs[i], strlen(spec_symbs[i]));
		put_ptr(SPECCODE, j, tmp_reg.page, tmp_reg.disp);
	}
	internimm( &console_reg, "CONSOLE");

	action("Interning PCS-MACHINE-TYPE\n");
	internimm( &sym_reg, "PCS-MACHINE-TYPE");
	sym_bind( &sym_reg, &nil_reg, &gnv_reg );

	action("Setting up interrupts ");
	fix_intr();	/* "Fixes" the keyboard DSR to have SHIFT-BRK cause the */
			/* debugger to "kick-in" on the next VM instruction	*/
			/* "Fixes" 24H int DOS Fatal error too			*/
			/* The keyboard is restored in SC.ASM			*/
	action("and floating point exceptions\n");
	signal( SIGFPE, fperror );
}

