/* INPUT.C
 ************************************************************************
 *									*
 *		PC Scheme/Geneva 4.00 Borland C code			*
 *									*
 * (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
 * (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
 *									*
 *----------------------------------------------------------------------*
 *									*
 *  		    PC-Scheme port input routines			*
 *									*
 *----------------------------------------------------------------------*
 *									*
 * Created by: Marc Vuilleumier		Date: Jan 1993			*
 * Revision history:							*
 * - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
 *									*
 *					``In nomine omnipotentii dei''	*
 ************************************************************************/

#include	"scheme.h"
#include	<dos.h>
#include	<conio.h>
#include	<string.h>
#include	<alloc.h>
#include	<mem.h>

#define	HISTSIZE	(4 * BUFFSIZE)

#define CTRL_A	1
#define CTRL_B  2
#define CTRL_C	3
#define CTRL_D	4
#define CTRL_E	5
#define CTRL_F	6
#define CTRL_G	7
#define CTRL_H	8
#define CTRL_I	9
#define CTRL_J	10
#define CTRL_K	11
#define CTRL_L	12
#define CTRL_M	13
#define CTRL_N	14
#define CTRL_O	15
#define CTRL_P	16
#define CTRL_Q	17
#define CTRL_R	18
#define CTRL_S	19
#define CTRL_T	20
#define CTRL_U	21
#define CTRL_V	22
#define CTRL_W	23
#define CTRL_X	24
#define CTRL_Y	25
#define ALT_A	(30*0x100)
#define ALT_B	(48*0x100)
#define ALT_C	(46*0x100)
#define ALT_D	(32*0x100)
#define ALT_E	(18*0x100)
#define ALT_F	(33*0x100)
#define ALT_G	(34*0x100)
#define ALT_H	(35*0x100)
#define ALT_I	(23*0x100)
#define ALT_J	(36*0x100)
#define ALT_K	(37*0x100)
#define ALT_L	(38*0x100)
#define ALT_M	(50*0x100)
#define ALT_N	(49*0x100)
#define ALT_O	(24*0x100)
#define ALT_P	(25*0x100)
#define ALT_Q	(16*0x100)
#define ALT_R	(19*0x100)
#define ALT_S	(31*0x100)
#define ALT_T	(20*0x100)
#define ALT_U	(22*0x100)
#define ALT_V	(47*0x100)
#define ALT_W	(17*0x100)
#define ALT_X	(45*0x100)
#define ALT_Y	(21*0x100)
#define ALT_Z	(44*0x100)

unsigned char	history[HISTSIZE];		/* history buffer */
unsigned char	*histend = history, *histpos;

/************************************************************************/
/*	Reads a specified number of chars from file or string		*/
/*	Return codes are:	0	data read ok			*/
/*				1	end-of-file encountred		*/
/*				2	error (use _doserrno)		*/
/************************************************************************/
int	read_block( REGPTR port, char *buffer, int length )
{
	return 0;
}

/************************************************************************/
/*	tell if a char is available from input buffer 			*/
/*	(possibly get some chars into buffer, when possible)		*/
/************************************************************************/
int	from_buffer( REGPTR port)
{
	return 0;
}

/************************************************************************/
/*	tell if a char can be obtained from a port (if yes, which)	*/
/*						 (interpreter support)	*/
/************************************************************************/
int	port_char_ready( REGPTR port )
{
	PORT	far	*p;
	char		ch;

	if( get_port(port, INPUT_PORT) )
	{
		set_src_error("CHAR-READY?", 1, port);
		return	-1;
	} else
		*port =	tmp_reg;

	if( from_buffer( port ) ) {
		p = &reg2c(port)->port;
		ch = p->buffer[ p->bufpos ];
	} else {
		p = &reg2c(port)->port;
		switch( p->flags & PORT_TYPE ) {
			case TYPE_WINDOW:
			case TYPE_SOFTWARE:
			{
				int	CH = GETCHready();
				if( !CH ) {
					*port = nil_reg;
					return 0;
				}
				ch = CH & 0xff;
				break;
			}
			default:
				if( !(p->flags & READ_OPEN) ) {
					*port = nil_reg;
					return 0;
				}
				switch( read_block( port, &ch, 1 ) ) {
					case 1:
						port->page = ADJPAGE(EOF_PAGE);
						port->disp = EOF_DISP;
						return 0;
					case 2:
						/* signal dos error _doserrno */
						return -1;
				}
				p = &reg2c(port)->port;
				p->bufpos = 0;
				p->bufend = 1;
				p->buffer[1] = ch;
				break;
		}
	}
	port->page = SPECCHAR;
	port->disp = ch;

	return 0;
}


/************************************************************************/
/*	read a char from a specified port and push it back into buffer	*/
/*						 (interpreter support)	*/
/************************************************************************/
int	port_peek_char( REGPTR port )
{
	PORT	far	*p;
	char		ch;

	if( get_port(port, INPUT_PORT) )
	{
		set_src_error("CHAR-READY?", 1, port);
		return	-1;
	} else
		*port =	tmp_reg;

	if( from_buffer( port ) ) {
		p = &reg2c(port)->port;
		ch = p->buffer[ p->bufpos ];
	} else {
		p = &reg2c(port)->port;
 	}

	return 0;
}

/************************************************************************/
/*	read a char from a specified port and forward pointer		*/
/*						 (interpreter support)	*/
/************************************************************************/
int	port_read_char( REGPTR port )
{
	PORT	far	*p;
	char		ch;

	if( get_port(port, INPUT_PORT) )
	{
		set_src_error("CHAR-READY?", 1, port);
		return	-1;
	} else
		*port =	tmp_reg;

	if( from_buffer( port ) ) {
		p = &reg2c(port)->port;
		ch = p->buffer[ p->bufpos ];
	} else {
		p = &reg2c(port)->port;
 	}

	return 0;
}


/************************************************************************/
/*	read a line from a specified port and forward pointer		*/
/*						 (interpreter support)	*/
/************************************************************************/
int	port_read_line( REGPTR port )
{
	PORT	far	*p;
	char		ch;

	if( get_port(port, INPUT_PORT) )
	{
		set_src_error("CHAR-READY?", 1, port);
		return	-1;
	} else
		*port =	tmp_reg;

	if( from_buffer( port ) ) {
		p = &reg2c(port)->port;
		ch = p->buffer[ p->bufpos ];
	} else {
		p = &reg2c(port)->port;
 	}

	return 0;
}


/************************************************************************/
/*	read_win local support: Rewrite a line of text from buffer	*/
/************************************************************************/
void	rewrite( int line, int backward )
{
	PORT		far	*p;
	unsigned char	far	*c;
	int		col;
	
	p = &reg2c(&port_reg)->port;	/* reload port page */
	c = &p->buffer[index];
	col = curcol;
	if ( !backward ) {
		while ( *c != CR && col < ncols )
			zputc(	ulline + line, ulcol + col++,
			      	(t_attrib << 8) + *(c++), 
				1, &vidmode );
	} else {
		unsigned	ref = FP_OFF(p->buffer);

		while ( FP_OFF(c) >= ref && col >= 0 )
			zputc(	ulline + line, ulcol + col--,
			      	(t_attrib << 8) + *(c--), 
				1, &vidmode );
	}
}

/************************************************************************/
/*	read_win local support: Fit current pos within window bounds	*/
/************************************************************************/
void	checkbounds( void )
{
	if ( curcol < 0 ) curcol = ncols - 1, curline--;
	else	if ( curcol >= ncols ) curcol = 0, curline++;

	if ( curline < 0 ) {
		zscroll_d( ulline, ulcol, nlines, ncols, t_attrib );
		rewrite( 0, 1 );
		curline = 0;
	} else
		if ( curline >= nlines ) {
			zscroll( ulline, ulcol, nlines, ncols, t_attrib );
			rewrite( curline = nlines - 1, 0 );
		}
}
	
/************************************************************************/
/*	read_win local support: Update window with buffer contents	*/
/************************************************************************/
void	updatewin( void )
{
	PORT	far	*p;
	int	pos = index, line = curline, col = curcol;
	
	p = &reg2c(&port_reg)->port;	/* reload port page */

	while ( p->buffer[index] != CR && (curcol != ncols || curline != nlines-1) ) {
		checkbounds();
		zputc( ulline + curline, ulcol + (curcol++),
			(t_attrib << 8) + p->buffer[index++], 1, &vidmode );
	}

	curcol = col, curline = line, index = pos;
}

/************************************************************************/
/*	read_win local support: Tells if arg is a Scheme separator	*/
/************************************************************************/
int	is_separator( unsigned char c )
{
	return	c == '"' || (c >= '\'' && c <= ')') ||
		c == '`' || c == ' ' || c == '\t' || c == '\r';
}

/************************************************************************/
/*	read_win local support: goes to word left to cursor		*/
/************************************************************************/
void	wordleft( void )
{
	PORT	far	*p;
	
	p = &reg2c(&port_reg)->port;	/* reload port page */

	while ( index > 0 && is_separator( p->buffer[index-1] ) ) {
		index--, curcol--;
		checkbounds();
	}
	while ( index > 0 && !is_separator( p->buffer[index-1] ) ) {
		index--, curcol--;
		checkbounds();
	}
}

/************************************************************************/
/*	read_win local support: goes to word right to cursor		*/
/************************************************************************/
void	wordright( void )
{
	PORT	far	*p;
	
	p = &reg2c(&port_reg)->port;	/* reload port page */

	while ( !is_separator( p->buffer[index] ) ) {
		index++, curcol++;
		checkbounds();
	}
	while ( p->buffer[index] != CR && is_separator( p->buffer[index] ) ) {
		index++, curcol++;
		checkbounds();
	}
}

/************************************************************************/
/*	read_win local support: goes to end of buffer			*/
/************************************************************************/
void	endkey( void )
{
	PORT	far	*p;
	
	p = &reg2c(&port_reg)->port;	/* reload port page */

	while ( p->buffer[index] != CR ) {
		index++, curcol++;
		checkbounds();
	}
}

/************************************************************************/
/*	read_win local support: goes to beginning of buffer		*/
/************************************************************************/
void	homekey( void )
{
	while ( index != 0 ) {
		index--, curcol--;
		checkbounds();
	}
}

/************************************************************************/
/*	read_win local support: Put a single char into buffer		*/
/************************************************************************/
void	putkey( unsigned char c )
{
	PORT	far	*p;
	int		len;
	
	p = &reg2c(&port_reg)->port;	/* reload port page */

	if ( insert_m || p->buffer[index] == CR ) {
		len = FP_OFF(_fstrchr( &p->buffer[index], CR )) - FP_OFF(p->buffer) + 1;
		if ( len < BUFFSIZE-2 )
			_fmemmove( &p->buffer[index+1], &p->buffer[index], len-index );
		else {
			zbell();
			return;
		}
		p->buffer[index] = c;
		updatewin();
		index++, curcol++;
	} else {
		p->buffer[index] = c;
		zputc( ulline + curline, ulcol + (curcol++),
			(t_attrib << 8) + p->buffer[index++], 1, &vidmode );
	}
}

/************************************************************************/
/*	read_win local support: remove a single char from buffer	*/
/************************************************************************/
void	delkey( void )
{
	PORT	far	*p;
	int		len;
	
	p = &reg2c(&port_reg)->port;	/* reload port page */

	len = FP_OFF(_fstrchr( &p->buffer[index], CR )) - FP_OFF(p->buffer);
	_fmemmove( &p->buffer[index], &p->buffer[index+1], len-index );
	p->buffer[--len] = SPACE;
	updatewin();
	p->buffer[len] = CR;
}

/************************************************************************/
/*	read_win local support: backdel buffer until given index	*/
/************************************************************************/
void	backdelto( int stop )
{
	while ( index > stop ) {
		index--, curcol--;
		checkbounds();
		delkey();
	}
}

/************************************************************************/
/*	read_win local support: insert a part of a string into history	*/
/*		also used for %push-history opcode			*/
/************************************************************************/
void	inhistory( unsigned char far *txt, int len )
{
	if ( histend - history > HISTSIZE - len - 1) {
		history[HISTSIZE - len - 1] = 0; /* put end of string */
		histend = strrchr( history, CR ) + 1;
		if ( histpos > histend ) histpos = histend;
	}
	memmove( &history[len + 1], history, histend - history );
	_fmemmove( history, txt, len );
	history[len] = CR;
	histend += len + 1;
	histpos += len + 1;
}

/************************************************************************/
/*	read_win local support: insert chars from history into buffer	*/
/************************************************************************/
void	fromhistory( void )
{
	while ( histpos < histend && *histpos != CR ) {
		putkey( *histpos++ );
		checkbounds();
	}
	if ( histpos < histend ) histpos++;
}

/************************************************************************/
/*	read_win local support: scan history to more old entry		*/
/*		also used for %get-history opcode			*/
/************************************************************************/
void	scanhistoryfwd( void )
{
	unsigned char	*found = strchr(histpos, CR);

	if ( found ) histpos = found + 1;
}

/************************************************************************/
/*	read_win local support: scan history to more recent entry	*/
/************************************************************************/
void	scanhistorybwd( void )
{
	if ( histpos > history ) {
		unsigned char	*found;

		*(--histpos) = 0;
		found = strrchr(history, CR);
		*histpos = CR;

		if ( found )
			histpos = found + 1;
		else
			histpos = history;
	}
}

/************************************************************************/
/*	read_win local support: search history for one older entry	*/
/*			beginning with first n chars as current buffer	*/
/************************************************************************/
char	*searchfwd( int len )
{
	PORT	far	*p = &reg2c(&port_reg)->port;
	char		*entry = histpos - 1;

	while( entry && _fstrncmp(p->buffer, ++entry, len) )
		entry = strchr( entry, CR );
	
	return entry;
}

/************************************************************************/
/*	read_win local support: search history for one older entry	*/
/*			beginning with first n chars as current buffer	*/
/************************************************************************/
char	*searchbwd( int len )
{
	PORT	far	*p = &reg2c(&port_reg)->port;
	char		*old, *entry = histpos - 1;
	int		comp = 0;

	if( histpos == history )
		return NULL;

	do {
		*entry = 0;
		old = entry;
		entry = strrchr( history, CR );
		*old = CR;
		comp = ( comp ? _fstrncmp(p->buffer, (entry ? entry+1 : history), len) : 1 );
	} while( entry && comp != 0 );
	
	return ( comp ? NULL : old + 1 );
}

/************************************************************************/
/*	Read a "record" from window (in port_reg)			*/
/*									*/
/*	Return: number of characters read (including CR + 0h)		*/
/************************************************************************/
int	read_win( void )
{
	PORT	far	*p;
	int		tabindex = -1;	/* original index in tab search */
	int		srchindex = -1;	/* original index in history search */
	char		modified = 0;	/* flag */
	int		key;		/* last key typed in */
	REG		lcl_reg;

	p = &reg2c(&port_reg)->port;	/* refresh current port properties */
	curline = p->curline;
	curcol = p->curcol;
	ulline = p->ulline;
	ulcol = p->ulcol;
	nlines = p->nlines;
	ncols = p->ncols;
	t_attrib = p->text;
	index = 0;
	vidmode = -1;
	histpos = history;
	p->buffer[0] = CR;

	do {				/* no macro running ? */
		if ( macro_reg.page == ADJPAGE(NIL_PAGE) ) {
			checkbounds();
			zputcur( curline + ulline, curcol + ulcol );
			zcuron();
			key = GETCH();
			zcuroff();
		} else
			key = MACRO_CONTINUE;
	
		if ( key == NULL ) {
			key = ( GETCH() << 8 );
			internimm( &lcl_reg, "PCS-MACRO-KEYS" );
			if ( sym_lookup( &lcl_reg, &gnv_reg ) ) {
				macro_reg.page = ADJPAGE(SPECFIX);
				macro_reg.disp = key >> 8;
				if ( eq_lookup( &macro_reg, &lcl_reg ) ) {
					take_cdr( &macro_reg );
					key = MACRO_CONTINUE;
				} else {
					macro_reg.page = NIL_PAGE;
					macro_reg.disp = NIL_DISP;
				}
			}	
		}

		if ( key != TAB )
			tabindex = -1;
		if ( key != UP_KEY && key != DOWN_KEY )
			srchindex = -1;

		p = &reg2c(&port_reg)->port;	/* reload port page */

		switch ( key ) {
			case CTRL_B:
			case LEFT_KEY: {
				if ( index > 0 ) index--, curcol--;
				break;
			}
			case CTRL_F:
			case RIGHT_KEY: {
				if ( p->buffer[index] != CR ) index++, curcol++;
				break;
			}
			case CTRL_P:
			case UP_KEY:
				if( srchindex == -1 )
					srchindex = index;
			{
				char	*histfound = searchfwd( srchindex );

				endkey();
				if ( modified ) {
					inhistory( p->buffer, index );
					modified = 0;
					if( histfound )
						histfound += index + 1;
				}
				if( histfound )
					histpos = histfound;
				else
					srchindex = -1;

				if ( histpos != histend ) {
					backdelto( 0 );
					fromhistory();
				}
				break;
			}
			case CTRL_N:	
			case DOWN_KEY:
				if( srchindex == -1 )
					srchindex = index;
			{
				char	*histfound = searchbwd( srchindex );

				endkey();
				if ( modified ) {
					inhistory( p->buffer, index );
					modified = 0;
					if( histfound )
						histfound += index + 1;
				}
				if( histfound )
					histpos = histfound;
				else {
					srchindex = -1;
					scanhistorybwd();
				}

				backdelto( 0 );
				if ( histpos != history ) {
					unsigned char	*remember = histpos;

					scanhistorybwd();
					fromhistory();
					histpos = remember;
				}
				break;
			}
			case ALT_B:
			case CTRL_LEFT_KEY: {	/* word left */
				wordleft();
				break;
			}
			case ALT_F:
			case CTRL_RIGHT_KEY: {	/* word right */
				wordright();
				break;
			}
			case CTRL_A:
			case HOME_KEY: {
				homekey();
				break;
			}
			case CTRL_E:
			case END_KEY: {
				endkey();
				break;
			}
			case CTRL_HOME_KEY: {	/* delete to home */
				backdelto( 0 );
				break;
			}
			case CTRL_K:
			case ALT_K:
			case CTRL_END_KEY: { 	/* delete to end */
				int	pos = index;
				endkey();
				backdelto( pos );
				break;
			}
			case ALT_I:
			case INSERT_KEY: {
				insert_m = !( insert_m );
				break;
			}
			case CTRL_D:
			case DELETE_KEY: {
				PORT far *p = &reg2c(&port_reg)->port;
				if(p->buffer[index] != CR) delkey( );
				break;
			}
			case BACKSPACE: {
				if ( index > 0 ) backdelto ( index - 1 );
				break;
			}
			case DEL: {		/* delete word left */
				int	newpos, pos = index;
				int	line = curline, col = curcol;
				wordleft();
				newpos = index;
				curcol = col, curline = line, index = pos;
				backdelto( newpos );
				break;
			}
			case ALT_D:
			case CTRL_DEL_KEY: {	/* delete word right */
				int	pos = index;
				wordright();
				backdelto( pos );
				break;
			}
			case CTRL_W:
			case ESCAPE: {		/* delete entry */
				modified = 0;
				endkey();
				backdelto( 0 );
				histpos = history;
				break;
			}
			
			case ENTER_KEY:		/* grey enter key */
				key = CR;
			case LF:		/* ignore LF */
			case CR:		/* proceed CR later */
				break;

			case MACRO_CONTINUE: {
				unsigned char	*txt = NULL;

				switch ( ptype[CORRPAGE(macro_reg.page)] ) {
					case LISTTYPE: {
						lcl_reg = macro_reg;
						take_car( &lcl_reg );
						take_cdr( &macro_reg );
						txt = string_asciz( &lcl_reg );
						key = CR;
						break;
					}
					case STRTYPE:
						txt = string_asciz( &macro_reg );
					default: {
						macro_reg.page = ADJPAGE(NIL_PAGE);
						macro_reg.disp = NIL_DISP;
					}
				}

				if ( txt ) {
					unsigned char	*c;

					modified = 1;
					for (c = txt; *c != 0 && *c != CR; c++) {
						putkey( *c );
						checkbounds();
					}
					rlsstr( txt );
					if ( *c == CR ) key = CR;
				}
				break;
			}

			case TAB: {
				int		begindex, pos, line, col, len, i;
				unsigned char	*search, *fnd, far *c;

				if ( tabindex >= 0 )
					while ( index > tabindex ) {
						index--, curcol--;
						checkbounds();
					}
				else tabindex = index;

				pos = index, line = curline, col = curcol;
				wordleft();
				begindex = index;
				curcol = col, curline = line, index = pos;
				
				for ( c = &p->buffer[index]; !is_separator( *c ); c++ );
				pos = FP_OFF(c) - FP_OFF(&p->buffer[begindex]);
				search = (unsigned char *)malloc(pos + 1);
				*(search += pos) = 0;
				while ( c > &p->buffer[begindex] )
					*(--search) = *(--c);

				len = index - begindex;	/* delete previous tab */
				pos = index;
				i = strlen(search) - len;
				while ( i-- ) {
					index++, curcol++;
					checkbounds();
				}
				backdelto( pos );

				if ( begindex > 0 && p->buffer[begindex-1] == '"' )
				{
					fnd = ifile( search, len);
					if( fnd && p->buffer[index] == '"')
						delkey();
				} else {
					get_maxenv( &lcl_reg);
					fnd = ilookup( search, len, CORRPAGE(lcl_reg.page), lcl_reg.disp);
				}
				if ( fnd ) {
					int		old_mode = insert_m;
					unsigned char	*c;

					modified = 1;
					backdelto( begindex );
					insert_m = 1;
					for (c = fnd; *c != 0 ; c++) {
						putkey( *c );
						checkbounds();
					}
					insert_m = old_mode;
					rlsstr(fnd);
				}
				rlsstr(search);
				break;
			}

			default: if ( (key & 0xff00) == 0 ) {
				modified = 1;
				putkey( key );
			}

		}
	} while ( key != CR );
	
	matchdone();			/* wipe out local regs for GC */
	endkey();
	p = &reg2c(&port_reg)->port;	/* reload port page */
	inhistory( p->buffer, index );
	curcol = 0, curline++;
	checkbounds();
	index++;

	if ( trns_reg.page != ADJPAGE(NIL_PAGE) && (p->winflags & W_TRANS) ) {
		REG	memo;
		int	pos;

		p->buffer[index] = LF;
		memo = port_reg;
		ssetadr( trns_reg.page, trns_reg.disp );
		wrap( index );
		for (pos = 0; pos <= index; pos++)
			givechar( p->buffer[pos] );
		ssetadr( memo.page, memo.disp );
	}

	p->buffer[index] = 0;
	p->curline = curline;
	p->curcol = curcol;

	return index+1;
}

/************************************************************************/
/*	Push a string into history buffer (for %push-history opcode)	*/
/*									*/
/*	syntax: int pushhistory(REGPTR)					*/
/*									*/
/************************************************************************/
int	pushhistory(REGPTR reg)
{
	if ( ptype[CORRPAGE(reg->page)] == STRTYPE ) {
		STRING	far	*s = &reg2c(reg)->string;
		int		length = s->len;
		
		if ( length < 0 )
			length += sizeof(POINTER);
		else
			length -= BLK_OVHD;
		if ( length < BUFFSIZE - 1 ) {
			inhistory ( s->buffer, length );
		}
		return 0;
	}
	set_src_error("%PUSH-HISTORY", 1, reg);
	return -1;
}

/************************************************************************/
/*	Get the n-th item from history (for %get-history opcode)	*/
/*									*/
/*	syntax: int gethistory(REGPTR)					*/
/*									*/
/*	On entry, *REGPTR is a fixnum greather (or equal) than zero	*/
/*	On exit, *REGPTR is set to the newly allocated string		*/
/*									*/
/************************************************************************/
int	gethistory(REGPTR reg)
{
	if ( reg->page == ADJPAGE(SPECFIX) ) {
		unsigned char	*memo = histpos;
		unsigned	num = reg->disp;

		histpos = history;
		while ( num-- > 0 )
			scanhistoryfwd();
		if ( histpos < histend ) {
			unsigned char	*beginning = histpos;

			scanhistoryfwd();
			*(--histpos) = 0;	/* zeroes last CR */
			alloc_string( reg, beginning );
			*(histpos) = CR;
		} else {
			reg->page = ADJPAGE(NIL_PAGE);
			reg->disp = NIL_DISP;
		}
		histpos = memo;
		return 0;
	}
	set_src_error("%GET-HISTORY", 1, reg);
	return -1;
}


/************************************************************************/
/*	Push a single char back into the input buffer			*/
/************************************************************************/
void	pushchar( void )
{
	PORT	far	*p;
	
	p = &reg2c(&port_reg)->port;	/* reload port page */

	if ( p->bufpos > 0 ) 
		p->bufpos--;
	else {
		zprintf("[VM INTERNAL ERROR] pushchar failed (cannot UNREAD-CHAR)\n");
		force_debug();
	}
}
